/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.navigator.ObjectQueryInstance;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.xml.XmlObjectFactory;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.javatools.util.Version;

class XmlCatalogsInstance
extends AbstractItemInstance
implements DBCatalogsInstance {
    private XmlCatalogsImpl m_impl;

    XmlCatalogsInstance(XmlObjectFactory xmlObjectFactory, XmlCatalogsImpl xmlCatalogsImpl) {
        super(xmlObjectFactory);
        this.setDescriptor(xmlCatalogsImpl);
        this.m_impl = xmlCatalogsImpl;
    }

    public List<DBChildInstance> listChildren() throws SQLException, AbortException {
        return this.listChildren(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBChildInstance> listChildren(QueryProgressListener queryProgressListener) throws SQLException, AbortException {
        ArrayList<DBChildInstance> arrayList = new ArrayList<DBChildInstance>();
        XmlObjectFactory xmlObjectFactory = (XmlObjectFactory)this.getObjectFactory();
        Version version = xmlObjectFactory.getVersion();
        Query query = this.m_impl.getQueries().getQuery(version);
        ObjectQueryInstance objectQueryInstance = new ObjectQueryInstance("CATALOGS", query);
        for (String object : this.getPropertyKeys()) {
            objectQueryInstance.setRequiredValue(object, this.getProperty(object));
        }
        this.lockConnection("listChildren");
        Iterator<Object> iterator = null;
        try {
            iterator = objectQueryInstance.executeQuery(xmlObjectFactory.getConnection(), queryProgressListener);
        }
        finally {
            this.unlockConnection();
        }
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String string = (String)map.get("CATALOG");
            if (string == null) continue;
            DBCatalogInstance dBCatalogInstance = xmlObjectFactory.createCatalogInstance(string);
            for (Map.Entry entry : map.entrySet()) {
                dBCatalogInstance.setProperty((String)entry.getKey(), entry.getValue());
            }
            arrayList.add(dBCatalogInstance);
        }
        return arrayList;
    }

    @Override
    public boolean promptForFilter() {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public void clearFilter() {
    }

    @Override
    public boolean canHaveFilter() {
        return false;
    }
}

