/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlSupport;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.config.Preferences;
import oracle.ide.runner.Debugger;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;

final class OraPls {
    private Connection m_conn;
    private String m_user;
    private Logger logger = Logger.getLogger(OraPls.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraPls(Connection connection) throws SQLException {
        this.m_conn = connection;
        if (!Connections.getInstance().lock(connection)) {
            throw new IllegalStateException("Cannot lock connection");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.m_user = databaseMetaData.getUserName();
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraSubmitResults plsSubmit(String string, String string2) {
        OraSubmitResults oraSubmitResults = new OraSubmitResults();
        if (!Connections.getInstance().lock(this.m_conn)) {
            oraSubmitResults.setSubmitFailed(true);
            oraSubmitResults.addError(new PlSqlErrorInfo(0, 0, "Unable to lock connection for compilation."));
            return oraSubmitResults;
        }
        try {
            Object object;
            Object object2;
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_conn);
            Debugger debugger = Debugger.getDebugger();
            if (debugger.isDebugging()) {
                oraSubmitResults.setSubmitFailed(true);
                oraSubmitResults.addError(new PlSqlErrorInfo(0, 0, ConnectionArb.getString((String)"ERROR_COMPILING_WHILE_DEBUGGING")));
                OraSubmitResults oraSubmitResults2 = oraSubmitResults;
                return oraSubmitResults2;
            }
            Lexer lexer = PlsqlParser.createSqlLexer();
            lexer.setTextBuffer(TextBufferFactory.createReadTextBuffer((String)string2));
            LexerToken lexerToken = lexer.createLexerToken();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = -1;
            block34: while (true) {
                int n2 = lexer.lex(lexerToken);
                int n3 = lexerToken.getStartOffset();
                int n4 = lexerToken.getEndOffset();
                object2 = lexer.getTextBuffer().getString(n3, n4 - n3);
                switch (n2) {
                    case 392: {
                        string5 = "FUNCTION";
                        continue block34;
                    }
                    case 752: {
                        string5 = "PROCEDURE";
                        continue block34;
                    }
                    case 702: {
                        string5 = "PACKAGE";
                        continue block34;
                    }
                    case 975: {
                        string5 = "TYPE";
                        continue block34;
                    }
                    case 188: {
                        if ("PACKAGE".equals(string5)) {
                            string5 = "PACKAGE BODY";
                            continue block34;
                        }
                        if (!"TYPE".equals(string5)) continue block34;
                        string5 = "TYPE BODY";
                        continue block34;
                    }
                    case 1112: {
                        string5 = "TRIGGER";
                        continue block34;
                    }
                    case 0: 
                    case 80: 
                    case 160: 
                    case 815: 
                    case 1050: 
                    case 1080: {
                        break block34;
                    }
                    case 48: 
                    case 49: {
                        continue block34;
                    }
                    case 1058: {
                        bl = true;
                        continue block34;
                    }
                    case 801: 
                    case 1094: {
                        continue block34;
                    }
                    default: {
                        if (string4 != null) {
                            if (!bl2) break block34;
                            string3 = string4;
                        } else {
                            n = n3;
                        }
                        string4 = dBUtil.scrubObjectName((String)object2);
                        bl2 = false;
                        continue block34;
                    }
                    case 72: {
                        bl2 = true;
                        if (string4 != null) continue block34;
                        this.logger.info("Oops! Dot found before name");
                        continue block34;
                    }
                }
                break;
            }
            if (string3 == null && string != null && ModelUtil.areDifferent((Object)this.m_user, (Object)(string3 = string)) && n != -1) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(string2.length() + 40);
                fastStringBuffer.append(string2.substring(0, n));
                fastStringBuffer.append(DBUtil.addDoubleQuote((String)string));
                fastStringBuffer.append('.');
                fastStringBuffer.append(string2.substring(n));
                string2 = fastStringBuffer.toString();
            }
            if (!bl) {
                Query query = PlSqlSupport.getQuery(this.m_conn, "CREATE_TEXT");
                string2 = MessageFormat.format(query.getSql(), string2);
            }
            this.setWarningFlags();
            Statement statement = null;
            ResultSetWrapper resultSetWrapper = null;
            try {
                block48: {
                    try {
                        statement = this.m_conn.createStatement();
                        statement.setEscapeProcessing(false);
                        object = string2;
                        if (string5 == "TYPE" && DBConfig.getInstance().getBoolean("DROPTYPEFORCE").booleanValue()) {
                            statement.execute("drop type " + string3 + "." + string4 + " force");
                        }
                        statement.execute((String)object);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == 2303 && !DBConfig.getInstance().getBoolean("DROPTYPEFORCE").booleanValue() && string5 == "TYPE") {
                            oraSubmitResults.addError(new PlSqlErrorInfo(1, 1, "ORA-02303: can't drop or replace a type with type or table dependents.  SQLDev advices setting \"Drop Type Force\" preference"));
                        }
                        if (sQLException.getErrorCode() == 24344) break block48;
                        oraSubmitResults.setSubmitFailed(true);
                        throw sQLException;
                    }
                }
                object = PlSqlSupport.getQuery(this.m_conn, "COMPILER_ERRORS");
                object2 = new HashMap();
                object2.put("NAME", string4);
                object2.put("TYPE", string5);
                object2.put("OWNER", string3);
                resultSetWrapper = dBUtil.executeQuery(object.getSql(), (Map)object2);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    int n5 = resultSet.getInt(1);
                    int n6 = resultSet.getInt(2);
                    String string6 = resultSet.getString(3);
                    String string7 = resultSet.getString(4);
                    boolean bl3 = "ERROR".equals(string7);
                    oraSubmitResults.addError(new PlSqlErrorInfo(n5 + PlSqlNode.offset(string2, string5), n6, string6, !bl3));
                }
            }
            catch (SQLException sQLException) {
                while (object != null) {
                    oraSubmitResults.addError(new PlSqlErrorInfo(0, 0, ((Throwable)object).getMessage()));
                    object = ((SQLException)object).getNextException();
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
            object = oraSubmitResults;
            return object;
        }
        finally {
            Connections.getInstance().unlock(this.m_conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWarningFlags() {
        Preferences preferences;
        GlobalSettings globalSettings;
        PlSqlCompilerOptions plSqlCompilerOptions;
        if (Connections.getInstance().isOracle(this.m_conn) && DBUtil.checkVersion((Connection)this.m_conn, null, (Version)new Version("10.1")) && (plSqlCompilerOptions = (globalSettings = GlobalSettings.createGlobalSettings((PropertyStorage)(preferences = Preferences.getPreferences()))).getPlSqlCompilerOptions()) != null) {
            Statement statement = null;
            try {
                statement = this.m_conn.prepareCall(PlSqlSupport.getQuery(this.m_conn, "WARNINGS_FLAG").getSql());
                for (PlSqlCompilerOptions.WarningCategory warningCategory : PlSqlCompilerOptions.WarningCategory.values()) {
                    PlSqlCompilerOptions.WarningValue warningValue = plSqlCompilerOptions.getWarningValue(warningCategory);
                    if (warningValue == null) continue;
                    DBUtil.bind((PreparedStatement)statement, Arrays.asList(warningCategory.name(), warningValue.name(), "SESSION"));
                    statement.execute();
                }
            }
            catch (SQLException sQLException) {
                SQLException sQLException2;
                while (sQLException2 != null) {
                    this.logger.log(Level.SEVERE, "", sQLException2);
                    sQLException2 = sQLException2.getNextException();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

