/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.raptor.navigator.net.project.TransientURLFileSystemHelper;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;

public final class TransientNodeFactory {
    private static ExecutorService s_service = null;
    private static NodeListener s_listener = new NodeListener(){

        public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
            Node node = nodeEvent.getNode();
            if (bl) {
                TransientNodeFactory.addNode(node);
            } else {
                TransientNodeFactory.removeNode(node);
            }
        }
    };
    private static Collection<Node> s_saveList = new ArrayList<Node>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNode(Node node) {
        Object object = s_saveList;
        synchronized (object) {
            s_saveList.add(node);
        }
        object = TransientNodeFactory.class;
        synchronized (TransientNodeFactory.class) {
            if (s_service == null) {
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
                scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        Iterator iterator = s_saveList.iterator();
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            iterator.remove();
                            try {
                                node.save();
                            }
                            catch (IOException iOException) {
                                TransientURLFileSystemHelper.LOGGER.severe(iOException.getLocalizedMessage());
                            }
                        }
                    }
                }, 5L, 5L, TimeUnit.SECONDS);
                s_service = scheduledExecutorService;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeNode(Node node) {
        Collection<Node> collection = s_saveList;
        synchronized (collection) {
            s_saveList.remove(node);
        }
    }

    public static <V extends Node> V findOrCreate(Class<V> clazz, String string) throws IllegalAccessException, InstantiationException {
        URL uRL = TransientURLFileSystemHelper.createTransientURL(string);
        Node node = NodeFactory.findOrCreate(clazz, (URL)uRL);
        node.addNodeListener(s_listener);
        return (V)node;
    }
}

