/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public abstract class DefaultFormatHelper
extends DBURLFormatHelper {
    private static int CNAME_PART = 0;
    private static int CATALOG_PART = 1;
    private static int SCHEMA_PART = 2;
    private static int BASETYPE_PART = 3;
    private static int NAME_PART = 4;
    private static int CHILDTYPE_PART = 5;
    private static int CHILDNAME_PART = 6;
    private static Map<URL, String[]> s_parsedURLs = new WeakHashMap<URL, String[]>();

    protected DefaultFormatHelper(String string) {
        super(string);
    }

    @Override
    protected String getConnectionNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, CNAME_PART);
    }

    @Override
    protected String getCatalogImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, CATALOG_PART);
    }

    @Override
    protected String getSchemaImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, SCHEMA_PART);
    }

    @Override
    protected String getBaseTypeImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, BASETYPE_PART);
    }

    @Override
    protected String getNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, NAME_PART);
    }

    @Override
    protected Icon getIconImpl(URL uRL) {
        Icon icon = null;
        try {
            String string = this.getConnectionNameImpl(uRL);
            ObjectFactory objectFactory = ObjectFactory.getFactory(string, Connections.getInstance().getConnection(string));
            DatabaseObject databaseObject = objectFactory.getObjectDescriptor(this.getBaseTypeImpl(uRL));
            if (databaseObject != null) {
                icon = databaseObject.getIcon();
            }
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return icon;
    }

    @Override
    protected String getChildTypeImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, CHILDTYPE_PART);
    }

    @Override
    protected String getChildNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return this.getPart(uRL, CHILDNAME_PART);
    }

    private String getPart(URL uRL, int n) {
        String string;
        if (uRL == null || !this.getProtocol().equals(uRL.getProtocol())) {
            return null;
        }
        String[] stringArray = s_parsedURLs.get(uRL);
        if (stringArray == null) {
            String string2;
            int n2;
            stringArray = new String[CHILDNAME_PART + 1];
            string = URLFileSystem.getPath((URL)uRL);
            for (int i = 0; i < stringArray.length; ++i) {
                n2 = string.indexOf(47);
                if (n2 < 0) {
                    stringArray[i] = DefaultFormatHelper.decode(string);
                    break;
                }
                stringArray[i] = DefaultFormatHelper.decode(string.substring(0, n2));
                string = string.substring(n2 + 1);
            }
            if (ModelUtil.hasLength((String)(string2 = uRL.getRef()))) {
                n2 = string2.indexOf(47);
                if (n2 >= 0) {
                    stringArray[DefaultFormatHelper.CHILDTYPE_PART] = DefaultFormatHelper.decode(string2.substring(0, n2));
                    stringArray[DefaultFormatHelper.CHILDNAME_PART] = DefaultFormatHelper.decode(string2.substring(n2 + 1));
                } else {
                    stringArray[DefaultFormatHelper.CHILDTYPE_PART] = DefaultFormatHelper.decode(string2);
                }
            }
            s_parsedURLs.put(uRL, stringArray);
        }
        return ModelUtil.hasLength((String)(string = stringArray[n])) ? string : null;
    }
}

