/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.jdbc.AbstractJDBCFolderInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCDBFolder;
import oracle.dbtools.raptor.navigator.jdbc.JDBCDBItem;
import oracle.dbtools.raptor.navigator.jdbc.JDBCObjectInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCObjectType;
import oracle.dbtools.raptor.navigator.jdbc.JDBCProceduresFolderInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCSchemaInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCTableFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class JDBCNavProvider
extends ObjectFactory {
    static final Logger LOGGER = Logger.getLogger(JDBCNavProvider.class.getName());
    private List<JDBCObjectType> m_types;
    private Map<String, List<String>> m_catalogsAndSchemas;

    public JDBCNavProvider(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
        this.initCatalogs();
    }

    @Override
    public DBSchemaInstance createSchemaInstance(String string) {
        JDBCSchemaInstance jDBCSchemaInstance = new JDBCSchemaInstance(this);
        jDBCSchemaInstance.setProperty("SCHEMA", string);
        jDBCSchemaInstance.setProperty("ConnectionType", this.getConnectionType());
        return jDBCSchemaInstance;
    }

    @Override
    public DBCatalogInstance createCatalogInstance(String string) {
        return null;
    }

    @Override
    public DBChildInstance createChildInstance(String string, String string2) {
        return null;
    }

    @Override
    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        AbstractJDBCFolderInstance abstractJDBCFolderInstance = "PROCEDURE".equals(string) ? new JDBCProceduresFolderInstance(this, (JDBCDBFolder)databaseFolder) : new JDBCTableFolderInstance(this, (JDBCDBFolder)databaseFolder);
        abstractJDBCFolderInstance.setProperty("TYPE", string);
        return abstractJDBCFolderInstance;
    }

    @Override
    public DBObjectInstance createNodeInstance(String string) {
        JDBCObjectInstance jDBCObjectInstance = new JDBCObjectInstance(this, (JDBCDBItem)this.getObjectDescriptor(string));
        jDBCObjectInstance.setProperty("TYPE", string);
        return jDBCObjectInstance;
    }

    @Override
    public DBCatalogsInstance getCatalogsInstance() {
        return null;
    }

    @Override
    public DatabaseObject getObjectDescriptor(String string) {
        ObjectType objectType = this.getObjectType(string);
        return objectType != null ? objectType.getNode() : null;
    }

    @Override
    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        return null;
    }

    @Override
    protected ObjectType[] listTypesImpl(String string) {
        return this.listTypes();
    }

    @Override
    public ObjectType[] listTypes() {
        if (this.m_types == null) {
            this.initTypes();
        }
        return this.m_types.toArray(new JDBCObjectType[0]);
    }

    private ObjectType getObjectType(String string) {
        assert (string != null);
        if (this.m_types == null) {
            this.initTypes();
        }
        for (JDBCObjectType jDBCObjectType : this.m_types) {
            if (!ModelUtil.areEqual((Object)string, (Object)jDBCObjectType.getType())) continue;
            return jDBCObjectType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTypes() {
        this.m_types = new ArrayList<JDBCObjectType>();
        DatabaseMetaData databaseMetaData = null;
        ResultSet resultSet = null;
        try {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getTableTypes();
            String string = this.getConnectionType();
            Icon icon = RaptorImagesArb.getIcon("TABLE_FOLDER");
            Icon icon2 = OracleIcons.getIcon((String)"table.png");
            HashSet<Object> hashSet = new HashSet<Object>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                hashSet.add(string2);
            }
            for (String string3 : hashSet) {
                this.m_types.add(new JDBCObjectType(string, string3, icon, icon2));
            }
            if (databaseMetaData.supportsStoredProcedures()) {
                this.m_types.add(new JDBCObjectType(string, "PROCEDURE", icon, icon2));
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isShowAllSchemasAtTopLevel() {
        return super.isShowAllSchemasAtTopLevel();
    }

    @Override
    public boolean isSupportsCatalog() {
        return super.isSupportsCatalog();
    }

    @Override
    public boolean isShowOtherSchemas() {
        return super.isShowOtherSchemas();
    }

    private DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = null;
        Connection connection = this.getConnection();
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        return databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatalogs() {
        DatabaseMetaData databaseMetaData;
        if (this.m_catalogsAndSchemas == null && (databaseMetaData = this.getMetaData()) != null) {
            ResultSet resultSet = null;
            try {
                this.m_catalogsAndSchemas = new HashMap<String, List<String>>();
                resultSet = databaseMetaData.getCatalogs();
                while (resultSet.next()) {
                    this.m_catalogsAndSchemas.put(resultSet.getString(1), new ArrayList());
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
            try {
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    List<String> list = this.m_catalogsAndSchemas.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.m_catalogsAndSchemas.put(string2, list);
                    }
                    list.add(string);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
        }
    }
}

