/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.dbapi;

import java.sql.DatabaseMetaData;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;

public class MetadataConnectionType
extends ConnectionType {
    private ConnectionInfo m_cinfo;
    private DatabaseMetaData m_dbmd;
    private static final Logger LOGGER = Logger.getLogger(MetadataConnectionType.class.getName());

    public MetadataConnectionType(ConnectionInfo connectionInfo) {
        this.m_cinfo = connectionInfo;
        try {
            this.m_dbmd = connectionInfo.getConnection().getMetaData();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
        }
        this.setDetails(new MetadataConnectionTypeDetails());
    }

    private class MetadataConnectionTypeDetails
    extends ConnectionTypeDetails {
        private MetadataConnectionTypeDetails() {
        }

        @Override
        public String getConnectionPanel() {
            return null;
        }

        @Override
        public String getConnectionPanelLabel() {
            return null;
        }

        @Override
        public FilterDetails getFilterDetails() {
            return null;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public Integer getPreferredFetchSize() {
            return null;
        }

        @Override
        public String getProviderClass() {
            return null;
        }

        @Override
        public String getType() {
            return MetadataConnectionType.this.m_cinfo.getConnectionType();
        }

        @Override
        public boolean isOtherSchemasSupported() {
            boolean bl = false;
            try {
                bl = MetadataConnectionType.this.m_dbmd.getSchemas().next();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            return bl;
        }

        @Override
        public boolean isRowIdSupported() {
            boolean bl = false;
            return bl;
        }

        @Override
        public boolean isShowAllSchemasAtTopLevel() {
            return false;
        }

        @Override
        public boolean isSupportsAutocommit() {
            boolean bl = false;
            try {
                bl = MetadataConnectionType.this.m_dbmd.supportsTransactions();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            return bl;
        }

        @Override
        public boolean isSupportsCatalog() {
            boolean bl = false;
            try {
                bl = MetadataConnectionType.this.m_dbmd.getCatalogs().next();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            return bl;
        }
    }
}

