/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.navigator.impl.RefreshableFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.navigator.NavigatorManager;
import oracle.ideimpl.explorer.ExplorerNode;

public class NavActionListener
implements IObjectActionListener {
    private NavigatorManager _navigator;

    public NavActionListener(NavigatorManager navigatorManager) {
        this._navigator = navigatorManager;
    }

    @Override
    public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
    }

    @Override
    public void reload(final String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, final DBObject dBObject) {
        NavActionListener.invokeUI(new Runnable(){

            @Override
            public void run() {
                TreeExplorer treeExplorer = NavActionListener.this.getTree();
                if (treeExplorer != null) {
                    NavActionListener.refresh(treeExplorer, NavActionListener.getTnode(dBObject, treeExplorer), string);
                }
            }
        });
    }

    @Override
    public void reloadParent(final String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, final DBObject dBObject) {
        NavActionListener.invokeUI(new Runnable(){

            @Override
            public void run() {
                TreeExplorer treeExplorer = NavActionListener.this.getTree();
                if (treeExplorer != null) {
                    NavActionListener.refresh(treeExplorer, NavActionListener.getParentTNode(NavActionListener.getTnode(dBObject, treeExplorer)), string);
                }
            }
        });
    }

    @Override
    public void removedFromParent(final String string, ObjectAction objectAction, Map<String, Object> map, final List<String> list, final DBObject dBObject) {
        NavActionListener.invokeUI(new Runnable(){

            @Override
            public void run() {
                TreeExplorer treeExplorer = NavActionListener.this.getTree();
                if (treeExplorer != null) {
                    NavActionListener.this.makeSelectionAfterDelete(treeExplorer);
                    TNode tNode = NavActionListener.getTnode(dBObject, treeExplorer);
                    TNode tNode2 = NavActionListener.getParentTNode(tNode);
                    NavActionListener.refresh(treeExplorer, tNode2, string);
                    NavActionListener.this.refreshParentSiblings(treeExplorer, tNode2, string, list);
                }
            }
        });
    }

    private void makeSelectionAfterDelete(TreeExplorer treeExplorer) {
        if (treeExplorer != null) {
            JTree jTree = treeExplorer.getJTree();
            DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
            TreePath treePath = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            Object object = null;
            Object object2 = null;
            Object object3 = null;
            TreePath treePath2 = null;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            if (jTree.getSelectionCount() == 1) {
                treePath = jTree.getSelectionPath();
                objectArray = treePath.getPath();
                if (objectArray != null && objectArray.length > 1) {
                    object = objectArray[objectArray.length - 2];
                    object2 = objectArray[objectArray.length - 1];
                } else if (objectArray != null && objectArray.length == 1) {
                    object = null;
                    object2 = objectArray[0];
                }
                n = defaultTreeModel.getIndexOfChild(object, object2);
                n3 = defaultTreeModel.getChildCount(object);
                if (n < n3 - 1) {
                    n2 = n;
                    objectArray2 = new Object[objectArray.length];
                    object3 = defaultTreeModel.getChild(object, n + 1);
                } else if (n == n3 - 1) {
                    if (n > 0) {
                        n2 = n - 1;
                        objectArray2 = new Object[objectArray.length];
                        object3 = defaultTreeModel.getChild(object, n - 1);
                    } else {
                        objectArray2 = new Object[objectArray.length - 1];
                    }
                }
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    objectArray2[i] = objectArray[i];
                }
                if (n2 >= 0) {
                    objectArray2[objectArray.length - 1] = object3;
                }
                treePath2 = new TreePath(objectArray2);
            }
            if (treePath2 != null) {
                jTree.setSelectionPath(treePath2);
            }
        }
    }

    private TreeExplorer getTree() {
        TreeExplorer treeExplorer = null;
        if (this._navigator != null) {
            treeExplorer = this._navigator.getNavigatorWindow().getTreeExplorer();
        }
        return treeExplorer;
    }

    private void refreshParentSiblings(TreeExplorer treeExplorer, TNode tNode, String string, List<String> list) {
        boolean bl = false;
        if (list != null) {
            for (String string2 : list) {
                if (string2 == null || !string2.equalsIgnoreCase("cascade constraints")) continue;
                bl = true;
                break;
            }
        }
        if (bl && tNode != null) {
            Object object = null;
            while ((object = ((ExplorerNode)tNode).getNextSibling()) != null) {
                String string2;
                string2 = ((DefaultMutableTreeNode)object).toString();
                tNode = (ExplorerNode)object;
                if (!string2.equalsIgnoreCase("Indexes") && !string2.equalsIgnoreCase("Triggers")) continue;
                NavActionListener.refresh(treeExplorer, (TNode)object, string);
            }
        }
    }

    public static TNode getTnode(DBObject dBObject, TreeExplorer treeExplorer) {
        return treeExplorer == null ? null : treeExplorer.searchTNodeBreadthFirst(dBObject.getElement(), treeExplorer.getRoot());
    }

    public static TNode getParentTNode(TNode tNode) {
        return tNode == null ? null : tNode.getAncestorTNode(RefreshableFolder.class, true);
    }

    public static void refresh(TreeExplorer treeExplorer, TNode tNode, String string) {
        if (tNode != null) {
            List list = ExplorerContext.storeSelectionState((TreeExplorer)treeExplorer);
            List list2 = ExplorerContext.storeExpansionState((TNode)tNode, (TreeExplorer)treeExplorer);
            treeExplorer.refresh(tNode);
            NavActionListener.expandNextLevel(1, tNode, treeExplorer, list2, list, string);
        }
    }

    private static void expandNextLevel(final int n, final TNode tNode, final TreeExplorer treeExplorer, final List<?> list, final List<?> list2, final String string) {
        if (n > list.size()) {
            return;
        }
        NavActionListener.invokeUI(new Runnable(){

            @Override
            public void run() {
                DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>("NavActionListener.expandNextLevel-" + n, IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true){

                    protected Void doWork() throws TaskException {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    treeExplorer.searchTNode(null, tNode);
                                    if (n < list.size()) {
                                        ExplorerContext.restoreExpansionState((TNode)tNode, (TreeExplorer)treeExplorer, (List)list);
                                    } else {
                                        ExplorerContext.restoreSelectionState((TreeExplorer)treeExplorer, (List)list2);
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            throw new TaskException((Throwable)exception);
                        }
                        return null;
                    }

                    @Override
                    public String getConnectionName() {
                        return string;
                    }

                    @Override
                    public String getQuery() {
                        return "";
                    }
                };
                databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        NavActionListener.expandNextLevel(n + 1, tNode, treeExplorer, list, list2, string);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            }
        });
    }

    public static void invokeUI(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

