/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.raptor.navigator.CreateActionProvider;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;

public final class DefaultCreateActionProvider
implements CreateActionProvider {
    private static Set<String> s_unsupportedTypes = new HashSet<String>(Arrays.asList("SYNONYM", "PUBLIC_SYNONYM"));

    public static IdeAction getDefaultNewAction(DBObject dBObject) {
        DBEditorFactory dBEditorFactory;
        Database database;
        IdeAction ideAction = null;
        String string = dBObject.getObjectFolderType();
        if (!s_unsupportedTypes.contains(string) && (database = DatabaseNavigatorController.getDatabase(dBObject.getConnectionName())) != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string)) != null) {
            ideAction = DatabaseNavigatorController.ACTION_NEWOBJECT;
            DatabaseNavigatorController.updateAction(ideAction, dBObject, database, string, dBEditorFactory);
        }
        return ideAction;
    }

    @Override
    public IdeAction getNewAction(Element element) {
        ObjectFolder objectFolder = (ObjectFolder)element;
        DBObject dBObject = new DBObject(objectFolder);
        return DefaultCreateActionProvider.getDefaultNewAction(dBObject);
    }

    @Override
    public IdeAction getEditAction(Element element) {
        IdeAction ideAction = null;
        if (element instanceof TextNode && element instanceof DatabaseNode && !((DatabaseNode)element).getObjectType().equals("XML SCHEMA")) {
            ideAction = DatabaseNavigatorController.ACTION_EDITOBJECT;
        } else if (element instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)element;
            String string = (String)databaseNode.getProperty("ConnectionName");
            String string2 = (String)databaseNode.getProperty("TYPE");
            Database database = DatabaseNavigatorController.getDatabase(string);
            if (database != null && DatabaseNavigatorController.canEditObject(databaseNode)) {
                ideAction = DatabaseNavigatorController.ACTION_EDITOBJECT;
                ideAction.putValue("DBObjectType", (Object)string2);
                ideAction.putValue("Database", (Object)database);
                ideAction.putValue("URL", (Object)databaseNode.getURL());
            }
        }
        return ideAction;
    }
}

