/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.navigator.ConnectionOwner;
import oracle.dbtools.raptor.navigator.ConnectionStores;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;

public class ConnectionStoresFilter
extends BaseRaptorFilter {
    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            LOGGER.info("Removing child " + element.getShortLabel());
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 == null) continue;
            try {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("child " + element.getShortLabel() + " not properly parented");
            }
            this.uncache(tNode2);
        }
        return tNode;
    }

    public void closeChildren() {
    }

    public Iterator<Element> getChildren() {
        ConnectionStores connectionStores = (ConnectionStores)this.getOwner().getData();
        return connectionStores.getChildren();
    }

    public Comparator<TNode> getComparator() {
        return StoreComparator.INSTANCE;
    }

    @Override
    protected Object getKey(Object object) {
        return object instanceof ConnectionOwner ? ((ConnectionOwner)object).getKey() : null;
    }

    private static class StoreComparator
    implements Comparator<TNode> {
        private static final StoreComparator INSTANCE = new StoreComparator();

        private StoreComparator() {
        }

        @Override
        public int compare(TNode tNode, TNode tNode2) {
            int n = 0;
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            if (element instanceof ConnectionOwner) {
                if (element2 instanceof ConnectionOwner) {
                    return ((ConnectionOwner)element).compareTo((ConnectionOwner)element2);
                }
                n = -1;
            } else {
                n = element2 instanceof Databases ? 1 : element.getShortLabel().compareTo(element2.getShortLabel());
            }
            return n;
        }
    }
}

