/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DeferredLoadingFilter;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;

public class CatalogFilter
extends DeferredLoadingFilter {
    @Override
    protected DeferredLoadingFilter.FilterLoadTask getLoadTask() {
        CatalogFolder catalogFolder = (CatalogFolder)this.getOwner().getData();
        String string = DBURLFormatHelper.getConnectionName(catalogFolder.getURL());
        return new CatalogFilterLoadTask(string);
    }

    @Override
    protected Object getKey(Object object) {
        return object instanceof SchemaFolder ? ((SchemaFolder)object).getURL() : super.getKey(object);
    }

    private class CatalogFilterLoadTask
    extends DeferredLoadingFilter.FilterLoadTask {
        CatalogFilterLoadTask(String string) {
            super(DatabaseNavigatorResources.getString("CATALOGS_LOAD_MSG"), string);
        }

        @Override
        protected List<Element> doWorkImpl() {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            CatalogFolder catalogFolder = (CatalogFolder)CatalogFilter.this.getOwner().getData();
            DBCatalogInstance dBCatalogInstance = catalogFolder.getCatalogInstance();
            String string = DBURLFormatHelper.getConnectionName(catalogFolder.getURL());
            String string2 = DBURLFormatHelper.getCatalog(catalogFolder.getURL());
            DBSchemasInstance dBSchemasInstance = dBCatalogInstance.getSchemasInstance();
            try {
                this.checkCanProceed();
                String string3 = CatalogFilter.getURLProtocol(catalogFolder);
                String string4 = (String)dBSchemasInstance.getProperty("ConnectionType");
                for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                    DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                    SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string3, string, string2, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, string4);
                    arrayList.add(schemaFolder);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

