/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.CatalogFilter;
import oracle.dbtools.raptor.navigator.CategoryFilter;
import oracle.dbtools.raptor.navigator.ConnectionFilter;
import oracle.dbtools.raptor.navigator.ConnectionStores;
import oracle.dbtools.raptor.navigator.ConnectionStoresFilter;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.navigator.ObjectFilter;
import oracle.dbtools.raptor.navigator.ObjectNodeFilter;
import oracle.dbtools.raptor.navigator.OtherSchemasFilter;
import oracle.dbtools.raptor.navigator.SchemaFilter;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public abstract class BaseNavigatorManager
extends DefaultNavigatorManager {
    public static final String DB_NAV_MENU_TAG = "db_nav";
    protected static final String VIEW_CATEGORY = "ViewCategory";
    private static List<BaseNavigatorManager> s_mgrs = new ArrayList<BaseNavigatorManager>();
    private static List<FilterDesc> s_filters = new ArrayList<FilterDesc>();

    public static void addFilter(Class<? extends Element> clazz, Class<? extends ChildFilter> clazz2, URLFilter uRLFilter) {
        for (BaseNavigatorManager baseNavigatorManager : s_mgrs) {
            baseNavigatorManager.registerFilter(clazz, clazz2, uRLFilter);
        }
        s_filters.add(new FilterDesc(clazz, clazz2, uRLFilter));
    }

    public static void registerObjectNodeClass(String string, Class<? extends Element> clazz) {
        BaseNavigatorManager.addFilter(clazz, ObjectNodeFilter.class, null);
    }

    public static void populateDatabaseNavigatorContextMenu(ContextMenu contextMenu, String ... stringArray) {
        ContextMenuListenersHook contextMenuListenersHook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
        if (contextMenuListenersHook != null) {
            for (String string : stringArray) {
                contextMenu.addContextMenuListener(contextMenuListenersHook.getListener(string));
            }
        }
    }

    protected BaseNavigatorManager() {
        s_mgrs.add(this);
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR;
    }

    protected String getAcceleratorFile() {
        return super.getAcceleratorFile();
    }

    public static boolean isDatabaseNavigatorContext(Context context) {
        return context.getView() instanceof NavWindow;
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new NavWindow(context, viewId.getId(), this.getTabTitle());
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        NavWindow navWindow = (NavWindow)navigatorWindow;
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        if (navigatorManager != null && navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setPosition((Dockable)navigatorManager.getNavigatorWindow(), 4, 0);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        super.initialize();
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        IdeAction ideAction = this.getShowAction();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        String string = (String)ideAction.getValue(VIEW_CATEGORY);
        if (string != null) {
            void var7_10;
            int n = Ide.findOrCreateCmdID((String)string);
            JMenu object = (JMenu)menubar.getChildById((Container)jMenu, n);
            if (object == null) {
                IdeAction ideAction2 = IdeAction.find((int)n);
                String string2 = (String)ideAction2.getValue("Name");
                Integer n2 = (Integer)ideAction2.getValue("MnemonicKey");
                JMenu jMenu2 = menubar.createSubMenu(string2, n2);
                jMenu2.setAction((Action)ideAction2);
                menubar.add((Component)jMenu2, jMenu, MenuConstants.SECTION_VIEW_ADDINS);
            }
            menubar.add((Component)jMenuItem, (JMenu)var7_10);
        } else {
            menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_ADDINS);
        }
        for (FilterDesc filterDesc : s_filters) {
            this.registerFilter(filterDesc.m_elemClass, filterDesc.m_filterClass, filterDesc.m_urlFilter);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_databaseconnections_html");
    }

    protected abstract String getTabTitle();

    public void addContextMenuListener(ContextMenuListener contextMenuListener, Class clazz) {
        NavWindow.getOrCreateContextMenu().addContextMenuListener(contextMenuListener, clazz);
    }

    public ContextMenu getContextMenu() {
        return NavWindow.getOrCreateContextMenu();
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        NavWindow.getOrCreateContextMenu().removeContextMenuListener(contextMenuListener);
    }

    static {
        BaseNavigatorManager.addFilter(DatabaseConnection.class, ConnectionFilter.class, null);
        BaseNavigatorManager.addFilter(ObjectFolder.class, ObjectFilter.class, null);
        BaseNavigatorManager.addFilter(ObjectNode.class, ObjectNodeFilter.class, null);
        BaseNavigatorManager.addFilter(OtherSchemasFolder.class, OtherSchemasFilter.class, null);
        BaseNavigatorManager.addFilter(CategoryFolder.class, CategoryFilter.class, null);
        BaseNavigatorManager.addFilter(SchemaFolder.class, SchemaFilter.class, null);
        BaseNavigatorManager.addFilter(CatalogFolder.class, CatalogFilter.class, null);
        BaseNavigatorManager.addFilter(ConnectionStores.class, ConnectionStoresFilter.class, null);
    }

    private static class FilterDesc {
        private Class<? extends Element> m_elemClass;
        private Class<? extends ChildFilter> m_filterClass;
        private URLFilter m_urlFilter;

        private FilterDesc(Class<? extends Element> clazz, Class<? extends ChildFilter> clazz2, URLFilter uRLFilter) {
            this.m_elemClass = clazz;
            this.m_filterClass = clazz2;
            this.m_urlFilter = uRLFilter;
        }
    }
}

