/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionResolver;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.TabColTest;
import oracle.dbtools.raptor.insight.Autocompleter;
import oracle.dbtools.util.Service;

public class GbyTest {
    private static int testNo = 0;
    private static boolean unitTestIsOK = true;
    static Set<RuleTuple> rules = GbyTest.gbyRules();
    static Earley earley = new Earley(rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
        }
    };
    private static int output = (Integer)GbyTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)GbyTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)GbyTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)GbyTest.earley.symbolIndexes.get("comment");
    private static int prompt = (Integer)GbyTest.earley.symbolIndexes.get("prompt");

    public static void main(String[] stringArray) throws Exception {
        DBUtil.setConnectionResolver((ConnectionResolver)new DefaultConnectionResolver());
        String string = Service.readFile(GbyTest.class, (String)"gby.test");
        List list = LexerToken.parse((String)string);
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.suggestions) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        GbyTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (unitTestIsOK) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    private static Set<RuleTuple> gbyRules() {
        try {
            String string = Service.readFile(TabColTest.class, (String)"TabColTest.grammar");
            List list = LexerToken.parse((String)string);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            treeSet.remove(new RuleTuple("prompt", new String[]{"\"sql fragment\""}));
            treeSet.add(new RuleTuple("prompt", new String[]{"'GROUP'", "'BY'"}));
            treeSet.add(new RuleTuple("prompt", new String[]{"prompt", "sql_token"}));
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for Gby test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            System.out.print("TEST#" + testNo++ + " -> ");
            if (GbyTest.assertion(parseNode, list, string)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                System.out.println("TEST#" + testNo++ + " ->\n" + GbyTest.query(parseNode2, list, string));
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            GbyTest.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            GbyTest.atest(parseNode3, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = null;
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(query)) {
                string2 = GbyTest.output(parseNode2, list, string);
                continue;
            }
            if (!parseNode2.contains(prompt)) continue;
            string3 = GbyTest.prompt(parseNode2, list, string);
        }
        if (!string2.equals(string3)) {
            for (int i = 0; i < string2.length() && i < string3.length(); ++i) {
                if (string2.charAt(i) == string3.charAt(i)) continue;
                int n = i + 30;
                String string4 = "...";
                if (string2.length() < n) {
                    n = string2.length();
                    string4 = "";
                }
                System.out.println(string2.substring(0, i) + " >>> " + string2.substring(i, n) + string4 + " <<<");
                break;
            }
            unitTestIsOK = false;
            return false;
        }
        return true;
    }

    private static String prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        return string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
    }

    private static String query(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = GbyTest.output(parseNode, list, string);
        return string2;
    }

    private static String output(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
        list = LexerToken.parse((String)string2);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, matrix);
        parseNode = sqlEarley.forest(list, matrix);
        return "group by " + Autocompleter.generateGBY(parseNode, list, string2, false, 0);
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end));
        return null;
    }
}

