/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.HarvestDoc;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.util.Service;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.TextTabber;
import oracle.javatools.editor.insight.ListInsightData;

public class DBListInsightData
implements ListInsightData {
    private Logger logger = Logger.getLogger(DBListInsightData.class.getName());
    protected ListModel instance = new ListModel(){

        public Object getElementAt(int n) {
            if (n >= DBListInsightData.this._matchingDataList.length || n < 0) {
                return null;
            }
            return DBListInsightData.this._matchingDataList[n];
        }

        @Override
        public int getSize() {
            return DBListInsightData.this._matchingDataList.length;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }
    };
    protected SuggestedItem[] _matchingDataList;
    final CompletionInsight _insight;
    private boolean completedOnce = false;
    private static final EditDescriptor _editDescriptor = new EditDescriptor("Undo Completion");

    DBListInsightData(CompletionInsight completionInsight) {
        this._insight = completionInsight;
    }

    public Object[] getData() {
        return this._matchingDataList;
    }

    public Object[] getMatchingData() {
        int n = this._insight.getAliacedPrefix().length();
        if (n > 0) {
            LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
            for (SuggestedItem suggestedItem : this._matchingDataList) {
                if ("...".equals(suggestedItem.getName()) || "TEMPLATE".equals(suggestedItem.getType())) {
                    linkedList.add(suggestedItem);
                    continue;
                }
                suggestedItem.setPrefixLength(n);
                linkedList.add(suggestedItem);
            }
            this._matchingDataList = new SuggestedItem[linkedList.size()];
            int n2 = 0;
            for (SuggestedItem suggestedItem : linkedList) {
                this._matchingDataList[n2++] = suggestedItem;
            }
        }
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object object) {
        if (this.completedOnce) {
            return false;
        }
        this.completedOnce = true;
        SuggestedItem suggestedItem = (SuggestedItem)object;
        String string = suggestedItem.toString();
        String string2 = suggestedItem.getType();
        if (string.startsWith("...")) {
            if (string2.equals("SNIPPET")) {
                this._insight.raiseSlimit = true;
            } else if (string2.equals("HISTORY")) {
                this._insight.raiseHlimit = true;
            } else if (string2.equals("TEMPLATE")) {
                this._insight.raiseTlimit = true;
            } else {
                this._insight.raiselimit = true;
            }
            return true;
        }
        BasicDocument basicDocument = this._insight.getDocument();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        basicEditorPane.beginEdit(DBListInsightData.getEditDescriptor());
        try {
            int n2;
            Object object2;
            Object object3;
            int[] nArray = this._insight.getInsightView().getSelectedIndices();
            if (n < this._insight.startCaretPosition) {
                boolean bl = false;
                return bl;
            }
            int n3 = suggestedItem.getPrefixLength();
            if (nArray.length > 1) {
                string = "";
                object3 = new String[nArray.length];
                int n4 = 0;
                for (int n5 : nArray) {
                    object3[n4++] = this._matchingDataList[n5].toString();
                }
                object2 = this.generateAliases((String[])object3);
                for (n2 = 0; n2 < ((String[])object3).length; ++n2) {
                    String string3 = object3[n2];
                    string = string3.indexOf(61) >= 0 ? string + (n2 == 0 ? "" : " AND ") + string3 : string + (n2 == 0 ? "" : ", ") + string3 + " " + (String)object2[n2];
                }
            }
            string = string.replace(HarvestDoc.getPlaceholderPrefix(), "[");
            string = string.replace(HarvestDoc.placeholderSuffix, "]");
            string = string.replace("&lt;", "<");
            string = string.replace("&gt;", ">");
            object3 = new LinkedList();
            StringBuilder stringBuilder = new StringBuilder();
            if (string.indexOf(32) > 0 && !"SNIPPET".equals(string2) && !"HISTORY".equals(string2)) {
                try {
                    SQLFormatter.getInstance();
                    object2 = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
                    string = object2.format(string);
                    string = CaseConverter.getState().convert(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object2 = ProcedureExtractor.indent(n, basicEditorPane);
            string = string.replace("\n", "\n" + (String)object2);
            n2 = n - n3;
            if (n3 > 0 && basicDocument.getText(n2, n3).contains("\n")) {
                n2 = DBListInsightData.tokenStart(this._insight.parser.src, n2);
            }
            basicDocument.remove(n2, n3);
            if (string.indexOf("]") > 0) {
                int n5;
                TextTabber textTabber = new TextTabber(basicEditorPane);
                n5 = 0;
                int n6 = -1;
                int n7 = 0;
                while ((n6 = string.indexOf("[", n5)) >= 0) {
                    stringBuilder.append(string.substring(n5, n6));
                    n5 = string.indexOf("]", n6) + "]".length();
                    object3.add(Service.pair((int)(n2 + n6 - n7), (int)(n2 + n5 - "]".length() - "[".length() - n7)));
                    stringBuilder.append(string.substring(n6 + "[".length(), n5 - "]".length()));
                    n7 += "[".length() + "]".length();
                }
                stringBuilder.append(string.substring(n5));
                basicDocument.insertString(n2, stringBuilder.toString(), null);
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    int n8 = (Integer)iterator.next();
                    textTabber.addRange(Service.X((int)n8), Service.Y((int)n8));
                }
                textTabber.setActive(true);
            } else {
                basicDocument.insertString(n2, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.warning("Exception occurred in completion: " + badLocationException);
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    private static int tokenStart(List<LexerToken> list, int n) {
        int n2 = n;
        if (list == null) {
            return n2;
        }
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin > n) break;
            if (lexerToken.type == Token.WS) continue;
            n2 = lexerToken.begin;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private String[] generateAliases(String[] stringArray) {
        String string7;
        String string2 = this._insight.prior.content.toUpperCase();
        if (!DBConfig.getInstance().getBoolean("AUTOGENERATEALIASES").booleanValue() || !"SELECT".equals(string2) && !"FROM".equals(string2)) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = "";
            }
            return stringArray2;
        }
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i].indexOf(".") > 0 ? stringArray[i].substring(stringArray[i].lastIndexOf(".") + 1) : stringArray[i];
        }
        String string3 = stringArray3[0];
        for (String stringArray4 : stringArray3) {
            string3 = DBListInsightData.commonPrefix(string3, stringArray4);
        }
        int n = 1;
        int n2 = 1;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string4 : stringArray3) {
            String string5 = string7 = string4.length() >= string3.length() + n ? string4.substring(string3.length(), string3.length() + n) : string4.substring(0, n);
            if (string7.startsWith("_")) {
                n2 = 0;
            }
            if (n2 == 0) {
                string7 = string3 + string7;
            }
            if (linkedList.contains(string7)) {
                linkedList = new LinkedList();
                ++n;
                break;
            }
            linkedList.add(string7);
        }
        n2 = 1;
        if (n == 2) {
            for (String string4 : stringArray3) {
                String string6 = string7 = string4.length() >= string3.length() + n ? string4.substring(string3.length(), string3.length() + n) : string4.substring(0, n);
                if (string7.startsWith("_")) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    string7 = string3 + string7;
                }
                if (linkedList.contains(string7)) {
                    linkedList = new LinkedList();
                    ++n;
                    break;
                }
                linkedList.add(string7);
            }
        }
        n2 = 1;
        if (n == 3) {
            boolean bl = true;
            for (String string7 : stringArray3) {
                void var8_18;
                String string8;
                String string9 = string8 = string7.length() >= string3.length() + n ? string7.substring(string3.length(), string3.length() + n) : string7.substring(0, n);
                if (string8.startsWith("_")) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    string8 = string3 + string8;
                }
                if (!linkedList.contains(string8)) {
                    linkedList.add(string8);
                    continue;
                }
                linkedList.add(string8 + (int)(++var8_18));
            }
        }
        return linkedList.toArray(new String[0]);
    }

    private static String commonPrefix(String string, String string2) {
        if (string2.startsWith(string)) {
            return string;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return "";
        }
        return DBListInsightData.commonPrefix(string.substring(0, string.length() - 1), string2);
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return this.instance;
    }

    protected void setData(SuggestedItem[] suggestedItemArray) {
        this._matchingDataList = suggestedItemArray;
    }
}

