/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.MoreThanOneGroupBy;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.util.Service;
import oracle.javatools.editor.BasicEditorPane;

public class Autocompleter
implements ParserEventListener {
    private String lastColumnList = null;
    private static String[] aggregates = new String[]{"COUNT", "SUM", "AVG", "MAX", "MIN"};
    static int group_by_clause = -1;
    static int from_clause = -1;
    static int select_list = -1;
    static int where_clause = -1;
    static int having_clause = -1;
    static int connect_by_clause = -1;
    static int set_function_specification = -1;
    static int expr = -1;
    static int query_expression = -1;
    static int new_subquery = -1;
    static int old_subquery = -1;
    static int open_paren = -1;
    static int over_clause = -1;
    static int procedure_call = -1;
    static int sim_expr = -1;

    @Override
    public void stateChanged(final BackgroundParser backgroundParser) {
        Object object3;
        ParseNode parseNode;
        Object object2;
        if (!DBConfig.getInstance().getBoolean("AUTOGENERATEGROUPBY").booleanValue()) {
            return;
        }
        if (backgroundParser.increments.size() > 0) {
            return;
        }
        LazyNode lazyNode = backgroundParser.output;
        List<LexerToken> list = backgroundParser.src;
        String string = backgroundParser.text;
        final BasicEditorPane basicEditorPane = backgroundParser.editor;
        boolean bl = false;
        for (CompletionInsight completionInsight : CompletionInsight.instances) {
            if (completionInsight.getEditorPane() != basicEditorPane || !completionInsight.isInsightVisible()) continue;
            bl = true;
            break;
        }
        boolean bl2 = bl;
        int n = basicEditorPane.getCaretPosition();
        int n2 = LexerToken.scanner2parserOffset(list, (int)n) - 1;
        LazyNode lazyNode2 = lazyNode.ancestor(n2, n2 + 1);
        if ("(".equals(lazyNode2.startToken)) {
            if (list.size() <= lazyNode2.from + 1) {
                return;
            }
            object2 = list.get((int)(lazyNode2.from + 1)).content;
            if (!((String)object2).equalsIgnoreCase("select")) {
                lazyNode2 = lazyNode.ancestor(lazyNode2.from - 1, lazyNode2.to);
            }
        }
        if (lazyNode2.getBranch() == null) {
            try {
                lazyNode2.expand();
            }
            catch (LazyNode.FragmentTooLargeException fragmentTooLargeException) {
                return;
            }
        }
        if ((object2 = (parseNode = (object2 = lazyNode2.getBranch()).ancestor(n2, n2 + 1, query_expression)) != null ? parseNode : TabCol.getMainQueryBlock((ParseNode)object2)) == null) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        for (Object object3 : object2.ancestors(n2)) {
            if (object3.contains(group_by_clause) || object3.contains(where_clause)) {
                bl3 = false;
                bl4 = false;
                continue;
            }
            if (object3.contains(select_list)) {
                bl3 = true;
                bl4 = false;
                continue;
            }
            if (!object3.contains(from_clause)) continue;
            bl3 = false;
            bl4 = true;
        }
        ParseNode parseNode2 = Autocompleter.findGroupBy(list, (ParseNode)object2);
        if (parseNode2 instanceof MoreThanOneGroupBy) {
            return;
        }
        if (!(bl3 || bl4 && backgroundParser.isSingleChar || parseNode2 == null && n == string.length())) {
            return;
        }
        object3 = Autocompleter.generateGBY((ParseNode)lazyNode2, list, string, DBConfig.getInstance().getBoolean("AUTOGENERATEGROUPBYINCREMENTALLY") == false, n2);
        if (object3 == null || ((String)object3).equals(this.lastColumnList) && parseNode2 != null) {
            return;
        }
        if (parseNode2 != null && bl4) {
            return;
        }
        List list2 = LexerToken.parse((String)("group by " + (String)object3));
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.initCell(matrix, new int[]{group_by_clause}, 0);
        sqlEarley.parse(list2, matrix);
        ParseNode parseNode3 = sqlEarley.forest(list2, matrix);
        if (Autocompleter.findGroupBy(parseNode3) == null) {
            return;
        }
        int n3 = -1;
        int n4 = -1;
        if (parseNode2 != null) {
            n3 = list.get((int)parseNode2.from).begin;
            n4 = list.get((int)(parseNode2.to - 1)).end;
        } else {
            ParseNode parseNode4 = Autocompleter.findWhere((ParseNode)object2);
            if (parseNode4 == null) {
                parseNode4 = Autocompleter.findFrom((ParseNode)object2);
            }
            n4 = n3 = list.get((int)(parseNode4.to - 1)).end;
        }
        final int n5 = n3;
        final int n6 = n4;
        this.lastColumnList = object3;
        Runnable runnable = new Runnable((String)object3, parseNode2, list, n, bl2){
            final /* synthetic */ String val$colList;
            final /* synthetic */ ParseNode val$groupBy;
            final /* synthetic */ List val$src;
            final /* synthetic */ int val$charPos;
            final /* synthetic */ boolean val$popInsight;
            {
                this.val$colList = string;
                this.val$groupBy = parseNode;
                this.val$src = list;
                this.val$charPos = n3;
                this.val$popInsight = bl;
            }

            @Override
            public void run() {
                if (backgroundParser.increments.size() > 0) {
                    return;
                }
                basicEditorPane.select(n5, n6);
                if (this.val$colList.trim().equals("")) {
                    basicEditorPane.replaceSelection("");
                } else {
                    String string = "group by ";
                    string = this.val$groupBy != null ? ((LexerToken)this.val$src.get((int)this.val$groupBy.from)).content + " " + ((LexerToken)this.val$src.get((int)(this.val$groupBy.from + 1))).content + " " : CaseConverter.getState().convert(" " + string);
                    String string2 = string + CaseConverter.getState().convert(this.val$colList);
                    basicEditorPane.replaceSelection(string2);
                }
                basicEditorPane.setCaretPosition(this.val$charPos);
                if (this.val$popInsight) {
                    basicEditorPane.invokeAction("completion-insight");
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static String generateGBY(ParseNode parseNode, List<LexerToken> list, String string, boolean bl, int n) {
        ParseNode parseNode2 = TabCol.getSelectList(parseNode);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl2 = false;
        for (ParseNode object2 : TabCol.getColumnNodes(parseNode2)) {
            if (Autocompleter.isAggregateExpression(object2, list)) {
                bl2 = true;
                continue;
            }
            String string2 = Autocompleter.getColExpr(object2, list, string);
            if (string2 == null || Autocompleter.isSubquery(object2) || string2.toUpperCase().contains("OVER") || Autocompleter.containsAggregateFunction(string2.toUpperCase())) continue;
            linkedList.add(string2);
        }
        if (!bl2) {
            return null;
        }
        ParseNode parseNode3 = Autocompleter.findGroupBy(list, parseNode);
        if (parseNode3 instanceof MoreThanOneGroupBy) {
            return null;
        }
        if (Autocompleter.isGroupingSets(parseNode3, list)) {
            return null;
        }
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (parseNode3 != null) {
            for (ParseNode parseNode4 : Autocompleter.getGBYNodes(parseNode3)) {
                String string3 = string.substring(list.get((int)parseNode4.from).begin, list.get((int)(parseNode4.to - 1)).end);
                linkedList2.add(string3);
            }
        }
        return !bl || linkedList2.size() == 0 ? Autocompleter.concat(linkedList) : Autocompleter.increment(linkedList, linkedList2);
    }

    private static String increment(List<String> list, List<String> list2) {
        String string;
        String string2;
        int n;
        if (list.size() + 1 == list2.size()) {
            for (String string3 : list2) {
                if (!Autocompleter.isAggregateFunction(string3.toUpperCase()) || list.contains(string3)) continue;
                return Autocompleter.concat(list);
            }
        }
        if (list.size() != list2.size() + 1 && list.size() != list2.size()) {
            return null;
        }
        int n2 = list2.size();
        for (n = 0; n < list2.size(); ++n) {
            string2 = list.get(n);
            if (string2.equals(string = list2.get(n))) continue;
            n2 = n;
            break;
        }
        if (list.size() == list2.size() && !list.get(n2).startsWith(list2.get(n2))) {
            return null;
        }
        for (n = n2 + 1; n < list.size(); ++n) {
            string2 = list.get(n);
            if (string2.equals(string = list2.get(list.size() == list2.size() ? n : n - 1))) continue;
            return null;
        }
        return Autocompleter.concat(list);
    }

    private static List<ParseNode> getGBYNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        if (parseNode.contains(sim_expr)) {
            linkedList.add(parseNode);
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            linkedList.addAll(Autocompleter.getGBYNodes(parseNode2));
        }
        return linkedList;
    }

    private static String concat(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(stringBuilder.length() == 0 ? string : ", " + string);
        }
        return stringBuilder.toString();
    }

    private static boolean isGroupingSets(ParseNode parseNode, List<LexerToken> list) {
        if (parseNode == null) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (++n < parseNode.from) continue;
            if (!bl && parseNode.to <= n) break;
            if ("grouping".equals(lexerToken.content.toLowerCase())) {
                bl = true;
                continue;
            }
            if (bl && "sets".equals(lexerToken.content.toLowerCase())) {
                return true;
            }
            bl = false;
        }
        return false;
    }

    private static String getColExpr(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.children().size() == 0 || parseNode.contains(expr)) {
            return string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
        }
        Iterator iterator = parseNode.children().iterator();
        if (iterator.hasNext()) {
            ParseNode parseNode2 = (ParseNode)iterator.next();
            return Autocompleter.getColExpr(parseNode2, list, string);
        }
        return null;
    }

    private static boolean isAggregateExpression(ParseNode parseNode, List<LexerToken> list) {
        if ((parseNode.contains(procedure_call) || parseNode.contains(set_function_specification)) && Autocompleter.isAggregateFunction(list, parseNode)) {
            return true;
        }
        boolean bl = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (Autocompleter.isSubqueryItself(parseNode2)) continue;
            if (Autocompleter.isAggregateExpression(parseNode2, list)) {
                bl = true;
            }
            if (!parseNode2.contains(over_clause)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean isSubqueryItself(ParseNode parseNode) {
        return parseNode.contains(new_subquery) || parseNode.contains(old_subquery);
    }

    private static boolean isSubquery(ParseNode parseNode) {
        if (Autocompleter.isSubqueryItself(parseNode)) {
            return true;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!Autocompleter.isSubqueryItself(parseNode2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAggregateFunction(List<LexerToken> list, ParseNode parseNode) {
        ParseNode parseNode2;
        String string;
        Iterator iterator = parseNode.children().iterator();
        return iterator.hasNext() && Autocompleter.isAggregateFunction(string = (parseNode2 = (ParseNode)iterator.next()).content(list).toUpperCase());
    }

    private static boolean isAggregateFunction(String string) {
        for (String string2 : aggregates) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAggregateFunction(String string) {
        for (String string2 : aggregates) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    static void reInit() {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        group_by_clause = sqlEarley.getSymbol("group_by_clause");
        from_clause = sqlEarley.getSymbol("from_clause");
        select_list = sqlEarley.getSymbol("select_list");
        where_clause = sqlEarley.getSymbol("where_clause");
        having_clause = sqlEarley.getSymbol("having_clause");
        connect_by_clause = sqlEarley.getSymbol("hierarchical_query_clause");
        procedure_call = sqlEarley.getSymbol("procedure_call");
        set_function_specification = sqlEarley.getSymbol("function_expression");
        open_paren = sqlEarley.getSymbol("'('");
        over_clause = sqlEarley.getSymbol("over_clause");
        expr = sqlEarley.getSymbol("expr");
    }

    public static ParseNode findGroupBy(List<LexerToken> list, ParseNode parseNode) {
        int n;
        LexerToken lexerToken3;
        int n2 = -1;
        LexerToken lexerToken2 = null;
        int n3 = 0;
        for (LexerToken lexerToken3 : list) {
            if (n3 < parseNode.from || parseNode.to <= n3) {
                lexerToken2 = lexerToken3;
                ++n3;
                continue;
            }
            if (lexerToken2 != null && "group".equalsIgnoreCase(lexerToken2.content) && "by".equalsIgnoreCase(lexerToken3.content)) {
                if (n2 != -1) {
                    return new MoreThanOneGroupBy();
                }
                n2 = n3 - 1;
            }
            lexerToken2 = lexerToken3;
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        SqlEarley sqlEarley = SqlEarley.getInstance();
        lexerToken3 = new Matrix((Parser)sqlEarley);
        sqlEarley.initCell((Matrix)lexerToken3, new int[]{group_by_clause}, n2);
        sqlEarley.parse(list, (Matrix)lexerToken3);
        long l = (Long)lexerToken3.lastKey();
        for (int i = n = Service.lY((long)l); n2 + 1 < i; --i) {
            Cell cell = (Cell)lexerToken3.get((Object)Service.lPair((int)n2, (int)i));
            if (cell == null) continue;
            for (int j = 0; j < cell.size(); ++j) {
                int n4 = cell.getRule(j);
                Earley.Tuple tuple = sqlEarley.rules[n4];
                if (tuple.head != group_by_clause || tuple.rhs.length != cell.getPosition(j)) continue;
                return sqlEarley.treeForACell(list, (Matrix)lexerToken3, cell, n2, i);
            }
        }
        return null;
    }

    public static ParseNode findGroupBy(ParseNode parseNode) {
        return Autocompleter.findInQueryBlock(parseNode, group_by_clause);
    }

    public static ParseNode findWhere(ParseNode parseNode) {
        return Autocompleter.findInQueryBlock(parseNode, where_clause);
    }

    public static ParseNode findFrom(ParseNode parseNode) {
        return Autocompleter.findInQueryBlock(parseNode, from_clause);
    }

    private static ParseNode findInQueryBlock(ParseNode parseNode, int n) {
        ParseNode parseNode2;
        if (parseNode == null) {
            return null;
        }
        if (parseNode.contains(n)) {
            return parseNode;
        }
        ParseNode parseNode3 = null;
        Iterator iterator = parseNode.children().iterator();
        while (iterator.hasNext() && (((parseNode2 = (ParseNode)iterator.next()).contains(select_list) || parseNode2.contains(from_clause) || parseNode2.contains(group_by_clause) || parseNode2.contains(connect_by_clause) || parseNode2.contains(having_clause) || parseNode2.contains(where_clause)) && !parseNode2.contains(n) || (parseNode3 = Autocompleter.findInQueryBlock(parseNode2, n)) == null)) {
        }
        return parseNode3;
    }

    static {
        Autocompleter.reInit();
    }
}

