/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public class ExtractListModel {
    public static final int TYPE_ALL_OBJECTS = 0;
    public static final int TYPE_CREATE = 1;
    public static final int TYPE_CREATE_PRE_DATA = 2;
    public static final int TYPE_CREATE_POST_DATA = 3;
    public static final int TYPE_DROP = 4;
    public static final int TYPE_TRUNCATE = 5;
    public static final int TYPE_ENABLE_CONSTRAINTS = 6;
    public static final int TYPE_DISABLE_CONSTRAINTS = 7;
    public static final int TYPE_DATA = 8;
    public static final int TYPE_PRE_SCRIPT = 9;
    public static final int TYPE_POST_SCRIPT = 10;
    public static final int OPT_EXTRACT_METADATA = 100;
    public static final int OPT_EXTRACT_DATA = 101;
    public static final int OPT_DATA_OBJECT = 102;
    public static final int OPT_EXISTS_SOURCE = 103;
    public static final int OPT_EXISTS_DEST = 104;
    public static final int OPT_EXISTS_SOURCE_ONLY = 105;
    public static final int OPT_EXISTS_DEST_ONLY = 106;
    public static final int OPT_PRESELECTED = 107;
    public static final int OPT_SELECTED_META = 108;
    public static final int OPT_SELECTED_DATA = 109;
    public static final String KEY_EXTRACT_LIST_MODEL = "EXTRACT_LIST_MODEL";
    private static final int DBO = 0;
    private static final int QUERY = 1;
    private int _dataObjectType;
    private DDLTypes _ddlTypes;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private ArrayList<ExtractObject> _EOList = new ArrayList();
    private boolean _isDDLEnabled = false;
    private boolean _isDataEnabled = false;
    private String _sourceConnName = "";
    private String _destConnName = "";
    private Connection _sourceConn;
    private Connection _destConn;
    private String _sourceConnUser;
    private String _destConnUser;
    private ArrayList<String> _schemaList = new ArrayList();
    private String[] _tablespaces;
    private boolean _isSourceConnOracle = true;
    private boolean _isSourceConnTimesTen = false;
    private boolean _isDestConnOracle = true;
    private boolean _isDestConnTimesTen = false;
    private boolean _isAllowLobs = true;
    private boolean _isPreSelected = false;
    private boolean _isPreSelectedDataExtractable = false;
    private boolean _isSelectedData = false;
    private boolean _isSelectedMetaData = false;
    private String _globalWhere = "";
    private HashMap<String, Object> _extendedProperties = new HashMap();
    private ExtractReconciler _listReconciler = new ExtractReconciler(this);

    public ExtractListModel() {
        this._dataObjectType = 0;
    }

    public ExtractListModel(JTable jTable) {
        this(jTable, ((IResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
    }

    public ExtractListModel(JTable jTable, String string) {
        this._dataObjectType = 1;
        this.setSourceConnectionProperties(string);
        this._EOList.add(new ExtractObject(jTable, this));
    }

    public ExtractListModel(DBObject dBObject) {
        this.initForDBObjects(dBObject);
    }

    public ExtractListModel(List<DBObject> list) {
        this.initForDBObjects(list);
    }

    public ExtractListModel(DBObject[] dBObjectArray) {
        this.initForDBObjects(dBObjectArray);
    }

    public String getSourceConnName() {
        return this._sourceConnName;
    }

    public void setSourceConnName(String string) {
        this.setSourceConnectionProperties(string);
    }

    public Connection getSourceConn() {
        return this._sourceConn;
    }

    public String getSourceConnUser() {
        if (this._sourceConnUser.length() == 0) {
            this._sourceConnUser = this.getConnectionUser(this._sourceConn);
        }
        return this._sourceConnUser;
    }

    public String getDestConnName() {
        return this._destConnName;
    }

    public void setDestConnName(String string) {
        this._destConnName = string;
        this.setDestConnectionProperties(string);
    }

    public Connection getDestConn() {
        return this._destConn;
    }

    public String getDestConnUser() {
        if (this._destConnUser.length() == 0) {
            this._destConnUser = this.getConnectionUser(this._destConn);
        }
        return this._destConnUser;
    }

    public String[] getSchemas() {
        return this._schemaList.toArray(new String[this._schemaList.size()]);
    }

    public void setSchemas(String[] stringArray) {
        this._schemaList.clear();
        for (String string : stringArray) {
            this._schemaList.add(string);
        }
    }

    public void setSchemas() {
        this._schemaList.clear();
        for (ExtractObject extractObject : this._EOList) {
            int n = this._schemaList.indexOf(extractObject.getDBObject().getSchemaName());
            if (n != -1) continue;
            this._schemaList.add(extractObject.getDBObject().getSchemaName());
        }
    }

    public String[] getTablespaces() {
        return this._tablespaces;
    }

    public void setTablespaces(String[] stringArray) {
        this._tablespaces = stringArray;
    }

    public DDLTypes getDDLTypes() {
        if (this._ddlTypes == null) {
            this._ddlTypes = new DDLTypes();
        }
        return this._ddlTypes;
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        this._ddlTypes = dDLTypes;
    }

    public void isDDLEnabled(boolean bl) {
        this._isDDLEnabled = bl;
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this._ddlFormat = new DDLFormat();
            this._ddlFormat.isExtractEnabled(true);
        }
    }

    public boolean isDDLEnabled() {
        return this._isDDLEnabled;
    }

    public void isDataEnabled(boolean bl) {
        this._isDataEnabled = bl;
        if (this._isDataEnabled && this._dataFormat == null) {
            this._dataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD, BaseDataFormat.INSERT);
            this._dataFormat.isExportEnabled(bl);
        }
    }

    public boolean isDataEnabled() {
        return this._isDataEnabled;
    }

    public DDLFormat getDDLFormat() {
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this.isDDLEnabled(true);
        }
        return this._ddlFormat;
    }

    public void setDDLFormat(DDLFormat dDLFormat) {
        this._ddlFormat = dDLFormat;
        this._isDDLEnabled = this._ddlFormat.isExtractEnabled();
    }

    public ExtractDataFormat getDataFormat() {
        if (this._isDataEnabled && this._dataFormat == null) {
            this.isDataEnabled(true);
        }
        return this._dataFormat;
    }

    public void setDataFormat(ExtractDataFormat extractDataFormat) {
        this._dataFormat = extractDataFormat;
        this._isDataEnabled = this._dataFormat.isExportEnabled();
    }

    public void startProcess() {
        this._listReconciler.reconcileTypesAndObjects(103);
    }

    public void startProcessReconcileObjects() {
        this._listReconciler.reconcileObjects(103);
    }

    public void reconcileDestFromSource() {
        this._listReconciler.reconcileDestFromSource();
    }

    public void reconcileDestFull() {
        this._listReconciler.reconcileTypesAndObjects(104);
    }

    public ArrayList<ExtractObject> getList(int n) {
        switch (n) {
            case 0: {
                return this._EOList;
            }
            case 1: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 2: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 3: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 4: {
                return this.getCreateProcessList(n, new int[]{100});
            }
            case 5: {
                return this.getCreateProcessList(5, new int[]{101});
            }
            case 7: {
                return this.getCreateProcessList(7, new int[]{101});
            }
            case 6: {
                return this.getCreateProcessList(6, new int[]{101});
            }
            case 8: {
                return this.getList(0, new int[]{101});
            }
            case 9: 
            case 10: {
                ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
                int n2 = n == 9 ? 2 : 3;
                for (ExtractObject extractObject : this._EOList) {
                    if (extractObject.getType() != n2) continue;
                    arrayList.add(extractObject);
                }
                return arrayList;
            }
        }
        return null;
    }

    public ArrayList<ExtractObject> getList(int n, int[] nArray) {
        ArrayList<ExtractObject> arrayList = this.getList(n);
        ArrayList<ExtractObject> arrayList2 = this.getList(arrayList, nArray);
        return arrayList2;
    }

    public ArrayList<ExtractObject> getList(List<ExtractObject> list, int[] nArray) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : list) {
            block13: for (int n : nArray) {
                switch (n) {
                    case 100: {
                        if (!extractObject.isExtractMetaData() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 101: {
                        if (!extractObject.isExtractData() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 102: {
                        if (!extractObject.isDataObject() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 103: {
                        if (!extractObject.isExistsSource() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 104: {
                        if (!extractObject.isExistsDest() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 105: {
                        if (!extractObject.isExistsSource() || extractObject.isExistsDest() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 106: {
                        if (!extractObject.isExistsDest() || extractObject.isExistsSource() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 107: {
                        if (!extractObject.isPreSelected() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 108: {
                        if (!extractObject.isSelectedMetaData() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                        continue block13;
                    }
                    case 109: {
                        if (!extractObject.isSelectedData() || arrayList.contains(extractObject)) continue block13;
                        arrayList.add(extractObject);
                    }
                }
            }
        }
        return arrayList;
    }

    public List<ExtractObject> getList(int n, int[] nArray, String string) {
        ArrayList<ExtractObject> arrayList = this.getList(n, nArray);
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : arrayList) {
            if (!extractObject.getDBObject().getObjectType().equals(string)) continue;
            arrayList2.add(extractObject);
        }
        return this.getList(arrayList2, nArray);
    }

    public List<ExtractObject> getListForType(ArrayList<ExtractObject> arrayList, String string) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        if (arrayList == null || arrayList.size() < 1) {
            return arrayList2;
        }
        for (ExtractObject extractObject : arrayList) {
            URL uRL;
            if (extractObject.getType() != 0 || (uRL = extractObject.getDBObject().getURL()) == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList2.add(extractObject);
        }
        return arrayList2;
    }

    public List<URL> getListURLs(int n) {
        return this.getListURL(this.getList(n));
    }

    public List<URL> getListURLs(int n, int[] nArray) {
        return this.getListURL(this.getList(n, nArray));
    }

    public List<URL> getURLListForType(ArrayList<URL> arrayList, String string) {
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        for (URL uRL : arrayList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList2.add(uRL);
        }
        return arrayList2;
    }

    public boolean isExistsForType(ArrayList<URL> arrayList, String string) {
        for (URL uRL : arrayList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedExtractObjects(ArrayList<ExtractObject> arrayList) {
        this._EOList = arrayList;
    }

    public void setSelectExtractData(List<ExtractObject> list) {
        this.clearSelectExtractData();
        if (list == null) {
            return;
        }
        for (ExtractObject extractObject : list) {
            URL uRL = extractObject.getUrl();
            ExtractObject extractObject2 = this.getOrAddExtractObject(uRL);
            extractObject2.isExistsSource(true);
            extractObject2.isDataObject(true);
            extractObject2.isSelectedData(true);
            extractObject2.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractData() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedData(false);
            extractObject.isExtractData(false);
        }
        this._isSelectedData = false;
    }

    public void setSelectExtractMetaData(List<URL> list) {
        this.clearSelectExtractMetaData();
        if (list == null) {
            return;
        }
        for (URL uRL : list) {
            ExtractObject extractObject = this.getOrAddExtractObject(uRL);
            extractObject.isExistsSource(true);
            extractObject.isSelectedMetaData(true);
            extractObject.isExtractMetaData(true);
            this._isSelectedMetaData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractMetaData() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedMetaData(false);
            extractObject.isExtractMetaData(false);
        }
        this._isSelectedMetaData = false;
    }

    public void setSelectExtractBoth(List<URL> list) {
        this.clearSelectExtractBoth();
        if (list == null) {
            return;
        }
        for (URL uRL : list) {
            ExtractObject extractObject = this.getOrAddExtractObject(uRL);
            extractObject.isExistsSource(true);
            extractObject.isSelectedMetaData(true);
            extractObject.isExtractMetaData(true);
            this._isSelectedMetaData = true;
            if (!this.isDataObject(extractObject.getDBObject())) continue;
            extractObject.isSelectedData(true);
            extractObject.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractBoth() {
        for (ExtractObject extractObject : this._EOList) {
            extractObject.isSelectedMetaData(false);
            extractObject.isSelectedData(false);
            extractObject.isExtractData(false);
            extractObject.isExtractMetaData(false);
            this._isSelectedData = false;
            this._isSelectedMetaData = false;
        }
    }

    private void cleanupExtractObjects() {
        ExtractObject extractObject = null;
        for (int i = this._EOList.size() - 1; i >= 0; --i) {
            extractObject = this._EOList.get(i);
            if (extractObject.isSelectedMetaData() || !(!extractObject.isSelectedData() & !extractObject.isPreSelected())) continue;
            this._EOList.remove(extractObject);
        }
    }

    public ExtractObject getExtractObject(URL uRL) {
        for (ExtractObject extractObject : this._EOList) {
            if (!uRL.equals(extractObject.getUrl())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(int n) {
        for (ExtractObject extractObject : this._EOList) {
            if (extractObject.getType() != n) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getExtractObject(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        for (ExtractObject extractObject : this._EOList) {
            if (!uRL.equals(extractObject.getUrl())) continue;
            return extractObject;
        }
        return null;
    }

    public ExtractObject getFirstDataObject() {
        for (ExtractObject extractObject : this._EOList) {
            if (!extractObject.isDataObject() && extractObject.getType() != 1) continue;
            return extractObject;
        }
        return null;
    }

    public DBObject getDBObject(URL uRL) {
        if (this._EOList != null) {
            for (ExtractObject extractObject : this._EOList) {
                DBObject dBObject = extractObject.getDBObject();
                if (!dBObject.getURL().equals(uRL)) continue;
                return dBObject;
            }
        }
        return null;
    }

    public String getGlobalWhere() {
        return this._globalWhere;
    }

    public void setGlobalWhere(String string) {
        int n = string.trim().toLowerCase().indexOf("where");
        this._globalWhere = n != 0 ? string : string.substring(n + 6);
    }

    public Object getPropertyValue(String string) {
        return this._extendedProperties.get(string);
    }

    public void setProperty(String string, Object object) {
        this._extendedProperties.put(string, object);
    }

    public Set<String> getPropertyKeySet() {
        return this._extendedProperties.keySet();
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(this.getConnectionsNode());
        if (this.isDDLEnabled()) {
            defaultMutableTreeNode.add(this.getDDLFormatNode());
        }
        defaultMutableTreeNode.add(this.getMetaNode());
        if (this.isDataEnabled()) {
            defaultMutableTreeNode.add(this.getDataNode());
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getConnectionsNode() {
        String string;
        JLabel jLabel;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("CONNECTIONS"));
        if (this._sourceConn != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._sourceConn));
            jLabel.setText(ExtractResources.getString("SOURCE") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon("CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        if (this._destConn != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._destConn));
            jLabel.setText(ExtractResources.getString("DEST") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon("CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDDLFormatNode() {
        DDLFormat dDLFormat = this.getDDLFormat();
        return dDLFormat.getSummaryNode();
    }

    public DefaultMutableTreeNode getSummaryGlobalWhere() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("EO_PRED_GLOBAL_WHERE") + " " + this._globalWhere);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getMetaNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("DDL_OBJECTS"));
        ArrayList<String> arrayList = this.getDDLTypes().getTypeList();
        for (String string : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypes.getFolderLabel(string));
            ArrayList<JLabel> arrayList2 = this.getSummaryMetaObjectByType(string);
            for (JLabel jLabel : arrayList2) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDataFormatNode() {
        ExtractDataFormat extractDataFormat = this.getDataFormat();
        return extractDataFormat.getSummaryNode(this);
    }

    public DefaultMutableTreeNode getDataNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("DATA_OBJECTS"));
        ArrayList<String> arrayList = this.getDDLTypes().getTypeListForData();
        for (String string : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypes.getFolderLabel(string));
            ArrayList<DefaultMutableTreeNode> arrayList2 = this.getSummaryDataNodeByType(string);
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : arrayList2) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public ArrayList<JLabel> getSummaryMetaObjectByType(String string) {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        ArrayList<ExtractObject> arrayList2 = this.getList(0, new int[]{108});
        ArrayList arrayList3 = (ArrayList)this.getListForType(this.getList(0), "TABLE");
        List<ExtractObject> list = this.getListForType(arrayList2, string);
        if (list.size() < 1) {
            if (arrayList3.isEmpty()) {
                arrayList.add(this.getAllObjectsLabel(string));
            } else if (string == "CONSTRAINT" || string == "REFCONSTRAINT" || string == "INDEX" || string == "TRIGGER") {
                for (ExtractObject extractObject : arrayList3) {
                    String string2 = extractObject.getSourceConnName();
                    DBObject dBObject = this.getDBObject(extractObject.getUrl());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, dBObject.getSchemaName(), string);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                    DBObject dBObject2 = new DBObject(uRL2);
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject2.getURL()));
                    jLabel.setText(ExtractResources.format("FOR", DDLTypes.getFolderName(string), dBObject2.getObjectName()));
                    arrayList.add(jLabel);
                }
            } else {
                arrayList.add(this.getAllObjectsLabel(string));
            }
        } else {
            for (ExtractObject extractObject : list) {
                arrayList.add(extractObject.getLabel());
            }
        }
        return arrayList;
    }

    public ArrayList<DefaultMutableTreeNode> getSummaryDataNodeByType(String string) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<ExtractObject> arrayList2 = this.getList(0, new int[]{109});
        List<ExtractObject> list = this.getListForType(arrayList2, string);
        if (list.size() < 1) {
            arrayList.add(new DefaultMutableTreeNode(this.getAllObjectsLabel(string)));
        } else {
            for (ExtractObject extractObject : list) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(extractObject.getLabel());
                if (extractObject.getWhere().length() > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ExtractResources.getString("EO_PRED_OBJ_WHERE") + " " + extractObject.getWhere());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                arrayList.add(defaultMutableTreeNode);
            }
        }
        return arrayList;
    }

    public static DefaultMutableTreeNode getSummaryBooleanItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, Icon icon, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(icon);
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, String string2) {
        return ExtractListModel.getSummaryLabelItem(string, OracleIcons.getIcon((String)"attribute.png"), string2);
    }

    public void finish() {
    }

    public boolean isTypeDBO() {
        return this._dataObjectType == 0;
    }

    public boolean isTypeQuery() {
        return this._dataObjectType == 1;
    }

    public boolean isAllowLobs() {
        return this._isAllowLobs;
    }

    public void isAllowLobs(boolean bl) {
        if (!this._isAllowLobs == bl) {
            for (ExtractObject extractObject : this._EOList) {
                extractObject.isDataPrepared(false);
            }
        }
        this._isAllowLobs = bl;
    }

    public boolean isPreSelected() {
        return this._isPreSelected;
    }

    public boolean isPreSelectedDataExtractable() {
        return this._isPreSelectedDataExtractable;
    }

    public boolean isSelectedMetaData() {
        return this._isSelectedMetaData;
    }

    public boolean isSelectedData() {
        return this._isSelectedData;
    }

    public boolean isSourceConnOracle() {
        return this._isSourceConnOracle;
    }

    public boolean isSourceConnTimesTen() {
        return this._isSourceConnTimesTen;
    }

    private void setSourceConnectionProperties(String string) {
        this._sourceConnName = string;
        try {
            this._sourceConn = Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this._sourceConnUser = "";
        this._isSourceConnOracle = Connections.getInstance().isOracle(this._sourceConnName);
        this._isSourceConnTimesTen = Connections.getInstance().isTimesTen(this._sourceConnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionUser(Connection connection) {
        boolean bl = false;
        String string = "";
        try {
            if (connection != null && (bl = Connections.getInstance().lock(connection, true))) {
                string = connection.getMetaData().getUserName();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    private void setDestConnectionProperties(String string) {
        this._destConnName = string;
        this._destConnUser = "";
        try {
            this._destConn = Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this._destConnUser = "";
        this._isDestConnOracle = Connections.getInstance().isOracle(this._destConnName);
        this._isDestConnTimesTen = Connections.getInstance().isTimesTen(this._destConnName);
    }

    public ArrayList<ExtractObject> getCreateProcessList(int n, int[] nArray) {
        return this.getCreateProcessList(this.getList(0, nArray), n);
    }

    public ArrayList<ExtractObject> getCreateProcessList(ArrayList<ExtractObject> arrayList, int n) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        ArrayList<String> arrayList3 = this._ddlTypes.getTypes(n);
        for (String string : arrayList3) {
            ArrayList arrayList4 = (ArrayList)this.getListForType(arrayList, string);
            for (ExtractObject extractObject : arrayList4) {
                arrayList2.add(extractObject);
            }
        }
        return arrayList2;
    }

    private JLabel getAllObjectsLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(ExtractResources.getString("ALL") + " " + DDLTypes.getFolderName(string));
        return jLabel;
    }

    private ArrayList<URL> getListURL(List<ExtractObject> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (list != null && !list.isEmpty()) {
            for (ExtractObject extractObject : list) {
                DBObject dBObject = extractObject.getDBObject();
                URL uRL = dBObject.getURL();
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    private void initForDBObjects(DBObject dBObject) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dBObject.getConnectionName());
        this.addExtractObjectPreSelected(dBObject);
    }

    private void initForDBObjects(DBObject[] dBObjectArray) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dBObjectArray[0].getConnectionName());
        for (DBObject dBObject : dBObjectArray) {
            this.addExtractObjectPreSelected(dBObject);
        }
    }

    private void initForDBObjects(List<DBObject> list) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(list.get(0).getConnectionName());
        for (DBObject dBObject : list) {
            this.addExtractObjectPreSelected(dBObject);
        }
    }

    private void initForDBObjects() {
        this._dataObjectType = 0;
        this._isPreSelected = true;
    }

    public ExtractObject getOrAddExtractObject(DBObject dBObject, int[] nArray) {
        ExtractObject extractObject = this.getOrAddExtractObject(dBObject);
        block7: for (int n : nArray) {
            switch (n) {
                case 100: {
                    extractObject.isExtractMetaData(true);
                    continue block7;
                }
                case 101: {
                    extractObject.isExtractData(true);
                    continue block7;
                }
                case 102: {
                    extractObject.isDataObject(true);
                    continue block7;
                }
                case 103: {
                    extractObject.isExistsSource(true);
                    continue block7;
                }
                case 104: {
                    extractObject.isExistsDest(true);
                }
            }
        }
        return extractObject;
    }

    private void addExtractObjectPreSelected(DBObject dBObject) {
        ExtractObject extractObject = this.getOrAddExtractObject(dBObject);
        if (this.isDataObject(dBObject)) {
            this._isPreSelectedDataExtractable = true;
            this._isSelectedData = true;
            extractObject.isDataObject(true);
            extractObject.isExtractData(true);
            extractObject.isSelectedData(true);
        }
        extractObject.isExistsSource(true);
        extractObject.isPreSelected(true);
        extractObject.isExtractMetaData(true);
        extractObject.isSelectedMetaData(true);
        this._isSelectedMetaData = true;
    }

    public ExtractObject getOrAddExtractObject(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        ExtractObject extractObject = this.getExtractObject(uRL);
        if (extractObject == null) {
            extractObject = this.addExtractObject(dBObject);
        }
        return extractObject;
    }

    public ExtractObject getOrAddExtractObject(URL uRL) {
        ExtractObject extractObject = this.getExtractObject(uRL);
        if (extractObject == null) {
            extractObject = this.addExtractObject(uRL);
        }
        return extractObject;
    }

    public ExtractObject getOrAddExtractObject(int n) {
        ExtractObject extractObject = this.getExtractObject(n);
        if (extractObject == null) {
            extractObject = this.addExtractObject(n);
        }
        return extractObject;
    }

    private ExtractObject addExtractObject(DBObject dBObject) {
        ExtractObject extractObject = new ExtractObject(dBObject, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    private ExtractObject addExtractObject(URL uRL) {
        ExtractObject extractObject = new ExtractObject(uRL, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    private ExtractObject addExtractObject(int n) {
        ExtractObject extractObject = new ExtractObject(n, this);
        this._EOList.add(extractObject);
        return extractObject;
    }

    public boolean isDataObject(DBObject dBObject) {
        return "TABLE".equals(dBObject.getObjectType()) || "VIEW".equals(dBObject.getObjectType()) || "MATERIALIZED VIEW".equals(dBObject.getObjectType());
    }

    public boolean isDestConnOracle() {
        return this._isDestConnOracle;
    }

    public boolean isDestConnTimesTen() {
        return this._isDestConnTimesTen;
    }
}

