/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.datatools.ui.BaseFormatOptionsPanel;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.format.IExportFormatOptions;
import oracle.ide.util.ResourceUtils;

public class ExportFormatOptionsPanel
extends BaseFormatOptionsPanel {
    private static final long serialVersionUID = 1L;
    private boolean _isBasicInit = false;
    private JTextField _tableName;
    private JCheckBox _saveQuery;
    private JTextField _queryName;
    private JTextField _dataName;
    protected JCheckBox _separateDataFile;
    private GridBagConstraints _tableNameConstraints;
    private GridBagConstraints _tableNameLabelConstraints;
    private GridBagConstraints _dataNameLabelConstraints;
    private GridBagConstraints _dataNameConstraints;
    private GridBagConstraints _saveQueryConstraints;
    private GridBagConstraints _queryNameConstraints;
    private JLabel _tableNameLabel;
    private JLabel _dataNameLabel;
    private JLabel _keywordsLabel;
    private JLabel _subjectLabel;
    private JLabel _titleLabel;
    private JTextField _keywords;
    private JTextField _subject;
    private JTextField _title;
    private GridBagConstraints _keywordsLabelConstraints;
    private GridBagConstraints _subjectLabelConstraints;
    private GridBagConstraints _titleLabelConstraints;
    private GridBagConstraints _keywordsConstraints;
    private GridBagConstraints _subjectConstraints;
    private GridBagConstraints _titleConstraints;
    private boolean _showSeparateDataFile = false;

    public ExportFormatOptionsPanel(int n, String string) {
        this._dataFormat = new ExtractDataFormat(n, string);
        this._options = this._dataFormat.getOptions();
    }

    public ExportFormatOptionsPanel(BaseDataFormat baseDataFormat) {
        super(baseDataFormat);
    }

    public BaseDataFormat getProperties() {
        if (!this._dataFormat.isExcel() && !this._dataFormat.isExcelX()) {
            super.getFormatProperties();
        }
        return this._dataFormat;
    }

    @Override
    public ExtractDataFormat getFormatProperties() {
        super.getFormatProperties();
        IExportFormatOptions iExportFormatOptions = (IExportFormatOptions)this._options;
        ExtractDataFormat extractDataFormat = (ExtractDataFormat)this._dataFormat;
        if (iExportFormatOptions.isSeparateDataFileSupported()) {
            extractDataFormat.isSeparateDataFile(this._separateDataFile.isSelected());
        }
        if (iExportFormatOptions.isTableNameSupported()) {
            extractDataFormat.setTableName(this._tableName.getText());
        }
        if (iExportFormatOptions.isDataNameSupported()) {
            extractDataFormat.setDataName(this._dataName.getText());
        }
        if (iExportFormatOptions.isQuerySupported()) {
            extractDataFormat.setQueryName(this._queryName.getText());
            extractDataFormat.isQuerySaved(this._saveQuery.isSelected());
        }
        if (this._dataFormat.isPDF()) {
            extractDataFormat.setTitle(this._title.getText());
            extractDataFormat.setSubject(this._subject.getText());
            extractDataFormat.setKeywords(this._keywords.getText());
        }
        return extractDataFormat;
    }

    public void showSeparateDataFile(boolean bl) {
    }

    public JPanel getLimitedFormatPanel() {
        this._row = 0;
        this.initFormatComponent();
        this.addFormatComponent();
        return this._formatPanel;
    }

    @Override
    public JPanel getFormatPanel() {
        this._row = 0;
        this.addBasicComponents();
        if (this._dataFormat.getUsage() != BaseDataFormat.EXPORT_WIZARD) {
            this.enableFormatComponent(false);
        }
        if (this._dataFormat.isPDF()) {
            this.addPDFComponents();
        } else {
            this.addFormatComponents();
            this.addLeftEnclosureListener();
            if (this._dataFormat.getUsage() == BaseDataFormat.EXPORT_PREFERENCES) {
                this.addFormatPreferenceComponents();
            }
        }
        return this._formatPanel;
    }

    @Override
    protected void addBasicComponents() {
        this._row = 0;
        if (!this._isBasicInit) {
            if (this._dataFormat.isHeaderOptionSupported()) {
                super.initHeader();
            } else {
                this.initLoaderOptions();
            }
            this.initFormatComponent();
        }
        if (this._dataFormat.getFormats().length > 0) {
            this._formatPanel.add((Component)this._formatLabel, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 8), 0, 0));
            this._formatPanel.add((Component)this._format, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this._dataFormat.isHeaderOptionSupported()) {
                this._formatPanel.add((Component)this._header, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 0), 0, 0));
            } else if (this._showSeparateDataFile && ((IExportFormatOptions)this._options).isSeparateDataFileSupported()) {
                this._formatPanel.add((Component)this._separateDataFile, new GridBagConstraints(2, this._row, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 0), 0, 0));
            }
        } else {
            ++this._row;
        }
    }

    private void initFormatComponent() {
        if (this._dataFormat.getFormats().length > 0) {
            this._formatLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("FORMAT")));
            this._formatLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("FORMAT")));
            this._format = new JComboBox<String>(((ExtractDataFormat)this._dataFormat).getFormats());
            this._format.setSelectedItem(this._dataFormat.getFormat());
            this._formatLabel.setLabelFor(this._format);
        }
    }

    private void enableFormatComponent(boolean bl) {
        if (this._dataFormat.getFormats().length > 0) {
            this._formatLabel.setEnabled(bl);
            this._format.setEnabled(bl);
        }
    }

    private void addFormatComponent() {
        if (this._dataFormat.getFormats().length > 0) {
            this._formatPanel.add((Component)this._formatLabel, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 8), 0, 0));
            this._formatPanel.add((Component)this._format, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    protected void addOtherComponents() {
        IExportFormatOptions iExportFormatOptions = (IExportFormatOptions)this._options;
        if (iExportFormatOptions.isTableNameSupported()) {
            this.initTableName();
            this._formatPanel.add((Component)this._tableNameLabel, this._tableNameLabelConstraints);
            this._formatPanel.add((Component)this._tableName, this._tableNameConstraints);
        }
        if (iExportFormatOptions.isDataNameSupported()) {
            this.initDataName();
        }
        if (iExportFormatOptions.isQuerySupported()) {
            this.initSaveQuery();
        }
        if (iExportFormatOptions.isDataNameSupported()) {
            this.initDataName();
            this._formatPanel.add((Component)this._dataNameLabel, this._dataNameLabelConstraints);
            this._formatPanel.add((Component)this._dataName, this._dataNameConstraints);
        }
        if (iExportFormatOptions.isQuerySupported()) {
            this.initSaveQuery();
            this._formatPanel.add((Component)this._saveQuery, this._saveQueryConstraints);
            this._formatPanel.add((Component)this._queryName, this._queryNameConstraints);
        }
    }

    public void initTableName() {
        if (this._tableName == null) {
            this._tableName = new JTextField();
            this._tableNameLabel = new JLabel(ExportWizArb.getString("TABLE_NAME"));
            this._tableNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("TABLE_NAME")));
            this._tableNameLabel.setLabelFor(this._dataName);
            this._tableNameLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 8), 0, 0);
            this._tableNameConstraints = new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 18, 2, new Insets(8, 0, 0, 0), 0, 0);
            this._tableName.setText(ExportWizArb.getString("DEFAULT_EXPORT_NAME"));
            if (!((ExtractDataFormat)this._dataFormat).isTableNameVisible()) {
                this._tableNameLabel.setVisible(false);
                this._tableName.setVisible(false);
            }
        }
    }

    void initDataName() {
        if (this._dataName == null) {
            this._dataName = new JTextField();
            this._dataNameLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("WORKSHEET_NAME")));
            this._dataNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("WORKSHEET_NAME")));
            this._dataNameLabel.setLabelFor(this._dataName);
            this._dataNameLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 8), 0, 0);
            this._dataNameConstraints = new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 18, 2, new Insets(8, 0, 0, 0), 0, 0);
            this._dataName.setText(((ExtractDataFormat)this._dataFormat).getDataName());
        }
    }

    void initSaveQuery() {
        if (this._queryName == null) {
            this._queryName = new JTextField();
            this._queryNameConstraints = new GridBagConstraints(1, ++this._row, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0);
            this._queryName.setText(((ExtractDataFormat)this._dataFormat).getQueryName());
        }
        if (this._saveQuery == null) {
            this._saveQuery = new JCheckBox();
            this._saveQueryConstraints = new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 8), 0, 0);
            ResourceUtils.resButton((AbstractButton)this._saveQuery, (String)ExportWizArb.getString("QUERY_NAME"));
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ExportFormatOptionsPanel.this._queryName.setEnabled(ExportFormatOptionsPanel.this._saveQuery.isSelected());
                }
            };
            this._saveQuery.addItemListener(itemListener);
            this._saveQuery.setSelected(((ExtractDataFormat)this._dataFormat).isQuerySaved());
        }
    }

    protected void initLoaderOptions() {
        if (this._separateDataFile == null) {
            this._separateDataFile = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._separateDataFile, (String)ExportWizArb.getString("SEPARATE_DATA_FILE"));
        }
        this._separateDataFile.setSelected(((ExtractDataFormat)this._dataFormat).isSeparateDataFile());
    }

    private void addPDFComponents() {
        if (this._title == null) {
            this._titleLabel = new JLabel();
            this._subjectLabel = new JLabel();
            this._keywordsLabel = new JLabel();
            this._title = new JTextField();
            this._subject = new JTextField();
            this._keywords = new JTextField();
            ResourceUtils.resLabel((JLabel)this._titleLabel, (Component)this._title, (String)ExportWizArb.getString("TITLE"));
            ResourceUtils.resLabel((JLabel)this._subjectLabel, (Component)this._subject, (String)ExportWizArb.getString("SUBJECT"));
            ResourceUtils.resLabel((JLabel)this._keywordsLabel, (Component)this._keywords, (String)ExportWizArb.getString("KEYWORDS"));
            this._titleLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0);
            this._titleConstraints = new GridBagConstraints(1, this._row, 2, 1, 0.5, 0.0, 23, 2, new Insets(6, 0, 0, 0), 250, 0);
            this._subjectLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0);
            this._subjectConstraints = new GridBagConstraints(1, this._row, 2, 1, 0.5, 0.0, 23, 2, new Insets(6, 0, 0, 0), 250, 0);
            this._keywordsLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0);
            this._keywordsConstraints = new GridBagConstraints(1, this._row, 2, 1, 0.5, 0.0, 23, 2, new Insets(6, 0, 0, 0), 250, 0);
            this._title.setText(((ExtractDataFormat)this._dataFormat).getTitle());
            this._subject.setText(((ExtractDataFormat)this._dataFormat).getSubject());
            this._keywords.setText(((ExtractDataFormat)this._dataFormat).getKeywords());
        }
        this._formatPanel.add((Component)this._titleLabel, this._titleLabelConstraints);
        this._formatPanel.add((Component)this._title, this._titleConstraints);
        this._formatPanel.add((Component)this._subjectLabel, this._subjectLabelConstraints);
        this._formatPanel.add((Component)this._subject, this._subjectConstraints);
        this._formatPanel.add((Component)this._keywordsLabel, this._keywordsLabelConstraints);
        this._formatPanel.add((Component)this._keywords, this._keywordsConstraints);
    }
}

