/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportGenerationOutputStream;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.PDFFormatter;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.SQLFormatterWrapper;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TableSorter;

public class ExportAPI {
    private static final Logger LOGGER = Logger.getLogger(ExportAPI.class.getName());
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private DatabaseQueryTask<?> _task = null;
    private Connection _conn;
    private String _connName;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private TargetFormat _targetFormat;
    private DDLTypes _ddlType;
    private ExtractListModel _listModel;
    private boolean _cancel;
    private String badSetup;
    ResultsFormatter _formatter = null;
    ResultSetWrapper _rsw;
    private boolean _isExportOwnedResultSet;
    private boolean _isGridResultSet;
    private boolean _isReconcileTypesAndObjects = true;
    private ExportGenerationOutputStream _genOutputStream;

    private final String INIT_APEX_SQL() {
        return "declare\nsgid number := 0;\nappid number := wwv_flow_utilities.minimum_free_flow;\nbegin\nfor r in ( select workspace_id,schema from apex_workspace_schemas ) loop\nwwv_flow_application_install.set_workspace_id(r.workspace_id);\nwwv_flow_application_install.set_schema(r.schema);\nwwv_flow_application_install.set_image_prefix( wwv_flow_global.g_image_prefix );\nsgid := r.workspace_id;\nend loop;\nwwv_flow_application_install.set_application_id(appid);\nwwv_flow_api.set_security_group_id( sgid);\nwwv_flow_application_install.set_application_alias(appid);\nwwv_flow_application_install.generate_offset;\nend;\n/\n";
    }

    public void setExtractListModel(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        this.setConnection(this._listModel.getSourceConn());
        this._ddlFormat = this._listModel.getDDLFormat();
        this._dataFormat = this._listModel.getDataFormat();
        this._ddlType = this._listModel.getDDLTypes();
    }

    private void setConnection(Connection connection) {
        this._conn = connection;
        this._connName = Connections.getInstance().getConnectionName(this._conn);
    }

    public void setTargetFormat(TargetFormat targetFormat) {
        this._targetFormat = targetFormat;
    }

    public void setQuickDDL(ExtractListModel extractListModel, int n, String string) {
        try {
            this._listModel = extractListModel;
            DDLFormat dDLFormat = new DDLFormat();
            dDLFormat.isExtractEnabled(true);
            this._listModel.setDDLFormat(dDLFormat);
            DDLTypes dDLTypes = this._listModel.getDDLTypes();
            ArrayList<ExtractObject> arrayList = this._listModel.getList(0, new int[]{107});
            dDLTypes.setTypes(arrayList);
            dDLTypes.setShowConstraint(true);
            dDLTypes.setShowRefConstraint(true);
            this._listModel.setDDLTypes(dDLTypes);
            this.setExtractListModel(extractListModel);
            extractListModel.clearSelectExtractData();
            TargetFormat targetFormat = new TargetFormat(1, 1);
            targetFormat.setSaveAsType(n);
            if (n == 4) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_WORKSHEET"));
            } else if (n == 5) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_CLIPBOARD"));
            } else {
                targetFormat.setSaveAs(string);
            }
            this.setTargetFormat(targetFormat);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void setDeploy(DbCartDeployOptions dbCartDeployOptions) {
        this._listModel = new ExtractListModel();
        this._listModel.setSelectedExtractObjects(dbCartDeployOptions.getExtractObjectList());
        this._listModel.setSchemas();
        this.setExtractListModel(this._listModel);
        this._ddlFormat = dbCartDeployOptions.getDDLFormat();
        this._listModel.setDDLFormat(this._ddlFormat);
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        ArrayList<ExtractObject> arrayList = this._listModel.getList(0, new int[]{107});
        dDLTypes.setTypes(arrayList);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        dDLTypes.setConstraint(this._ddlFormat.getConstraint());
        dDLTypes.setRefConstraint(this._ddlFormat.getRefConstraint());
        this._listModel.setDDLTypes(dDLTypes);
        for (ExtractObject extractObject : dbCartDeployOptions.getExtractObjectList()) {
            extractObject.setListModel(this._listModel);
        }
        this._dataFormat = dbCartDeployOptions.getDataFormat();
        this._dataFormat.isExportEnabled(dbCartDeployOptions.isIncludeData());
        this._listModel.setDataFormat(this._dataFormat);
        this.setTargetFormat(dbCartDeployOptions.getTargetFormat());
        this._isReconcileTypesAndObjects = false;
    }

    private boolean isExportDBObjects() {
        return this._listModel.isTypeDBO();
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this._targetFormat.getSaveAs() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_FILE") + this.getTerm());
            bl = false;
        }
        if (this.isExportDBObjects()) {
            if (this._ddlFormat == null) {
                stringBuilder.append(ExportWizArb.getString("NO_FORMAT") + this.getTerm());
                bl = false;
            }
            if (this._ddlType == null) {
                stringBuilder.append(ExportWizArb.getString("NO_TYPE") + this.getTerm());
                bl = false;
            }
        } else if (this._listModel == null || this._listModel.getFirstDataObject() == null || this._listModel.getFirstDataObject().getTable() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_DATA") + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    private String getTerm() {
        return "\n";
    }

    private void write(String string) throws IOException {
        this._genOutputStream.println(string);
    }

    public void cancelExport() {
        this._cancel = true;
    }

    private void exportMetaListAppend(int n) {
        ArrayList<ExtractObject> arrayList = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : arrayList) {
                if (!this._cancel) {
                    String string = extractObject.getDDL(n).trim();
                    if (string.length() <= 0) continue;
                    this.write(string + this.getTerm());
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void exportMetaList(int n) {
        ArrayList<ExtractObject> arrayList = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : arrayList) {
                if (!this._cancel) {
                    String string;
                    DBObject dBObject = extractObject.getDBObject();
                    this._genOutputStream.startObject(dBObject.getObjectName(), dBObject.getObjectType());
                    if (this._targetFormat.isDeployCloud() && ((string = dBObject.getObjectType()).equals("APEX") || string.equals("APEX_PAGE"))) {
                        this.write(this.INIT_APEX_SQL());
                    }
                    if ((string = extractObject.getDDL(n).trim()).length() <= 0) continue;
                    this.write(string + this.getTerm());
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void exportDataList(int n) {
        ArrayList<ExtractObject> arrayList = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : arrayList) {
                if (this._cancel) break;
                DBObject dBObject = extractObject.getDBObject();
                this.initDataExport();
                this._genOutputStream.startObject(dBObject.getObjectName(), "DATA_" + dBObject.getObjectType());
                if (extractObject.isEmptySelect()) continue;
                this.writeDataUsingFormatter(extractObject);
            }
            if (arrayList.size() > 0) {
                this._formatter.finishExport();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void exportScript(int n) {
        ArrayList<ExtractObject> arrayList = this._listModel.getList(n);
        for (ExtractObject extractObject : arrayList) {
            if (this._cancel) break;
            this._genOutputStream.writeFileEntry(extractObject.getUrl());
        }
    }

    private void writeExportDBObjects() throws Exception {
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        dDLGenerator.setWriter(this._genOutputStream.getWriter());
        dDLGenerator.setFormating(this._ddlFormat);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
        Date date = new Date();
        String string = "--------------------------------------------------------" + this.getTerm() + Messages.getString("ExportAPI.157") + simpleDateFormat.format(date) + "   " + this.getTerm() + "--------------------------------------------------------" + this.getTerm();
        if (this._targetFormat.getSaveAsType() == 0) {
            if (this._ddlFormat.isExtractEnabled() || this._dataFormat.isInsert()) {
                this.write(string);
            }
        } else {
            this._genOutputStream.setControllingFileHeader(string);
        }
        if (this._isReconcileTypesAndObjects) {
            this._listModel.startProcess();
        } else {
            this._listModel.startProcessReconcileObjects();
        }
        this.exportScript(9);
        if (!this._cancel && this._ddlFormat.isExtractEnabled() && this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("DROP", "DROP");
            this.exportMetaListAppend(4);
        }
        if (this._ddlFormat.getDep()) {
            this._ddlType.setTypes(this._listModel.getList(0, new int[]{100}));
        }
        if (!this._cancel) {
            this.exportMetaList(2);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(7);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isTruncate() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("TRUNCATE", "TRUNCATE");
            this.exportMetaListAppend(5);
        }
        if (!this._cancel) {
            this.exportDataList(8);
        }
        if (!this._cancel) {
            this.exportMetaList(3);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(6);
        }
        if (!this._cancel) {
            this.exportScript(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExportJTable(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Boolean bl = true;
        try {
            ExtractObject extractObject = this._listModel.getFirstDataObject();
            JTable jTable = null;
            jTable = !extractObject.isSqlExtendable() ? extractObject.getTable() : extractObject.getTable();
            if (bl.booleanValue()) {
                this.initDataExport();
                this._genOutputStream.startObject(extractObject.getTableName(), "DATA");
                if (extractObject.isEmptySelect()) {
                    return;
                }
                this._formatter.setOutWriter(this._genOutputStream.getWriter());
                this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
                this._formatter.setDbObject((Object)extractObject.getDBObject());
                this._formatter.setTableName(this._dataFormat.isTableNameVisible() ? this._dataFormat.getTableName() : extractObject.getTableName());
                if (jTable != null && !extractObject.isExcludedColumns()) {
                    this._formatter.setDataProvider(this.getDataProvider(jTable));
                } else if (extractObject.isSqlExtendable()) {
                    this._formatter.setDataProvider((ResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                } else {
                    this._formatter.setDataProvider((ResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                }
                this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
                this._formatter.doPrint(iRaptorTaskProgressUpdater);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                if (this._rsw != null) {
                    this._rsw.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private void initDataExport() {
        if (this._formatter == null) {
            this._formatter = (ResultsFormatter)FormatRegistry.getFormatter((String)this._dataFormat.getFormat());
            this._formatter.startExport();
            this._formatter.isHeader(this._dataFormat.isHeader());
            this._formatter.setDelimiter(this._dataFormat.getDelimiterValue());
            this._formatter.setEnclosures(this._dataFormat.getEnclosures(), this._dataFormat.getEnclosureLeftValue(), this._dataFormat.getEnclosureRightValue(), this._dataFormat.isEnclosureRightDouble());
            this._formatter.setLineTerminator(this._dataFormat.getRecordTerminatorValue());
            this._formatter.setLineTerminatorString(BaseDataFormat.getRecordTerminatorString(this._dataFormat.getRecordTerminatorValue()));
            this._formatter.isSeparateDataFile(this._dataFormat.isSeparateDataFile());
            this._formatter.setEncode(this._targetFormat.getEncoding());
            this._dataFormat.setEncoding(this._targetFormat.getEncoding());
            this._formatter.setDataName(this._dataFormat.getDataName());
            this._formatter.isQuerySaved(this._dataFormat.isQuerySaved());
            this._formatter.setQueryName(this._dataFormat.getQueryName());
            this._targetFormat.setDataFormatExtension(this._formatter.getExt());
            this._genOutputStream.setFormatter(this._formatter);
            if (this._formatter instanceof PDFFormatter) {
                PDFFormatOptions pDFFormatOptions = (PDFFormatOptions)this._listModel.getPropertyValue("REPORT_OPTIONS");
                if (pDFFormatOptions == null) {
                    pDFFormatOptions = new PDFConfig().getPDFPreferences();
                } else {
                    PDFFormatOptions pDFFormatOptions2 = new PDFConfig().getPDFPreferences();
                    pDFFormatOptions.setFontLocations(pDFFormatOptions2.getFontLocations());
                    pDFFormatOptions.setExternalLibrary(pDFFormatOptions2.getExternalLibrary());
                }
                ((PDFFormatter)this._formatter).setTempTitle(this._dataFormat.getTitle());
                ((PDFFormatter)this._formatter).setTempSubject(this._dataFormat.getSubject());
                ((PDFFormatter)this._formatter).setTempKeywords(this._dataFormat.getKeywords());
                ((PDFFormatter)this._formatter).setPDFFormatOptions(pDFFormatOptions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataUsingFormatter(ExtractObject extractObject) throws FileNotFoundException {
        if (!this._targetFormat.isCompressed()) {
            this._formatter.setOutWriter(this._genOutputStream.getWriter());
            this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
        } else {
            this._formatter.setZipper(this._genOutputStream.getZipper());
        }
        JTable jTable = extractObject.getTable();
        try {
            this._isExportOwnedResultSet = false;
            if (jTable != null && !extractObject.isTableDirty() && !extractObject.isExcludedColumns()) {
                this._formatter.setDataProvider(this.getDataProvider(jTable));
            } else if (!extractObject.getListModel().isSourceConnTimesTen()) {
                this._isExportOwnedResultSet = true;
                if (extractObject.isSqlExtendable()) {
                    this._formatter.setDataProvider((ResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSqlForVisibleCols() + extractObject.getFinalWhere(), extractObject.getBindMap()));
                } else {
                    this._formatter.setDataProvider((ResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSql() + extractObject.getFinalWhere()));
                }
            }
            this._formatter.setDbObject((Object)extractObject.getDBObject());
            this._formatter.setTableName(extractObject.getTableName());
            this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
            if (this._task != null) {
                this._formatter.doPrint(this._task.getRaptorTaskProgressUpdater());
                ArrayList arrayList = this._formatter.getAddToControllingFile();
                for (String string : arrayList) {
                    this._genOutputStream.addToControllingFile(string);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                if (this._rsw != null) {
                    this._rsw.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private ResultsFormatterWrapper getDataProvider(JTable jTable) throws Exception {
        boolean bl = false;
        if (jTable instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)jTable)).allRowsFetched();
        }
        if (!bl) {
            Connection connection = Connections.getInstance().getConnection(((ResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
            String string = ((ResultSetTableModel)((Object)jTable.getModel())).getModifiedSql();
            Map<String, ?> map = ((ResultSetTableModel)((Object)jTable.getModel())).getBindMap();
            List<?> list = ((ResultSetTableModel)((Object)jTable.getModel())).getBindList();
            this._rsw = this.getClonedResultSetForTableSql(connection, string, map, list);
            TableModel tableModel = jTable.getModel();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableFormatterWrapper tableFormatterWrapper = new TableFormatterWrapper(jTable);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            int[] nArray = new int[tableFormatterWrapper.getColumnCount()];
            int[] nArray2 = new int[tableFormatterWrapper.getColumnCount()];
            IResultSetTableModel iResultSetTableModel = ExportAPI.getBaseModel(tableModel);
            for (int i = 0; i < tableFormatterWrapper.getColumnCount(); ++i) {
                int n2;
                n = n2 = tableColumnModel.getColumn(i).getModelIndex();
                arrayList.add(n);
                nArray[i] = tableFormatterWrapper.getColumnSize(i);
                arrayList2.add(tableFormatterWrapper.getColumnName(i));
                nArray2[i] = iResultSetTableModel != null ? iResultSetTableModel.getColumnSqlType(n2) : 0;
            }
            this._isExportOwnedResultSet = true;
            return new ResultSetFormatterWrapper(this._rsw != null ? this._rsw.getResultSet() : null, arrayList, arrayList2, nArray, nArray2, string);
        }
        return new TableFormatterWrapper(jTable);
    }

    private static IResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof IResultSetTableModel ? (IResultSetTableModel)((Object)tableModel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetWrapper getClonedResultSetForTableSql(Connection connection, String string, Map<String, ?> map, List<?> list) {
        ResultSetWrapper resultSetWrapper = null;
        boolean bl = false;
        try {
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                resultSetWrapper = map != null ? DBUtil.getInstance((Connection)connection).executeQuery(string, map) : DBUtil.getInstance((Connection)connection).executeQuery(string, list);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return resultSetWrapper;
    }

    public void writeExportWithDialog() {
        boolean bl = false;
        ExtractObject extractObject = this._listModel.getFirstDataObject();
        if (extractObject != null && extractObject.getTable() != null && extractObject.getTable() instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)extractObject.getTable())).allRowsFetched();
        }
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        if (!this.isExportDBObjects()) {
            iRaptorTaskRunMode = this._targetFormat.getSaveAsType() == 0 && !bl ? IRaptorTaskRunMode.IDE_STATUSBAR : IRaptorTaskRunMode.MODAL;
        }
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        String string = this._targetFormat.getSaveAsType() < 4 ? this._targetFormat.getSaveAs() : this._targetFormat.getSaveAsTypeString();
        String string2 = ExportWizArb.format("UNLOADING", string);
        this._task = new DatabaseQueryTask<Object>(string2, iRaptorTaskRunMode, false, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() {
                try {
                    ExportAPI.this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
                    ExportAPI.this._genOutputStream.endPreamble();
                    if (!ExportAPI.this.checkSetup()) {
                        ExportAPI.this.write(ExportAPI.this.badSetup);
                    }
                    ExportAPI.this._cancel = false;
                    if (!ExportAPI.this._targetFormat.getSaveAs().equals("")) {
                        if (ExportAPI.this.isExportDBObjects()) {
                            ExportAPI.this.writeExportDBObjects();
                        } else {
                            ExportAPI.this.writeExportJTable(this.getRaptorTaskProgressUpdater());
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    try {
                        if (ExportAPI.this._rsw != null) {
                            ExportAPI.this._rsw.close();
                        }
                        ExportAPI.this._genOutputStream.finished();
                    }
                    catch (Exception exception) {}
                }
                return null;
            }

            public boolean cancel() {
                ExportAPI.this._cancel = true;
                return true;
            }

            @Override
            public String getConnectionName() {
                return ExportAPI.this._connName;
            }

            @Override
            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    if (ExportAPI.this._targetFormat.isSftp()) {
                        SftpUtil sftpUtil = new SftpUtil();
                        sftpUtil.SftpPut(ExportAPI.this._targetFormat.getSftpParms(), true);
                    } else if (ExportAPI.this._genOutputStream != null) {
                        ExportAPI.this._genOutputStream.openTargetInUI(ExportAPI.this._connName);
                    }
                    LOGGER.log(Level.INFO, Messages.getString("EXPORT_DONE"));
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    ExportAPI.this._task = null;
                }
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }
}

