/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.user;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.user.PrivilegeObject;
import oracle.dbtools.raptor.dialogs.user.PrivilegesPanel;
import oracle.dbtools.raptor.dialogs.user.QuotaObject;
import oracle.dbtools.raptor.dialogs.user.QuotaPanel;
import oracle.dbtools.raptor.dialogs.user.ResultPanel;
import oracle.dbtools.raptor.dialogs.user.RoleObject;
import oracle.dbtools.raptor.dialogs.user.RolePanel;
import oracle.dbtools.raptor.dialogs.user.SqlPanel;
import oracle.dbtools.raptor.dialogs.user.UserObject;
import oracle.dbtools.raptor.dialogs.user.UserPanel;
import oracle.dbtools.raptor.newscriptrunner.OutputRedirector;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleDriver;

public class UserDialog {
    private static Connection connection;
    private static UserObject uo;
    private static UserPanel up;
    private static RolePanel rp;
    private static QuotaPanel qp;
    private static SqlPanel sp;
    private static ResultPanel res;
    private static PrivilegesPanel pp;
    Runnable script = null;
    private boolean enableEdition = false;

    public void main(String[] stringArray) throws Exception {
        SimpleIdeCore.initIde();
        DriverManager.registerDriver((Driver)new OracleDriver());
        String string = "jdbc:oracle:thin:@skutz-xp:1522:XE";
        Connection connection = DriverManager.getConnection(string, "system", "sparrow");
        connection.setAutoCommit(false);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(new ObjectAction(), null);
        this.showDialog(connection, "SCOTT", objectActionPostProcess);
        Ide.getMainWindow().pack();
    }

    public void showDialog(Connection connection, String string, final ObjectActionController.ObjectActionPostProcess objectActionPostProcess) throws Exception {
        String[] stringArray;
        JPanel[] jPanelArray2;
        Object object;
        Map<String, RoleObject> map;
        assert (objectActionPostProcess != null);
        UserDialog.connection = connection;
        this.enableEdition = DBUtil.checkVersion((Connection)connection, null, (Version)new Version("11.2"));
        uo = new UserObject(connection, string);
        up = new UserPanel(this.enableEdition);
        rp = new RolePanel();
        qp = new QuotaPanel();
        sp = new SqlPanel();
        res = new ResultPanel();
        pp = new PrivilegesPanel();
        UserDialog.up.userName.setText(uo.getUserName());
        UserDialog.up.userName.setEnabled(!uo.isAlter());
        UserDialog.up.userPass1.setText(uo.getPassword());
        UserDialog.up.userPass2.setText(uo.getPassword());
        UserDialog.up.accountLocked.setSelected(uo.isLocked());
        UserDialog.up.editionEnabled.setSelected(uo.getEdition());
        UserDialog.up.passExpired.setSelected(uo.isExpired());
        QuotaPanel.QuotaTableTableModel quotaTableTableModel = qp.getTableModel();
        Map<String, QuotaObject> map2 = uo.getQuotas();
        for (String object32 : map2.keySet()) {
            if (uo.getQuotas().get(object32).getContents().equals("TEMPORARY")) {
                UserDialog.up.tempTablespace.addItem(object32);
            }
            UserDialog.up.defTablespace.addItem(object32);
            map = map2.get(object32);
            quotaTableTableModel.addRow(object32, ((QuotaObject)((Object)map)).isUnlimited(), ((QuotaObject)((Object)map)).getQuota(), ((QuotaObject)((Object)map)).getUnit());
        }
        List<String> list = uo.getTablespaceGroups();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            map = (String)iterator.next();
            UserDialog.up.tempTablespace.addItem(map);
        }
        UserDialog.up.tempTablespace.setSelectedItem(uo.getTempTableSpace());
        UserDialog.up.defTablespace.setSelectedItem(uo.getDefTableSpace());
        RolePanel.RoleTableTableModel roleTableTableModel = rp.getTableModel();
        map = uo.getRoles();
        for (String string2 : map.keySet()) {
            object = map.get(string2);
            roleTableTableModel.addRow(string2, ((RoleObject)object).isGranted(), ((RoleObject)object).isAdmin(), ((RoleObject)object).isDef());
        }
        PrivilegesPanel.PrivTableTableModel privTableTableModel = pp.getTableModel();
        Map<String, PrivilegeObject> map3 = uo.getPrivs();
        for (JPanel[] jPanelArray2 : map3.keySet()) {
            stringArray = map3.get(jPanelArray2);
            privTableTableModel.addRow((String)jPanelArray2, stringArray.isGranted(), stringArray.isAdmin());
        }
        object = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                UserDialog.this.updateSQL();
            }
        };
        sp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                UserDialog.this.updateSQL();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        jPanelArray2 = new JPanel[6];
        stringArray = new String[6];
        stringArray[0] = Messages.getString((String)"UserDialog.6");
        jPanelArray2[0] = up;
        stringArray[1] = Messages.getString((String)"UserDialog.7");
        jPanelArray2[1] = rp;
        stringArray[2] = Messages.getString((String)"UserDialog.8");
        jPanelArray2[2] = pp;
        stringArray[3] = Messages.getString((String)"UserDialog.9");
        jPanelArray2[3] = qp;
        stringArray[4] = Messages.getString((String)"UserDialog.10");
        jPanelArray2[4] = sp;
        stringArray[5] = Messages.getString((String)"UserDialog.11");
        jPanelArray2[5] = res;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UserDialog.updateUserObject().booleanValue()) {
                    PipedInputStream pipedInputStream = new PipedInputStream();
                    res.getSqlPane().setEditable(true);
                    res.getSqlPane().setText("");
                    res.getSqlPane().setEditable(false);
                    JTabbedPane jTabbedPane = (JTabbedPane)res.getParent();
                    jTabbedPane.setSelectedIndex(5);
                    ScriptExecutor scriptExecutor = new ScriptExecutor(uo.getSql(), connection);
                    ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                    scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                    OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, res.getSqlPane().getDocument(), res.getSqlPane());
                    outputRedirector.setName(Messages.getString((String)"UserDialog.14"));
                    outputRedirector.start();
                    try {
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                        scriptExecutor.setOut(bufferedOutputStream);
                    }
                    catch (IOException iOException) {
                        Logger.ignore(UserDialog.this.getClass(), (Throwable)iOException);
                    }
                    scriptExecutor.start();
                    uo.setAlter(true);
                    up.userName.setEnabled(false);
                    if (!Boolean.TRUE.equals(scriptRunnerContext.getProperty("sqldev.error"))) {
                        objectActionPostProcess.run();
                    }
                } else {
                    return;
                }
            }
        };
        UIUtils.showPanelAsTabbedDialog2((JPanel[])jPanelArray2, (String[])stringArray, (String)Messages.getString((String)"UserDialog.12"), (ActionListener)actionListener, null, (ChangeListener)object);
    }

    private void updateSQL() {
        if (qp != null && qp.getTable() != null && qp.getTable().getCellEditor() != null) {
            qp.getTable().getCellEditor().stopCellEditing();
        }
        UserDialog.sp._sql.setEditable(true);
        UserDialog.sp._sql.setText("");
        UserDialog.sp._sql.setEditable(false);
        if (UserDialog.updateUserObject().booleanValue()) {
            UserDialog.sp._sql.setEditable(true);
            UserDialog.sp._sql.setText(uo.getSql());
            UserDialog.sp._sql.setEditable(false);
        }
    }

    public static Boolean updateUserObject() {
        uo.setUserName(UserDialog.up.userName.getText());
        uo.setLocked(UserDialog.up.accountLocked.isSelected());
        uo.setExpired(UserDialog.up.passExpired.isSelected());
        String string = new String(UserDialog.up.userPass1.getPassword());
        String string2 = new String(UserDialog.up.userPass2.getPassword());
        if (string.equals(string2) && !string.equals("")) {
            uo.setPassword(string);
        }
        uo.setDefTableSpace((String)UserDialog.up.defTablespace.getSelectedItem());
        uo.setTempTableSpace((String)UserDialog.up.tempTablespace.getSelectedItem());
        if (UserDialog.up.accountLocked.isSelected()) {
            uo.setLocked(true);
        } else {
            uo.setLocked(false);
        }
        if (UserDialog.up.editionEnabled.isSelected()) {
            uo.setEdition(true);
        } else {
            uo.setEdition(false);
        }
        for (RoleObject object : rp.getTableModel().getData()) {
            uo.updateRole(object);
        }
        for (PrivilegeObject privilegeObject : pp.getTableModel().getData()) {
            uo.updatePrivs(privilegeObject);
        }
        for (QuotaObject quotaObject : qp.getTableModel().getData()) {
            uo.updateQuota(quotaObject);
        }
        return true;
    }
}

