/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.privs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dialogs.privs.PrivActionArb;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class PrivAction
extends ActionDialog {
    private String user_sql;
    private Map<String, Object> user_sql_binds = new HashMap<String, Object>();
    private String all_users = "select 'PUBLIC' from dual union all select username from all_users union all select distinct role from session_roles order by 1";
    private String revokable_users = "Select GRANTEE from sys.all_col_privs where TABLE_SCHEMA = :OWNER and TABLE_NAME =  :OBJECT_NAME union Select  GRANTEE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER and TABLE_NAME = :OBJECT_NAME";
    private String granted_privs = "Select PRIVILEGE from sys.all_col_privs where TABLE_SCHEMA = :OWNER and TABLE_NAME =  :OBJECT_NAME and GRANTEE = :GRANTEE union Select PRIVILEGE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER and TABLE_NAME = :OBJECT_NAME and GRANTEE = :GRANTEE";
    private String op;
    private ArrayList<String> all_actions = new ArrayList();
    private ArrayList<String> grants = new ArrayList();
    private ArrayList<String> revokes = new ArrayList();
    private ActionControl schema;
    private ActionControl object;
    private ActionControl users;
    private ActionControl withGrant;
    private ActionControl shuttle;
    private ActionControl grantAll;
    private ActionControl revokeAll;

    private void loadArgs() {
        this.all_actions.clear();
        String string = this.getArgs();
        String[] stringArray = string.split(",");
        this.op = stringArray[0];
        for (String string2 : stringArray) {
            if (string2.equals(this.op)) continue;
            this.all_actions.add(string2);
        }
    }

    private Operation getOperation() {
        try {
            Operation operation = Operation.valueOf(this.op);
            return operation;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = this.getDBObject().getConnection();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                hashMap.put("OBJECT_NAME", this.getDBObjectName());
                if (this.getDbObjectType().equals("DIRECTORY")) {
                    hashMap.put("OWNER", "SYS");
                } else {
                    hashMap.put("OWNER", this.getDBObjectSchemaName());
                }
                hashMap.put("GRANTEE", this.users.getValue().get());
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        this.loadArgs();
        String string = this.getDBObjectName();
        String string2 = this.getDBObjectSchemaName();
        if (this.getOperation() == Operation.REVOKE) {
            this.user_sql = this.revokable_users;
            this.user_sql_binds.clear();
            if (this.getDbObjectType().equals("DIRECTORY")) {
                this.user_sql_binds.put("OWNER", "SYS");
            } else {
                this.user_sql_binds.put("OWNER", string2);
            }
            this.user_sql_binds.put("OBJECT_NAME", string);
        } else {
            this.user_sql = this.all_users;
            this.user_sql_binds.clear();
        }
        this.schema = new TextBoxActionControl("schema", PrivActionArb.getString("SCHEMA_LABEL"), string2);
        this.object = new TextBoxActionControl("object", PrivActionArb.getString("OBJECT_LABEL"), string);
        this.shuttle = new StringShuttleControl("shuttle", null, null, null);
        this.users = new SqlComboBoxActionControl("users", PrivActionArb.getString("USER_LABEL"), this.getDBObject().getConnection(), this.user_sql, this.user_sql_binds, new String());
        this.users.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PrivAction.this.revokes.clear();
                PrivAction.this.revokes = PrivAction.this.getList(PrivAction.this.granted_privs);
                PrivAction.this.grants.clear();
                for (String string : PrivAction.this.all_actions) {
                    PrivAction.this.grants.add(string);
                }
                PrivAction.this.grants.removeAll(PrivAction.this.revokes);
                ((StringShuttleControl)PrivAction.this.shuttle).setLists(PrivAction.this.grants, PrivAction.this.revokes);
            }
        });
        this.withGrant = new BooleanCheckBoxActionControl("withGrant", PrivActionArb.getString("WITH_GRANT_LABEL"), false);
        this.revokeAll = new BooleanCheckBoxActionControl("revokeAll", PrivActionArb.getString("REVOKE_ALL"), false);
        this.revokeAll.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PrivAction.this.revokeAll.getValue().get().equals("true")) {
                    PrivAction.this.shuttle.setEditable(false);
                } else {
                    PrivAction.this.shuttle.setEditable(true);
                }
            }
        });
        this.grantAll = new BooleanCheckBoxActionControl("grantAll", PrivActionArb.getString("GRANT_ALL"), false);
        this.grantAll.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PrivAction.this.grantAll.getValue().get().equals("true")) {
                    PrivAction.this.shuttle.setEditable(false);
                } else {
                    PrivAction.this.shuttle.setEditable(true);
                }
            }
        });
        this.schema.setEditable(false);
        this.object.setEditable(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add(this.schema);
        arrayList.add(this.object);
        arrayList.add(this.users);
        if (this.getOperation() == Operation.GRANT) {
            arrayList.add(this.withGrant);
            arrayList.add(new SeperatorActionControl());
            arrayList.add(this.grantAll);
        } else if (this.getOperation() == Operation.REVOKE) {
            arrayList.add(new SeperatorActionControl());
            arrayList.add(this.revokeAll);
        } else {
            arrayList.add(this.withGrant);
            arrayList.add(new SeperatorActionControl());
            arrayList.add(this.grantAll);
            arrayList.add(this.revokeAll);
        }
        arrayList.add(this.shuttle);
        List<ActionControl> list = this.getCustomControls(connection);
        if (list != null && list.size() > 0) {
            for (ActionControl actionControl : this.getCustomControls(connection)) {
                arrayList.add(actionControl);
            }
        }
        return arrayList;
    }

    private String getGrants(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = values.getList("shuttle", "added");
        if (list.size() == 0 && (values.get("grantAll") == null || values.get("grantAll").equals("false"))) {
            return stringBuilder.toString();
        }
        stringBuilder.append("grant ");
        if (values.get("grantAll") != null && values.get("grantAll").equals("true")) {
            stringBuilder.append("all ");
        } else {
            for (String string : list) {
                stringBuilder.append(string + ", ");
            }
            if (stringBuilder.lastIndexOf(",") > -1) {
                stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
            }
        }
        stringBuilder.append("on ");
        if (this.getDbObjectType().equals("DIRECTORY")) {
            stringBuilder.append("directory ");
            stringBuilder.append("\"" + values.get("object") + "\" to " + values.get("users") + " ");
        } else {
            stringBuilder.append("\"" + values.get("schema") + "\".\"" + values.get("object") + "\" to \"" + values.get("users") + "\" ");
        }
        if (values.get("withGrant").equals("true")) {
            stringBuilder.append("with grant option");
        }
        stringBuilder.append(";\r");
        if (values.get("users") == null || values.get("users").equals("")) {
            return "\n";
        }
        return stringBuilder.toString();
    }

    private String getRevokes(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = values.getList("shuttle", "removed");
        if (list.size() == 0 && (values.get("revokeAll") == null || values.get("revokeAll").equals("false"))) {
            return stringBuilder.toString();
        }
        stringBuilder.append("revoke ");
        if (values.get("revokeAll") != null && values.get("revokeAll").equals("true")) {
            stringBuilder.append("all ");
        } else {
            for (String string : list) {
                stringBuilder.append(string + ", ");
            }
            if (stringBuilder.lastIndexOf(",") > -1) {
                stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
            }
        }
        stringBuilder.append("on ");
        if (this.getDbObjectType().equals("DIRECTORY")) {
            stringBuilder.append("directory ");
            stringBuilder.append("\"" + values.get("object") + "\" from " + values.get("users") + " ");
        } else {
            stringBuilder.append("\"" + values.get("schema") + "\".\"" + values.get("object") + "\" from \"" + values.get("users") + "\" ");
        }
        if (values.get("users") == null || values.get("users").equals("")) {
            return "\n";
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGrants(values));
        stringBuilder.append(this.getRevokes(values));
        stringBuilder.append(this.getCustomSql(values));
        return stringBuilder.toString();
    }

    @Override
    protected String getTitle() {
        String string = new String();
        Operation operation = this.getOperation();
        if (operation == Operation.GRANT) {
            string = PrivActionArb.getString("GRANT_TITLE");
        } else if (operation == Operation.REVOKE) {
            string = PrivActionArb.getString("REVOKE_TITLE");
        }
        return string;
    }

    protected String getCustomSql(ActionDialog.Values values) {
        return "";
    }

    protected List<ActionControl> getCustomControls(Connection connection) {
        return null;
    }

    private static enum Operation {
        GRANT,
        REVOKE;

    }
}

