/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.GenericGrantEditor;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;

public class RevokePrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final List<String> _usersWithGrants = new ArrayList<String>();
    private final Map<String, List<String>> _usersPrivs = new HashMap<String, List<String>>();
    private ObjectActionController.ObjectActionPostProcess _oapp;

    protected RevokePrivilegesPanel(DBObject dBObject, ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        super(dBObject);
        this._oapp = objectActionPostProcess;
        this.init();
    }

    protected void init() {
        this.populateUserGrants();
        ((DefaultComboBoxModel)this.cbxUsers.getModel()).removeAllElements();
        for (int i = 0; i < this._usersWithGrants.size(); ++i) {
            ((DefaultComboBoxModel)this.cbxUsers.getModel()).addElement(this._usersWithGrants.get(i));
        }
        this.cbxUsers.setSelectedIndex(-1);
        this.mdlPrivFrom.removeAllElements();
        this.cbxUsers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object != null) {
                    String string = (String)object;
                    try {
                        RevokePrivilegesPanel.this.mdlPrivFrom.removeAllElements();
                        for (int i = 0; i < ((List)RevokePrivilegesPanel.this._usersPrivs.get(string)).size(); ++i) {
                            RevokePrivilegesPanel.this.mdlPrivFrom.addElement(((List)RevokePrivilegesPanel.this._usersPrivs.get(string)).get(i));
                        }
                        RevokePrivilegesPanel.this.lstPrivFrom.updateUI();
                    }
                    catch (Exception exception) {
                        SQLErrorDialog.showErrorDialog((String)RevokePrivilegesPanel.this.getDBObject().getConnectionName(), null, (String)Messages.getString((String)"RevokePrivilegesPanel.0"), (SQLException)((SQLException)exception));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserGrants() {
        String string = "Select GRANTEE, PRIVILEGE  from sys.all_col_privs  where TABLE_SCHEMA = :OWNER  and TABLE_NAME =  :OBJECT_NAME  union all  Select  GRANTEE, PRIVILEGE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER  and TABLE_NAME = :OBJECT_NAME";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DBObject dBObject = this.getDBObject();
        if (dBObject.getObjectType().equalsIgnoreCase("DIRECTORY")) {
            hashMap.put("OWNER", GenericGrantEditor.DIRECTORY_OWNER);
        } else {
            hashMap.put("OWNER", dBObject.getSchemaName());
        }
        hashMap.put("OBJECT_NAME", dBObject.getObjectName());
        String string2 = dBObject.getConnectionName();
        DBUtil dBUtil = DBUtil.getInstance((String)string2);
        if (Connections.getInstance().lock(string2)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    List<String> list;
                    String string3 = resultSet.getString(1);
                    if (!this._usersWithGrants.contains(string3)) {
                        this._usersWithGrants.add(string3);
                    }
                    if ((list = this._usersPrivs.get(string3)) == null) {
                        list = new ArrayList<String>();
                        this._usersPrivs.put(string3, list);
                    }
                    list.add(resultSet.getString(2));
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRevoke() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("revoke ");
        if (this.chkAll.isSelected()) {
            stringBuilder.append("ALL");
        } else {
            object = this.getSelectedPrivileges();
            for (int i = 0; i < object.size(); ++i) {
                if (i != object.size() - 1) {
                    stringBuilder.append(object.get(i) + ",");
                    continue;
                }
                stringBuilder.append(object.get(i));
            }
        }
        stringBuilder.append(" on ");
        if (this.getDBObject().getObjectType().equalsIgnoreCase("DIRECTORY")) {
            stringBuilder.append(" directory ");
            stringBuilder.append("\"" + this.getDBObject().getObjectName() + "\"");
        } else {
            stringBuilder.append("\"" + this.getDBObject().getSchemaName() + "\".\"" + this.getDBObject().getObjectName() + "\"");
        }
        stringBuilder.append(" from ");
        stringBuilder.append("\"" + (String)this.cbxUsers.getSelectedItem() + "\"");
        object = this.getDBObject().getConnectionName();
        DBUtil dBUtil = DBUtil.getInstance((String)object);
        if (Connections.getInstance().lock((String)object)) {
            try {
                Log.log((String)("REVOKE:" + stringBuilder.toString()));
                if (dBUtil.execute(stringBuilder.toString(), (List)null) && this._oapp != null) {
                    this._oapp.run();
                }
            }
            finally {
                Connections.getInstance().unlock((String)object);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performRevoke();
        this.close(actionEvent);
    }
}

