/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class RemoteDebug
extends AbstractMenuAction {
    private static boolean init = false;

    @Override
    public void launch() {
        try {
            this.getDBObject().getConnection();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"RemoteDebug.0"), (String)Messages.getString((String)"RemoteDebug.1"), null);
            return;
        }
        if (!init) {
            Runner.getRunner().registerStarterFactory(DatabaseConnection.class, (StarterFactory)new DBStarterFactory());
            init = true;
        }
        Context context = this.getContext();
        Project project = context.getProject();
        RunConfiguration runConfiguration = RemoteDebug.getRemoteDebugConfiguration(project);
        context.setProperty("RunContext.RUN_CONFIGURATION", (Object)runConfiguration);
        RunConfigurations.setActiveRunConfiguration((Project)project, (RunConfiguration)runConfiguration);
        DebuggingProcess debuggingProcess = new DebuggingProcess(context);
        debuggingProcess.setLabelOverride(Messages.getString((String)"RemoteDebug.2"));
        debuggingProcess.setStopInChrome(false);
        debuggingProcess.getValue("Database", null, "DatabaseRunHelper");
        debuggingProcess.start();
    }

    public static RunConfiguration getRemoteDebugConfiguration(Project project) {
        RunConfiguration runConfiguration = RunConfigurations.getRunConfigurationByName((Project)project, (String)"Remote Debug");
        if (runConfiguration == null) {
            runConfiguration = new RunConfiguration();
            runConfiguration.setName("Remote Debug");
            if (project != null) {
                RunConfigurations.addRunConfiguration((Project)project, (RunConfiguration)runConfiguration);
            }
        }
        runConfiguration.setRemoteDebuggingProfiling(true);
        runConfiguration.setRunActiveFile(false);
        HashStructure hashStructure = runConfiguration.getProperties();
        hashStructure.putString("remoteProtocol", "jpdaListen");
        hashStructure.putString("RUN_PROPS", "RUN_PROPS");
        HashStructure hashStructure2 = HashStructure.newInstance();
        hashStructure2.putString("remoteProtocol", "jpdaListen");
        hashStructure.putHashStructure(DebugConfiguration.class.getName(), hashStructure2);
        return runConfiguration;
    }
}

