/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.util.logging.Logger;
import oracle.dbtools.raptor.ContextMenuFilter;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;

public class BasicObjectModifier
implements ContextMenuListener {
    private static final Logger LOGGER = Logger.getLogger(BasicObjectModifier.class.getName());
    private static XMLBasedObjectAction s_xmlActions;

    public void menuWillShow(ContextMenu contextMenu) {
        DBObject dBObject = null;
        this.initMenus();
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".menuWillShow");
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        Node node = context.getNode();
        boolean bl = elementArray.length > 1;
        dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (node == null && elementArray.length > 0) {
            node = elementArray[0];
        }
        if (node != null) {
            dBObject = new DBObject((Element)node);
        }
        if (dBObject != null) {
            context.setProperty("ObjectAction.CONN_NAME", (Object)dBObject.getConnectionName());
            context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
            if ("RECYCLEBIN".equals(dBObject.getObjectType())) {
                contextMenu.removeAll();
            }
            LOGGER.info(Messages.getString((String)"BasicObjectModifier.2") + dBObject.getKey() + ":" + dBObject.getObjectName() + "\n");
            s_xmlActions.addToMenu(contextMenu, dBObject, bl);
            PerformanceLogger.get().stopTiming(this.getClass().getName() + ".menuWillShow", Messages.getString((String)"BasicObjectModifier.6"));
            contextMenu.addMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
            LOGGER.info(context.toString());
            contextMenu.sortContainer(contextMenu.getGUI(true));
        }
    }

    private void initMenus() {
        try {
            if (s_xmlActions == null) {
                s_xmlActions = XMLBasedObjectAction.getInstance();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
        contextMenu.removeMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

