/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;

public class OracleMetaSetup {
    Connection _conn = null;
    private static String META_SETUP = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', ifelse(:ALTER));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:REF_CONSTRAINT)); end;";
    private static String META_SETUP_SCRIPT = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR',  ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY',  ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD',  ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE',  ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA',  ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:REF_CONSTRAINT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', false);  end;";

    public OracleMetaSetup(Connection connection, String string) {
        this._conn = connection;
        this.setup(string);
    }

    public void setConnection(Connection connection) {
        this._conn = connection;
    }

    private void setup(String string) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        if (dDLFormat == null) {
            dDLFormat = new DDLFormat();
        }
        if (string.equals("SCRIPT")) {
            hashMap.put("CONSTRAINT", false);
            hashMap.put("REF_CONSTRAINT", false);
        } else if (string.equals("COPY")) {
            hashMap.put("CONSTRAINT", false);
            hashMap.put("REF_CONSTRAINT", false);
        } else if (string.startsWith("DDL ")) {
            hashMap.put("CONSTRAINT", true);
            hashMap.put("REF_CONSTRAINT", true);
            hashMap.put("ALTER", DBConfig.getInstance().getBoolean("DDL_ALTER"));
        }
        hashMap.put("SHOWSCHEMA", dDLFormat.getSchema());
        hashMap.put("SEGMENTS", dDLFormat.getSegments());
        hashMap.put("TERMINATOR", dDLFormat.getTerminator());
        hashMap.put("PRETTY", dDLFormat.getPretty());
        hashMap.put("BYTE", dDLFormat.getByte());
        hashMap.put("FORCE", dDLFormat.getForce());
        DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
        dBUtil.setRaiseError(false);
        if (string.equals("COPY") || string.equals("SCRIPT") || string.equals("DEP")) {
            dBUtil.execute(META_SETUP_SCRIPT, hashMap);
        } else {
            dBUtil.execute(META_SETUP, hashMap);
        }
    }
}

