/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class TargetFormat {
    public static final int PREFERENCES = 0;
    public static final int WIZARD = 1;
    public static final int UNDEFINED = 1;
    public static final int EXPORT = 1;
    public static final int DIFF = 2;
    public static final int CART = 3;
    public static final int CART_SCRIPT = 4;
    public static final int DEPLOY = 5;
    public static final int SINGLE_FILE = 0;
    public static final int MULTIPLE_FILES = 1;
    public static final int TYPE_FILES = 2;
    public static final int SEPARATE_DIRS = 3;
    public static final int STRING_TYPE = 4;
    public static final int WORKSHEET = 4;
    public static final int CLIPBOARD = 5;
    public static final int ZIP = 0;
    public static final String SINGLE_FILE_STR = DDLResources.getString("SAVE_AS_SINGLE");
    public static final String MULTIPLE_FILES_STR = DDLResources.getString("SAVE_AS_MULTIPLE_FILES");
    public static final String TYPE_FILES_STR = DDLResources.getString("SAVE_AS_BY_TYPE");
    public static final String SEPARATE_DIRS_STR = DDLResources.getString("SAVE_AS_SEP_DIRS");
    public static final String WORKSHEET_STR = DDLResources.getString("SAVE_AS_WORKSHEET");
    public static final String CLIPBOARD_STR = DDLResources.getString("SAVE_AS_CLIPBOARD");
    public static final String ZIP_STR = "ZIP";
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;
    public static final int MAX_AUTO_OPEN_SIZE = 500000;
    private static final String SQL_EXT = ".sql";
    private static final String SQLDEV_EXT = ".sqldev";
    public static final String ZIP_EXT_STR = "zip";
    private static final String DEPLOY_STR = "deploy";
    private static String[] _saveAsTypes = new String[]{SINGLE_FILE_STR, MULTIPLE_FILES_STR, TYPE_FILES_STR, SEPARATE_DIRS_STR, WORKSHEET_STR, CLIPBOARD_STR};
    private static String[] _compressionTypes = new String[]{"ZIP"};
    private static String[] _compressionExtensions = new String[]{"zip"};
    private int _usage = 1;
    private int _preference = 1;
    private int _saveAsType;
    private String _saveAs;
    private boolean _isCompressed;
    private int _compressionType = 0;
    private boolean _isExcutableControlFile = true;
    private boolean _isDeployCloud = false;
    private boolean _isSftp = false;
    private SftpParms _sFtpParms;
    private String _controllingBaseName;
    private String _dataFormatExtension;
    private String _encoding = IdeUtil.getIdeEncoding();
    private String[] _encodings;
    private boolean _openTarget = true;
    private boolean _genScript = true;
    private boolean _defaultOpenTarget;
    private String _validationMessage;
    boolean _showSaveAsType = true;
    boolean _showCompression = false;
    boolean _showEncoding = true;

    public TargetFormat() {
        this(1, 1);
    }

    public TargetFormat(int n, int n2) {
        this._usage = n;
        this._preference = n2;
        this.initFormat();
    }

    public boolean getShowSaveAsType() {
        return this._showSaveAsType;
    }

    public void setShowSaveAsType(boolean bl) {
        this._showSaveAsType = bl;
    }

    public boolean getShowCompression() {
        return this._showCompression;
    }

    public void setShowCompression(boolean bl) {
        this._showCompression = bl;
    }

    public boolean getShowEncoding() {
        return this._showEncoding;
    }

    public void setShowEncoding(boolean bl) {
        this._showEncoding = bl;
    }

    public int getUsage() {
        return this._usage;
    }

    public void setUsage(int n) {
        this._usage = n;
    }

    public int getPreference() {
        return this._preference;
    }

    public void setPreference(int n) {
        this._preference = n;
    }

    public boolean isOpenTarget() {
        return this._openTarget;
    }

    public void isOpenTarget(boolean bl) {
        this._openTarget = bl;
    }

    public boolean isGenScript() {
        return this._genScript;
    }

    public void isGenScript(boolean bl) {
        this._genScript = bl;
    }

    public boolean isDefaultOpenTarget() {
        return this._defaultOpenTarget;
    }

    public String[] getSaveAsTypes() {
        return _saveAsTypes;
    }

    public String getSaveAsTypeString() {
        switch (this._saveAsType) {
            case 0: {
                return SINGLE_FILE_STR;
            }
            case 1: {
                return MULTIPLE_FILES_STR;
            }
            case 2: {
                return TYPE_FILES_STR;
            }
            case 3: {
                return SEPARATE_DIRS_STR;
            }
            case 4: {
                return WORKSHEET_STR;
            }
            case 5: {
                return CLIPBOARD_STR;
            }
        }
        return SINGLE_FILE_STR;
    }

    public int getSaveAsType() {
        return this._saveAsType;
    }

    public void setSaveAsType(int n) {
        this._saveAsType = n;
    }

    public String getSaveAs() {
        return this._saveAs;
    }

    public void setSaveAs(String string) {
        this._saveAs = string;
    }

    public boolean isExcutableControlFile() {
        return this._isExcutableControlFile;
    }

    public void isExcutableControlFile(boolean bl) {
        this._isExcutableControlFile = bl;
    }

    public boolean isDeployCloud() {
        return this._isDeployCloud;
    }

    public void isDeployCloud(boolean bl) {
        this._isDeployCloud = bl;
    }

    public boolean isSftp() {
        return this._isSftp;
    }

    public void isSftp(boolean bl) {
        this._isSftp = bl;
    }

    public SftpParms getSftpParms() {
        return this._sFtpParms;
    }

    public void setSftpParms(SftpParms sftpParms) {
        this._sFtpParms = sftpParms;
    }

    public boolean isCompressed() {
        return this._isCompressed;
    }

    public void isCompressed(boolean bl) {
        this._isCompressed = bl;
    }

    public String[] getCompressionTypes() {
        return _compressionTypes;
    }

    public String getCompressionTypeString() {
        switch (this._saveAsType) {
            case 0: {
                return ZIP_STR;
            }
        }
        return ZIP_STR;
    }

    public int getCompressionType() {
        return this._compressionType;
    }

    public void setCompressionType(int n) {
        this._compressionType = n;
    }

    public String getCompressionExt() {
        return _compressionExtensions[this._compressionType];
    }

    public String getControllingBaseName() {
        if (this.getControllingFileName() == null || this.getControllingFileName().length() == 0) {
            this._controllingBaseName = "export.sql";
        }
        return this._controllingBaseName;
    }

    public void setControllingBaseName(String string) {
        this._controllingBaseName = string;
    }

    public String getControllingFile() {
        if (this._isCompressed) {
            return this.getControllingFileName();
        }
        if (this._saveAsType == 0) {
            String string = new File(this._saveAs).getParentFile().getPath();
            return string.endsWith(File.separator) ? string + this.getControllingFileName() : string + File.separatorChar + this.getControllingFileName();
        }
        return this._saveAs.endsWith(File.separator) ? this._saveAs + this.getControllingFileName() : this._saveAs + File.separatorChar + this.getControllingFileName();
    }

    public String getControllingFileName() {
        return this._isExcutableControlFile ? this._controllingBaseName + SQL_EXT : "deploy.sqldev";
    }

    public String getDataFormatExtension() {
        return this._dataFormatExtension;
    }

    public void setDataFormatExtension(String string) {
        this._dataFormatExtension = string;
    }

    public URL getSaveAsURL() {
        return this.getURL(this._saveAs);
    }

    public URL getControllingURL() {
        return this.getURL(this.getControllingFile());
    }

    public URL getURL(String string) {
        try {
            return string != null ? new File(string).toURI().toURL() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getDefaultSaveAs() {
        String string = this.getDefaultDirectory();
        if (this._usage != 0 && (this._saveAsType == 0 || this.isCompressed())) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string = this.isCompressed() ? string + DDLResources.getString("DEFAULT_DEPLOY_FILENAME") + "." + ZIP_EXT_STR : string + DDLResources.getString("DEFAULT_EXPORT_FILENAME") + "." + "sql";
        }
        return string;
    }

    public int validateSaveAs(Component component) {
        this._validationMessage = null;
        if (this._usage == 1) {
            if (this._saveAs == null || this._saveAs.trim().equals("")) {
                this._validationMessage = DDLResources.getString("NO_SAVE_AS");
                return 1;
            }
            if (this._saveAsType == 0) {
                return this.validateSaveAsFile(component);
            }
        }
        return this.validateSaveAsDir(component);
    }

    public int validateSaveAsFile(Component component) {
        Object[] objectArray = new Object[]{this._saveAs};
        File file = new File(this._saveAs);
        if (file.isDirectory()) {
            this._validationMessage = DDLResources.format("DIR_FOUND", objectArray);
            return 1;
        }
        if (file.isFile()) {
            boolean bl = MessageDialog.confirm((Component)component, (Object)DDLResources.format("OVERWRITE_FILE", objectArray), (String)DDLResources.getString("CONFIRM_OVERWRITE"), null);
            if (!bl) {
                return 2;
            }
            if (!file.delete()) {
                this._validationMessage = DDLResources.format("UNABLE_TO_DELETE_FILE", objectArray);
                return 1;
            }
            return 0;
        }
        if (file.getParent() == null) {
            String string;
            String string2 = this.getDefaultDirectory();
            if (string2.length() == 0) {
                this._validationMessage = DDLResources.format("NO_DEFAULT_DIR", string2);
                return 1;
            }
            File file2 = new File(string2);
            if (!file2.isDirectory()) {
                this._validationMessage = DDLResources.format("NO_DEFAULT_DIR", string2);
                return 1;
            }
            String string3 = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
            file = new File(string3 + this._saveAs);
            this._saveAs = string = string3 + this._saveAs;
            return this.canCreateAction(file);
        }
        if (this.canCreate(file)) {
            return 0;
        }
        File file3 = file.getParentFile();
        if (!file3.isDirectory()) {
            boolean bl = MessageDialog.confirm((Component)component, (Object)DDLResources.format("CREATE_DIRS", objectArray), (String)DDLResources.getString("CONFIRM_CREATE_DIR"), null);
            if (!bl) {
                return 2;
            }
            if (file3 != null && file3.mkdirs()) {
                return 0;
            }
            this._validationMessage = DDLResources.format("INVALID_DIR", file3.getPath());
            return 1;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", file3.getPath());
        return 1;
    }

    public int validateSaveAsDir(Component component) {
        File file = new File(this._saveAs);
        Object[] objectArray = new Object[]{this._saveAs};
        if (file.isDirectory()) {
            return this.canCreateInAction(file);
        }
        if (file.isFile()) {
            this._validationMessage = DDLResources.format("DIR_REQUIRED", objectArray);
            return 1;
        }
        if (this._saveAs == null || this._saveAs.trim().equals("")) {
            if (this._usage == 0) {
                return 0;
            }
            Object var4_4 = null;
            String string = this.getDefaultDirectory();
            if (string == "") {
                this._validationMessage = DDLResources.getString("NO_DEFAULT_DIR");
                return 1;
            }
            File file2 = new File(string);
            if (!file2.isDirectory()) {
                this._validationMessage = DDLResources.format("INVALID_DEFAULT_DIR", string);
                return 1;
            }
            if (!this.canCreateIn(file2)) {
                this._validationMessage = DDLResources.format("DEFAULT_DIR_NOT_WRITABLE", string);
                return 1;
            }
            String string2 = DDLResources.format("NO_DIR", objectArray);
            boolean bl = MessageDialog.confirm((Component)component, (Object)string2, (String)DDLResources.getString("CONFIRM_DEFAULT_DIR"), null);
            if (!bl) {
                return 2;
            }
            return 0;
        }
        boolean bl = MessageDialog.confirm((Component)component, (Object)DDLResources.format("CREATE_DIRS", objectArray), (String)DDLResources.getString("CONFIRM_CREATE_DIR"), null);
        if (!bl) {
            return 2;
        }
        if (file != null && file.mkdirs()) {
            return this.canCreateInAction(file);
        }
        this._validationMessage = DDLResources.format("INVALID_DIR", objectArray);
        return 1;
    }

    private boolean canCreate(File file) {
        try {
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(1);
            fileOutputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private int canCreateAction(File file) {
        if (this.canCreate(file)) {
            this._validationMessage = null;
            return 0;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", file.getPath());
        return 1;
    }

    private boolean canCreateIn(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile("unload", ".tmp", file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(1);
            fileOutputStream.close();
            file2.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private int canCreateInAction(File file) {
        if (this.canCreateIn(file)) {
            this._validationMessage = null;
            return 0;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", file.getPath());
        return 1;
    }

    public String getDefaultDirectory() {
        String string;
        String string2 = DBConfig.getInstance().getString("EXPORTDIR");
        if (this._preference == 2) {
            string2 = DBConfig.getInstance().getString("DIFFDIR");
        } else if (this._preference == 5) {
            string2 = DBConfig.getInstance().getString("DEPLOYDIR");
            if (string2 == null || string2.trim().equals("")) {
                string2 = DBConfig.getInstance().getString("CARTDIR");
            }
        } else if (this._preference == 3) {
            string2 = DBConfig.getInstance().getString("CARTDIR");
        } else if (this._preference == 4) {
            string2 = DBConfig.getInstance().getString("CARTSCRIPTDIR");
        }
        File file = null;
        if (string2 != null && string2.length() > 0) {
            file = new File(string2);
            if (file.isDirectory()) {
                return file.getPath();
            }
            if (file.isFile()) {
                return file.getParent();
            }
        }
        if ((string = NonUserConfigOptions.get("DEFAULT_EXPORT")) != null && string.length() > 0) {
            file = new File(string);
            if (file.isDirectory()) {
                return file.getPath();
            }
            if (file.isFile()) {
                return file.getParent();
            }
        }
        if ((file = new File(string = System.getProperty("user.home"))).isDirectory()) {
            return file.getPath();
        }
        if (file.isFile()) {
            return file.getParent();
        }
        return "";
    }

    public String getValidationMessage() {
        return this._validationMessage;
    }

    public String[] getEncodings() {
        if (this._encodings == null) {
            this._encodings = Encodings.getEncodings();
        }
        return this._encodings;
    }

    public String getEncoding() {
        return this._encoding == null ? IdeUtil.getIdeEncoding() : this._encoding;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public DefaultMutableTreeNode getSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DDLResources.getString("TARGET_OPTIONS"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryItem(this.getSaveAsTypeString(), OracleIcons.getIcon((String)"filesave.png"), this._saveAs)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("ENCODING", this._encoding)));
        return defaultMutableTreeNode;
    }

    public static String getDisplayName(String string) {
        String string2 = MnemonicUtil.extractLabelTextWithoutMnemonic(DDLResources.getString(string));
        if (string2.endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String getLabelText(String string) {
        return DDLResources.getString(string);
    }

    public JLabel getSummaryNLSItem(String string, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(TargetFormat.getDisplayName(string) + ": " + string2);
        jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
        return jLabel;
    }

    public JLabel getSummaryItem(String string, Icon icon, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(icon);
        return jLabel;
    }

    public JLabel getSummaryItem(String string, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
        return jLabel;
    }

    private void initFormat() {
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._preference == 1) {
            this._saveAsType = dBConfig.getInt("SAVE_AS_TYPE");
            this._saveAs = this.getDefaultSaveAs();
            Boolean bl = dBConfig.getBoolean("EXPORT_OPEN_TGT");
            if (bl != null) {
                this._openTarget = bl;
            }
            this._defaultOpenTarget = this._openTarget;
            bl = dBConfig.getBoolean("EXPORT_GEN_SCRIPT");
            if (bl != null) {
                this._genScript = bl;
            }
            this._encoding = dBConfig.getString("EXPORT_ENCODING");
        } else if (this._preference == 2) {
            this._saveAsType = dBConfig.getInt("DIFF_SAVE_AS_TYPE");
            this._saveAs = this.getDefaultSaveAs();
            Boolean bl = dBConfig.getBoolean("DIFF_OPEN_TGT");
            if (bl != null) {
                this._openTarget = bl;
            }
            this._defaultOpenTarget = this._openTarget;
            bl = dBConfig.getBoolean("DIFF_GEN_SCRIPT");
            if (bl != null) {
                this._genScript = bl;
            }
            this._encoding = dBConfig.getString("DIFF_ENCODING");
        } else if (this._preference == 3) {
            this._saveAsType = 0;
            this._saveAs = this.getDefaultSaveAs();
            this._encoding = dBConfig.getString("CART_ENCODING");
        } else if (this._preference == 4) {
            this._saveAsType = 0;
            this._saveAs = this.getDefaultSaveAs();
            this._encoding = dBConfig.getString("CART__SCRIPT_ENCODING");
        } else if (this._preference == 5) {
            this._saveAsType = dBConfig.getInt("DEPLOY_SAVE_AS_TYPE");
            this._saveAs = this.getDefaultSaveAs();
            Boolean bl = dBConfig.getBoolean("DEPLOY_OPEN_TGT");
            if (bl != null) {
                this._openTarget = bl;
            }
            this._defaultOpenTarget = this._openTarget;
            bl = dBConfig.getBoolean("DEPLOY_GEN_SCRIPT");
            if (bl != null) {
                this._genScript = bl;
            }
            this._encoding = dBConfig.getString("DEPLOY_ENCODING");
        }
    }

    public void saveFormat(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        if (this._preference == 1) {
            dBConfig.putString("EXPORTDIR", this.getSaveAs());
            dBConfig.putBoolean("EXPORT_OPEN_TGT", this.isOpenTarget());
            dBConfig.putBoolean("EXPORT_GEN_SCRIPT", this.isGenScript());
            dBConfig.putString("EXPORT_ENCODING", this.getEncoding());
            dBConfig.putInt("SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 2) {
            dBConfig.putString("DIFFDIR", this.getSaveAs());
            dBConfig.putBoolean("DIFF_OPEN_TGT", this.isOpenTarget());
            dBConfig.putBoolean("DIFF_GEN_SCRIPT", this.isGenScript());
            dBConfig.putString("DIFF_ENCODING", this.getEncoding());
            dBConfig.putInt("DIFF_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 3) {
            dBConfig.putString("CARTDIR", this.getSaveAs());
            dBConfig.putString("CART_ENCODING", this.getEncoding());
            dBConfig.putInt("CART_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 4) {
            dBConfig.putString("CARTSCRIPTDIR", this.getSaveAs());
            dBConfig.putString("CART__SCRIPT_ENCODING", this.getEncoding());
            dBConfig.putInt("CART_SCRIPT_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 5) {
            dBConfig.putString("DEPLOYDIR", this.getSaveAs());
            dBConfig.putBoolean("DEPLOY_OPEN_TGT", this.isOpenTarget());
            dBConfig.putBoolean("DEPLOY_GEN_SCRIPT", this.isGenScript());
            dBConfig.putString("DEPLOY_ENCODING", this.getEncoding());
            dBConfig.putInt("DEPLOY_SAVE_AS_TYPE", this.getSaveAsType());
        }
    }
}

