/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbdiff.editor.DbDiffEditorNode;
import oracle.dbtools.raptor.dbdiff.models.DbDiffObject;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizArb;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

public class DBDiffApi {
    private static final Logger LOGGER = Logger.getLogger(DBDiffApi.class.getName());
    private ExtractListModel _listModel;
    private String sourceConnName;
    private String destConnName;
    private LinkedList<DbDiffObject> _diffList;
    private DDLFormat _ddlFormat = null;
    private DDLTypes _ddlType = null;
    private String _EOL;
    private String badSetup = null;
    private Context context;

    public DBDiffApi(ExtractListModel extractListModel) {
        this._ddlFormat = extractListModel.getDDLFormat();
        this._ddlType = extractListModel.getDDLTypes();
        this.sourceConnName = extractListModel.getSourceConnName();
        this.destConnName = extractListModel.getDestConnName();
        this._listModel = extractListModel;
    }

    public void doDiffWithDialog() {
        final DbDiffTask dbDiffTask = new DbDiffTask();
        dbDiffTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final LinkedList linkedList = (LinkedList)dbDiffTask.getResult();
                    if (linkedList != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DbDiffEditorNode dbDiffEditorNode = new DbDiffEditorNode();
                                dbDiffEditorNode.setDiffObjects(linkedList);
                                DBDiffApi.this.context = Context.newIdeContext((Node)dbDiffEditorNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(DBDiffApi.this.context);
                                openEditorOptions.setFlags(1);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)dbDiffTask);
    }

    public String getSummary() {
        if (!this.checkSetup()) {
            return this.badSetup;
        }
        try {
            return "Summary l8r!";
        }
        catch (Exception exception) {
            return "summary failed: " + exception.getLocalizedMessage();
        }
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this.sourceConnName == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_SOURCE_CONNECTION") + this.getTerm());
            bl = false;
        }
        if (this.destConnName == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_DEST_CONNECTION") + this.getTerm());
            bl = false;
        }
        if (this._ddlFormat == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_FORMAT") + this.getTerm());
            bl = false;
        }
        if (this._ddlType == null) {
            stringBuilder.append(DBDiffWizArb.getString("NO_TYPE") + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    private void setProg(String string, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(string);
        }
    }

    private LinkedList<DbDiffObject> loadDiffList(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        this._listModel.startProcess();
        this._listModel.reconcileDestFromSource();
        this._diffList = new LinkedList();
        ArrayList<ExtractObject> arrayList = this._listModel.getList(0);
        DbDiffObject dbDiffObject = null;
        for (ExtractObject extractObject : arrayList) {
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            this.setProg(extractObject.getDBObject().getObjectName(), iRaptorTaskProgressUpdater);
            dbDiffObject = new DbDiffObject(extractObject, this._listModel.getSourceConnName(), this._listModel.getDestConnName(), this._listModel.getDDLFormat());
            dbDiffObject.initialize();
            this._diffList.add(dbDiffObject);
        }
        return this._diffList;
    }

    private class DbDiffTask
    extends DatabaseQueryTask<LinkedList<DbDiffObject>> {
        public DbDiffTask() {
            super(Messages.getString("DbDiffApi.3"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true, false);
        }

        @Override
        public String getConnectionName() {
            return DBDiffApi.this.sourceConnName;
        }

        @Override
        public String getQuery() {
            return "";
        }

        protected LinkedList<DbDiffObject> doWork() {
            try {
                LinkedList linkedList = DBDiffApi.this.loadDiffList(this.getRaptorTaskProgressUpdater());
                return linkedList;
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (!(throwable instanceof CancellationException)) {
                    LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                return null;
            }
        }
    }
}

