/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCustomCellEditor;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.ide.util.ResourceUtils;

public class TimestampCustomCellEditor
extends BaseCustomCellEditor {
    protected JPanel m_customEditorComponent;
    private DateTimeEditor m_editor = new DateTimeEditor(null);
    private JButton m_todayButton = new JButton();
    private DataType m_dataType;
    private DateFormat dateFormat;

    public TimestampCustomCellEditor() {
        super(new BaseCellEditor());
    }

    @Override
    protected JComponent getCustomEditorComponent() {
        if (null == this.m_customEditorComponent) {
            this.m_customEditorComponent = new JPanel();
            ResourceUtils.resButton((AbstractButton)this.m_todayButton, (String)Messages.getString("DateTimeEditPanel.1"));
            this.m_todayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TimestampCustomCellEditor.this.m_editor.setCalendar(Calendar.getInstance());
                }
            });
            GroupLayout groupLayout = new GroupLayout(this.m_customEditorComponent);
            this.m_customEditorComponent.setLayout(groupLayout);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)((Object)this.m_editor)).addComponent(this.m_todayButton));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent((Component)((Object)this.m_editor)).addComponent(this.m_todayButton));
        }
        return this.m_customEditorComponent;
    }

    @Override
    protected JComponent getCustomEditorFocusComponent() {
        return this.m_editor;
    }

    @Override
    protected Object getCustomEditorValue() {
        Date date = this.m_editor.getDate();
        Timestamp timestamp = date == null ? null : new Timestamp(date.getTime());
        DataValue dataValue = this.m_dataType.getDataValue((Object)timestamp);
        return dataValue.getStringValue();
    }

    @Override
    protected void setCustomEditorValue(Object object) {
        DataValue dataValue = this.m_dataType.getDataValue(object);
        this.m_editor.setDate((Date)dataValue.getTypedValue(ValueType.JAVA));
    }

    @Override
    public void configure(DataType dataType) {
        super.configure(dataType);
        this.m_dataType = dataType;
        this.dateFormat = null;
        this.m_editor.setDateFormat(this.getDateFormat(dataType));
    }

    public DateFormat getDateFormat(DataType dataType) {
        if (null == this.dateFormat) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
        return this.dateFormat;
    }
}

