/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.util.HashMap;
import oracle.dbtools.raptor.data.writers.CharFormattor;
import oracle.dbtools.raptor.data.writers.DateFormattor;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;
import oracle.dbtools.raptor.data.writers.NumberFormattor;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class DataTypeFormatterRegistry {
    private HashMap<String, DataTypeDef> _fmtMap = new HashMap();
    private static DataTypeFormatterRegistry INSTANCE;

    public synchronized void registerFormattor(String string, Class<? extends ITypeFormattor> clazz, boolean bl, boolean bl2, boolean bl3) {
        if (this._fmtMap == null) {
            this._fmtMap = new HashMap();
        }
        DataTypeDef dataTypeDef = new DataTypeDef(clazz, bl, bl2, bl3);
        this._fmtMap.put(string, dataTypeDef);
    }

    public synchronized void unregisterFormattor(String string) {
        if (this._fmtMap != null) {
            this._fmtMap.remove(string);
        }
    }

    public ITypeFormattor getFormattor(String string) {
        if (this._fmtMap != null && string != null) {
            try {
                DataTypeDef dataTypeDef = this._fmtMap.get(string);
                ITypeFormattor iTypeFormattor = dataTypeDef.getHandler().newInstance();
                iTypeFormattor.isPrecisionAllowed(dataTypeDef.isPrecisionAllowed());
                iTypeFormattor.isScaleAllowed(dataTypeDef.isScaleAllowed());
                iTypeFormattor.isScaleImported(dataTypeDef.isScaleImported());
                return iTypeFormattor;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        return null;
    }

    private DataTypeFormatterRegistry() {
        this.registerFormattor("NUMBER", NumberFormattor.class, true, true, true);
        this.registerFormattor("INTEGER", NumberFormattor.class, false, false, false);
        this.registerFormattor("LONG", NumberFormattor.class, false, false, false);
        this.registerFormattor("FLOAT", NumberFormattor.class, false, false, true);
        this.registerFormattor("CHAR", CharFormattor.class, true, false, false);
        this.registerFormattor("NCHAR", CharFormattor.class, true, false, false);
        this.registerFormattor("VARCHAR2", CharFormattor.class, true, false, false);
        this.registerFormattor("NVARCHAR2", CharFormattor.class, true, false, false);
        this.registerFormattor("DATE", DateFormattor.class, false, false, false);
        this.registerFormattor("TIMESTAMP WITH TIME ZONE", DateFormattor.class, true, false, false);
        this.registerFormattor("TIMESTAMP WITH LOCAL TIME ZONE", DateFormattor.class, true, false, false);
        this.registerFormattor("TIMESTAMP", DateFormattor.class, true, false, false);
    }

    public static DataTypeFormatterRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataTypeFormatterRegistry();
        }
        return INSTANCE;
    }

    public class DataTypeDef {
        boolean m_isPrecisionAllowed;
        boolean m_isScaleAllowed;
        boolean m_isScaleImported;
        Class<? extends ITypeFormattor> m_handler;

        public DataTypeDef(Class<? extends ITypeFormattor> clazz, boolean bl, boolean bl2, boolean bl3) {
            this.m_handler = clazz;
            this.m_isPrecisionAllowed = bl;
            this.m_isScaleAllowed = bl2;
            this.m_isScaleImported = bl3;
        }

        Class<? extends ITypeFormattor> getHandler() {
            return this.m_handler;
        }

        public boolean isPrecisionAllowed() {
            return this.m_isPrecisionAllowed;
        }

        public void isPrecisionAllowed(boolean bl) {
            this.m_isPrecisionAllowed = bl;
        }

        public boolean isScaleAllowed() {
            return this.m_isScaleAllowed;
        }

        public void isScaleAllowed(boolean bl) {
            this.m_isScaleAllowed = bl;
        }

        public boolean isScaleImported() {
            return this.m_isScaleImported;
        }

        public void isScaleImported(boolean bl) {
            this.m_isScaleImported = bl;
        }
    }
}

