/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportDiscardFileOraPanel
extends JPanel {
    private JCheckBox _importFileCheckBox;
    private Component m_directoryValue;
    private boolean m_checkBoxControlled;
    private Vector<String> m_dirList;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportDiscardFileOraPanel() {
        this(false, null);
    }

    public ImportDiscardFileOraPanel(boolean bl) {
        this(bl, null);
    }

    public ImportDiscardFileOraPanel(boolean bl, Vector<String> vector) {
        try {
            this.m_checkBoxControlled = bl;
            this.m_dirList = vector;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initFilePanel();
    }

    public JCheckBox getCheckBox() {
        return this._importFileCheckBox;
    }

    public boolean isUseFileEnabled() {
        return this._importFileCheckBox.isSelected();
    }

    void initFilePanel() {
        int n = 0;
        this._importFileCheckBox = new JCheckBox();
        this._importFileCheckBox.setSelected(true);
        this._importFileCheckBox.setText(PreferencesArb.getString("IMPORT_USE_DISCARD"));
        if (this.m_checkBoxControlled) {
            this._importFileCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    ImportDiscardFileOraPanel.this.m_directoryValue.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.add((Component)this._importFileCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.getDirectoryValue(), new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 6, 0), 0, 0));
    }

    protected Component getDirectoryValue() {
        if (this.m_dirList == null) {
            if (this.m_directoryValue == null) {
                this.m_directoryValue = new JTextField("", 20);
                ((JTextField)this.m_directoryValue).setText("");
            }
            return this.m_directoryValue;
        }
        if (this.m_directoryValue == null) {
            this.m_directoryValue = new JComboBox<String>(this.m_dirList);
            ((JComboBox)this.m_directoryValue).setEditable(true);
        }
        return this.m_directoryValue;
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.setOptions(dBConfig);
    }

    private void setOptions(DBConfig dBConfig) {
        if (this.m_dirList == null) {
            ((JTextField)this.m_directoryValue).setText(dBConfig.getString("IMPORT_ORA_DISCARD_DIR"));
        } else {
            ((JComboBox)this.m_directoryValue).setSelectedItem(dBConfig.getString("IMPORT_ORA_DISCARD_DIR"));
        }
        this._importFileCheckBox.setSelected(dBConfig.getBoolean("IMPORT_ORA_USE_DISCARD"));
        if (this.m_checkBoxControlled) {
            this.m_directoryValue.setEnabled(dBConfig.getBoolean("IMPORT_ORA_USE_DISCARD"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_ORA_USE_DISCARD", this._importFileCheckBox.isSelected());
        if (this.m_dirList == null) {
            dBConfig.putString("IMPORT_ORA_DISCARD_DIR", ((JTextField)this.m_directoryValue).getText());
        } else {
            dBConfig.putString("IMPORT_ORA_DISCARD_DIR", (String)((JComboBox)this.m_directoryValue).getSelectedItem());
        }
    }
}

