/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class FileChooserPanel
extends DefaultTraversablePanel {
    private static final String HTMLCONTENT = "text/html";
    private JTextField rejectFieldTextField;
    private JTextField importFileTextField;
    private static final long serialVersionUID = 1800183196612921308L;

    public FileChooserPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 0, 7, 7, 7, 7};
        gridBagLayout.columnWidths = new int[]{0, 7};
        this.setLayout(gridBagLayout);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType(HTMLCONTENT);
        jTextPane.setText(DataImportArb.getString("DATA_FILE_INFO"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add(jTextPane, gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText(DataImportArb.getString("DATA_FILE_IMPORT_LABEL"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.add(jLabel, gridBagConstraints2);
        this.importFileTextField = new JTextField();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridx = 0;
        this.add(this.importFileTextField, gridBagConstraints3);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserPanel.this.importFileTextField.setText(FileChooserPanel.this.getFileName());
            }
        });
        jButton.setText(DataImportArb.getString("DATA_FILE_BROWSE"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridx = 1;
        this.add(jButton, gridBagConstraints4);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DataImportArb.getString("DATA_FILE_REJECT_LABEL"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 3;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints5.anchor = 16;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridx = 0;
        this.add(jLabel2, gridBagConstraints5);
        this.rejectFieldTextField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.ipady = 5;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 4;
        gridBagConstraints6.gridx = 0;
        this.add(this.rejectFieldTextField, gridBagConstraints6);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserPanel.this.rejectFieldTextField.setText(FileChooserPanel.this.getFileName());
            }
        });
        jButton2.setText(DataImportArb.getString("DATA_FILE_BROWSE"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridx = 1;
        this.add(jButton2, gridBagConstraints7);
    }

    private String getFileName() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            String string = uRL.getPath();
            return string;
        }
        return "";
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        FileChooserPanel fileChooserPanel = new FileChooserPanel();
        jDialog.add((Component)((Object)fileChooserPanel));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.get("FILENAME") != null) {
            this.importFileTextField.setText((String)traversableContext.get("FILENAME"));
        }
        if (traversableContext.get("REJECTED_RECORD_FILENAME") != null) {
            this.rejectFieldTextField.setText((String)traversableContext.get("REJECTED_RECORD_FILENAME"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put("FILENAME", (Object)this.importFileTextField.getText());
        try {
            traversableContext.put("FILENAMECANONICAL", (Object)new File(this.importFileTextField.getText()).getCanonicalPath());
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        traversableContext.put("REJECTED_RECORD_FILENAME", (Object)this.rejectFieldTextField.getText());
    }
}

