/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Encodings;

public class EncodingsPanel
extends JPanel {
    private static final long serialVersionUID = 8795596616729365941L;
    private JComboBox encodings;
    private ImportDataFormat dataFormat;
    private String configEncoding = "IMP_ENCODING";

    public EncodingsPanel(ImportDataFormat importDataFormat) {
        this();
        this.dataFormat = importDataFormat;
        Encodings.initComboBox((JComboBox)this.encodings, (boolean)true, (String)importDataFormat.getEncoding());
    }

    public EncodingsPanel(String string) {
        try {
            this.jbInit();
            this.configEncoding = string;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public EncodingsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public JComboBox getEncodingComboBox() {
        return this.encodings;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 1;
        this.initEncoding();
        this.add((Component)this.encodings, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void initEncoding() {
        if (this.encodings == null) {
            this.encodings = new JComboBox();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.dataFormat != null) {
            Encodings.initComboBox((JComboBox)this.encodings, (boolean)true, (String)this.dataFormat.getEncoding());
        } else {
            DBConfig dBConfig = DBConfig.getInstance(traversableContext);
            Encodings.initComboBox((JComboBox)this.encodings, (boolean)true, (String)dBConfig.getString(this.configEncoding));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString(this.configEncoding, (String)this.encodings.getSelectedItem());
    }
}

