/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderEvent;
import oracle.dbtools.raptor.data.readers.DataReaderListener;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.ImportFormatOptionsPanel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;

public class DataPreviewPanel
extends DefaultTraversablePanel
implements DataReaderListener,
CommitListener {
    private static final long serialVersionUID = -5525219439802104748L;
    private String filename;
    private String type;
    private JTable table;
    private DataReadable datareader;
    private ImportFormatOptionsPanel _formatOptions;
    private ImportDataFormat _dataFormat;
    private JPanel _formatPanel;
    private JComboBox _format;
    private int pages;
    boolean existingTable = false;
    private JScrollPane scrollPane;
    private boolean resetData;
    private boolean initUI = false;
    private TraversableContext m_ctx;
    private transient WizardCallbacks m_callbacks;
    private DocumentListener _enclosureRightTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        void enclosureRightChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPanel.this.isValid(string)) {
                DataPreviewPanel.this._dataFormat.setEnclosureRight(string);
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        }
    };
    private DocumentListener _enclosureLeftTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        void enclosureLeftChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPanel.this.isValid(string)) {
                DataPreviewPanel.this._dataFormat.setEnclosureLeft(string);
                String string2 = DataPreviewPanel.this._dataFormat.getEnclosureRightFromLeft(string);
                if (string2 != null) {
                    ((JTextField)DataPreviewPanel.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPanel.this._enclosureRightTextListener);
                    DataPreviewPanel.this._formatOptions.getEnclosuresRightComponent().setSelectedItem(string2);
                    DataPreviewPanel.this._dataFormat.setEnclosureRight(string2);
                    ((JTextField)DataPreviewPanel.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPanel.this._enclosureRightTextListener);
                }
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        }
    };
    private DocumentListener _delimiterTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        void delimiterValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPanel.this.isValid(string)) {
                DataPreviewPanel.this._dataFormat.setDelimiter(string);
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        }
    };
    private DocumentListener _terminatorTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        void terminatorValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPanel.this.isValid(string)) {
                ((JTextField)DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPanel.this._terminatorTextListener);
                DataPreviewPanel.this._dataFormat.setRecordTerminator(string);
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
                ((JTextField)DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPanel.this._terminatorTextListener);
            }
        }
    };
    ItemListener _terminatorItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().removeItemListener(DataPreviewPanel.this._terminatorItemListener);
                ((JTextField)DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPanel.this._terminatorTextListener);
                DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().setSelectedItem(DataPreviewPanel.this._dataFormat.getRecordTerminator());
                DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().addItemListener(DataPreviewPanel.this._terminatorItemListener);
                ((JTextField)DataPreviewPanel.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPanel.this._terminatorTextListener);
            }
        }
    };
    KeyAdapter _keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }
    };
    ChangeListener previewLimitChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
            DataPreviewPanel.this.resetData = true;
        }
    };
    ItemListener _formatListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataPreviewPanel.this._dataFormat.setFormat((String)DataPreviewPanel.this._format.getSelectedItem());
                DataPreviewPanel.this._format.removeItemListener(DataPreviewPanel.this._formatListener);
                DataPreviewPanel.this._formatPanel.removeAll();
                DataPreviewPanel.this._formatOptions.setOptions(DataPreviewPanel.this._dataFormat.getOptions());
                DataPreviewPanel.this._formatPanel = DataPreviewPanel.this._formatOptions.getFormatPanel();
                DataPreviewPanel.this._format = DataPreviewPanel.this._formatOptions.getFormatComponent();
                DataPreviewPanel.this._format.addItemListener(DataPreviewPanel.this._formatListener);
                DataPreviewPanel.this._formatPanel.revalidate();
                DataPreviewPanel.this._formatPanel.repaint();
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        }
    };

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.add(this._formatPanel, "North");
        this.scrollPane = new JScrollPane(22, 32);
        this.add(this.scrollPane, "Center");
        this.table = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table.setAutoResizeMode(0);
        this.scrollPane.setViewportView(this.table);
    }

    private void addListeners() {
        if (this._formatOptions.getEncodingsComponent() != null) {
            this._formatOptions.getEncodingsComponent().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string;
                    if (itemEvent.getStateChange() == 1 && !(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()).equals(DataPreviewPanel.this._dataFormat.getEncoding())) {
                        DataPreviewPanel.this._dataFormat.setEncoding(string);
                        DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                        DataPreviewPanel.this.resetData = true;
                    }
                }
            });
        }
        this._formatOptions.getHeaderComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPanel.this._dataFormat.isHeader(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        });
        this._formatOptions.getUsePreviewLimitComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPanel.this._dataFormat.setUsePreviewLimit(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        });
        this._formatOptions.getPreviewLimitComponent().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DataPreviewPanel.this._dataFormat.setPreviewLimit(((NumericSpinBox)changeEvent.getSource()).getIntValue());
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        });
        this._formatOptions.getSkipRowsComponent().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DataPreviewPanel.this._dataFormat.setSkipRows(((NumericSpinBox)changeEvent.getSource()).getIntValue());
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                DataPreviewPanel.this.resetData = true;
            }
        });
        if (this._dataFormat.isHeaderLocationSupported()) {
            this._formatOptions.getHeaderLocationComponent().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataPreviewPanel.this._dataFormat.setHeaderLocation(((JComboBox)actionEvent.getSource()).getSelectedIndex());
                    DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                    DataPreviewPanel.this.resetData = true;
                }
            });
        }
        this._format = this._formatOptions.getFormatComponent();
        if (this._format != null) {
            this._format.addItemListener(this._formatListener);
        }
        if (!this._dataFormat.isExcel() && !this._dataFormat.isExcelX()) {
            this._formatOptions.getDelimiterComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._delimiterTextListener);
            this._formatOptions.getEnclosuresLeftComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresLeftComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureLeftTextListener);
            this._formatOptions.getEnclosuresRightComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureRightTextListener);
            this._formatOptions.getRecordTerminatorComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._terminatorTextListener);
            this._formatOptions.getRecordTerminatorComponent().addItemListener(this._terminatorItemListener);
        } else if (this.pages > 1) {
            this._formatOptions.getWorksheetComponent().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                    DataPreviewPanel.this._dataFormat.setPageId(n);
                    DataPreviewPanel.this.datareader.setPage(n);
                    DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                    DataPreviewPanel.this.resetData = true;
                }
            });
        }
    }

    public DataReadable getDataReader() {
        return this.datareader;
    }

    public void setDataReader(DataReadable dataReadable) {
        this.datareader = dataReadable;
        this.pages = dataReadable.getNosPages();
        String string = this._dataFormat.getRecordTerminator();
        this.populateDataTable(this.datareader);
        if (dataReadable.isLineTerminatorSupported() && string.equals(this._dataFormat.getRecordTerminator()) && this._formatOptions.getRecordTerminatorComponent() != null) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(this._dataFormat.getRecordTerminator());
        }
        this.validate();
        this.resetData = true;
    }

    private void populateDataTable(DataReadable dataReadable) {
        this.datareader.refreshPreview(true);
        dataReadable.setDataFormat(this._dataFormat);
        String string = this._dataFormat.getRecordTerminator();
        TableModel tableModel = dataReadable.getTableModel();
        if (dataReadable.isLineTerminatorSupported() && !this._dataFormat.getRecordTerminator().equals(string)) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(dataReadable.getLineTerminator());
        }
        this.table.setModel(tableModel);
    }

    public static void main(String[] stringArray) {
        DataReadable dataReadable = DataReaderRegistry.getReader("CSV");
        dataReadable.setFileName("d:\\code\\test.csv");
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        DataPreviewPanel dataPreviewPanel = new DataPreviewPanel();
        dataPreviewPanel.setDataReader(dataReadable);
        dataReadable.addListener(dataPreviewPanel);
        jDialog.add((Component)((Object)dataPreviewPanel), "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    @Override
    public void raiseEvent(DataReaderEvent dataReaderEvent) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object;
        traversableContext.put("DATA_FORMAT", (Object)this._dataFormat);
        if (this._dataFormat.getUsePreviewLimit()) {
            object = this._dataFormat.getPreviewLimit();
            traversableContext.put("PREVIEW_LIMIT", (Object)((Integer)object).toString());
        }
        traversableContext.put("FILENAME", (Object)this.filename);
        try {
            traversableContext.put("FILENAMECANONICAL", (Object)new File(this.filename).getCanonicalPath());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        traversableContext.put("IMPORT_TYPE", (Object)this.type);
        traversableContext.put("PAGEID", (Object)this._dataFormat.getPageId());
        traversableContext.put("LOCALE", (Object)Locale.getDefault());
        object = this.table.getTableHeader().getColumnModel();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < object.getColumnCount(); ++i) {
            Column column = new Column();
            column.setSourceColumnName(object.getColumn(i).getHeaderValue().toString());
            column.setName(column.getSourceColumnName());
            column.setSourceColID(this.getSourceID(column.getSourceColumnName()));
            column.setPrecision(this.datareader.getWidth(i));
            column.setScale(0);
            column.setNullable(true);
            arrayList.add(i, column);
        }
        traversableContext.put("DATA_COLUMNS", (Object)arrayList.toArray(new Column[arrayList.size()]));
        if (traversableContext.get("SELECTABLE_COLUMNS") == null) {
            traversableContext.put("SELECTED_COLUMNS", traversableContext.get("DATA_COLUMNS"));
            traversableContext.put("SELECTABLE_COLUMNS", (Object)new Column[0]);
        }
        if (this.resetData) {
            traversableContext.put("SELECTED_COLUMNS", traversableContext.get("DATA_COLUMNS"));
            traversableContext.put("SELECTABLE_COLUMNS", (Object)new Column[0]);
        }
        if (this.datareader != null) {
            this.datareader.closeFile();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        if (!this.initUI) {
            DBObject dBObject;
            Object object;
            this.initUI = true;
            this.filename = (String)traversableContext.get("FILENAME");
            if (this.filename != null) {
                this.type = this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1);
                this.datareader = DataReaderRegistry.getReader(this.type);
                this.datareader.setFileName(this.filename);
                if (traversableContext.get("PAGEID") != null) {
                    this.datareader.setPage((Integer)traversableContext.get("PAGEID"));
                }
                this._formatOptions = new ImportFormatOptionsPanel(BaseDataFormat.IMPORT_WIZARD, this.datareader.getFormat());
                this._formatOptions.setDataReader(this.datareader);
                this._formatPanel = this._formatOptions.getFormatPanel();
                this._dataFormat = (ImportDataFormat)this._formatOptions.getProperties();
                this.datareader.setDataFormat(this._dataFormat);
                this.pages = this.datareader.getNosPages();
                this.initUI();
                this.setDataReader(this.datareader);
                this.addListeners();
            }
            if ((object = this.m_ctx.get("DBOBJECT")) != null && object instanceof DBObject && (dBObject = (DBObject)object).getObjectType().equals("TABLE")) {
                this.existingTable = true;
            }
        }
        this.validate();
        this.resetData = false;
        this.m_callbacks = traversableContext.getWizardCallbacks();
        this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private int getSourceID(String string) {
        int n = -1;
        String[] stringArray = this.getDataReader().getColumnNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    boolean isValid(String string) {
        if (string.length() == 1 && (string.equals("X") || string.equals("x")) || string.length() > 1 && (string.substring(0, 2).equals("X'") || string.substring(0, 2).equals("x'"))) {
            return string.length() > 3 && string.endsWith("'");
        }
        return string.length() != 0;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        if (this.datareader != null) {
            this.datareader.closeFile();
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        if (this.datareader != null) {
            this.datareader.closeFile();
        }
    }
}

