/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.listtable;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.controls.listtable.ListTablePanel;
import oracle.dbtools.raptor.images.RaptorImagesArb;

public class ListTableShuttlePanel<T>
extends ListTablePanel<T> {
    private static final long serialVersionUID = 1L;
    private boolean _isHorizontal = false;
    private JButton _addBtn;
    private JButton _addAllBtn;
    private JButton _removeBtn;
    private JButton _removeAllBtn;

    public ListTableShuttlePanel(ListTableModel<T> listTableModel, boolean bl) {
        super(listTableModel);
        this._isHorizontal = bl;
    }

    @Override
    protected void initTablePanel() {
        this._addBtn = new JButton();
        this._addAllBtn = new JButton();
        this._removeBtn = new JButton();
        this._removeAllBtn = new JButton();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        if (this._isHorizontal) {
            this.layoutHorizontal(groupLayout);
        } else {
            this.layoutVertical(groupLayout);
        }
        this.initializeListeners();
    }

    private void layoutHorizontal(GroupLayout groupLayout) {
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this._addBtn).addComponent(this._addAllBtn).addComponent(this._removeBtn).addComponent(this._removeAllBtn)).addComponent(this.getTableScrollPane(), -2, -2, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._addBtn).addComponent(this._addAllBtn).addComponent(this._removeBtn).addComponent(this._removeAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addComponent(this.getTableScrollPane()));
    }

    private void layoutVertical(GroupLayout groupLayout) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(this._addBtn);
        jPanel.add(this._addAllBtn);
        jPanel.add(this._removeBtn);
        jPanel.add(this._removeAllBtn);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "North");
        this.add((Component)this.getTableScrollPane(), "Center");
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        Icon icon = RaptorImagesArb.getIcon(this._isHorizontal ? "LAST_ENA" : "SHUTTLE_DOWN");
        AbstractAction abstractAction = this.getListTableModel().getAddAfterSelectedAction(icon);
        this._addBtn.setAction(abstractAction);
        this._addBtn.setName("ListTable.Add");
        this._actions.add(abstractAction);
        icon = RaptorImagesArb.getIcon(this._isHorizontal ? "LAST_ENA" : "SHUTTLE_DOWN_ALL");
        abstractAction = this.getListTableModel().getAddAllAfterSelectedAction(icon);
        this._addAllBtn.setAction(abstractAction);
        this._addAllBtn.setName("ListTable.AddAll");
        this._actions.add(abstractAction);
        icon = RaptorImagesArb.getIcon(this._isHorizontal ? "FIRST_ENA" : "SHUTTLE_UP");
        abstractAction = this.getListTableModel().getRemoveSelectedAction(icon);
        this._removeBtn.setAction(abstractAction);
        this._removeBtn.setName("ListTable.Remove");
        this._actions.add(abstractAction);
        icon = RaptorImagesArb.getIcon(this._isHorizontal ? "PREV_ENA" : "SHUTTLE_UP_ALL");
        abstractAction = this.getListTableModel().getRemoveAllAction(icon);
        this._removeAllBtn.setAction(abstractAction);
        this._removeAllBtn.setName("ListTable.RemoveAll");
        this._actions.add(abstractAction);
    }
}

