/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.cellrenderers.CellRenderingFactory;
import oracle.dbtools.raptor.controls.cellrenderers.ICellRenderer;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.query.Column;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ResultSetTableCellRenderer
extends DefaultTableCellRenderer {
    private static Preferences prefs = Preferences.getPreferences();
    private static FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)prefs);

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        Component component;
        Object object4;
        ResultSetTableModel resultSetTableModel;
        block43: {
            resultSetTableModel = null;
            ResultSetTable resultSetTable = null;
            object4 = object;
            if (jTable instanceof ResultSetTable) {
                resultSetTable = (ResultSetTable)((Object)jTable);
                resultSetTableModel = resultSetTable.getGridModel();
            }
            Column column = null;
            component = null;
            if (resultSetTableModel != null && (column = resultSetTableModel.getQueryColumn(n, n2)) != null && column.getCellRenderer() != null) {
                try {
                    object3 = Class.forName(column.getCellRenderer()).newInstance();
                    if (object3 instanceof DefaultTableCellRenderer) {
                        component = ((DefaultTableCellRenderer)object3).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        break block43;
                    }
                    if (object3 instanceof ICellRenderer) {
                        component = ((ICellRenderer)object3).getComponent(jTable, object, bl, bl2, n, n2);
                        if (component == null) {
                            object4 = ((ICellRenderer)object3).getText(jTable, object, bl, bl2, n, n2);
                        }
                        break block43;
                    }
                    RuntimeException runtimeException = new RuntimeException("Must be a DefaultTableCellRenderer or ICellRenderer");
                    Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellRendererComponent", runtimeException);
                    throw runtimeException;
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                }
            }
        }
        if (jTable.getModel() instanceof EditableResultSetTableModel && component instanceof JComponent) {
            object3 = (EditableResultSetTableModel)((Object)jTable.getModel());
            if (((EditableResultSetTableModel)object3).isRowDeleted(n)) {
                ((JComponent)component).setBorder(BorderFactory.createEtchedBorder(Color.RED, Color.BLACK));
            } else if (object3.isNewRow(n)) {
                ((JComponent)component).setBorder(BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK));
            }
        }
        if (component != null) {
            return component;
        }
        object3 = CellRenderingFactory.getComponent(jTable, object4, bl, bl2, n, n2);
        if (object3 != null) {
            return object3;
        }
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object4, bl, bl2, n, n2);
        Color color = null;
        try {
            if (jTable instanceof ResultSetTable && resultSetTableModel != null) {
                object2 = DBConfig.getInstance();
                String string = object2.getString("NULLCOLOR");
                if (string == null) {
                    object2.putString("NULLCOLOR", "NONE");
                }
                int n3 = resultSetTableModel.getColumnSqlType(jTable.convertColumnIndexToModel(n2));
                this.alignJLabel(jLabel, n3);
                if (object4 == null) {
                    if (string.equals("BLUE")) {
                        color = Color.BLUE;
                    } else if (string.equals("GRAY")) {
                        color = Color.GRAY;
                    } else if (string.equals("LIGHT_GRAY")) {
                        color = Color.LIGHT_GRAY;
                    } else if (string.equals("BLACK")) {
                        color = Color.BLACK;
                    } else if (string.equals("RED")) {
                        color = Color.RED;
                    } else if (string.equals("PINK")) {
                        color = Color.PINK;
                    } else if (string.equals("ORANGE")) {
                        color = Color.ORANGE;
                    } else if (string.equals("YELLOW")) {
                        color = Color.YELLOW;
                    } else if (string.equals("GREEN")) {
                        color = Color.GREEN;
                    }
                    if (color != null) {
                        jLabel.setBackground(color);
                    }
                    jLabel.setText(object2.getString("NULLDISPLAY"));
                } else {
                    String string2 = CellRenderingFactory.getText(jTable, object4, bl, bl2, n, n2);
                    String string3 = null;
                    string3 = string2 != null ? string2 : resultSetTableModel.getDisplayValueAt(jTable.convertRowIndexToModel(n), jTable.convertColumnIndexToModel(n2), jTable.getColumn(jTable.getColumnName(n2)).getWidth());
                    this.setText(string3 == null ? "" : string3);
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
        }
        if (bl) {
            jLabel.setBackground(UIManager.getColor("textHighlight"));
        } else if (color == null) {
            jLabel.setBackground(UIManager.getColor("text"));
        }
        if (fontSizeOptions != null) {
            object2 = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
            jLabel.setFont((Font)object2);
        }
        return jLabel;
    }

    private void alignJLabel(JLabel jLabel, int n) {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                jLabel.setHorizontalAlignment(4);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                jLabel.setAlignmentX(0.0f);
                break;
            }
            default: {
                jLabel.setAlignmentX(0.0f);
            }
        }
    }
}

