/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.GraphContextMenuListener;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.ViewMouseEvent;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.MarkerText;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

public class DisplaySimpleChart
extends DisplayAdapter
implements ISelectionChangeListener {
    private Graph _graph;
    private static ContextMenu _graphCM = new ContextMenu();
    private JScrollPane _spSql;
    private Boolean _show;
    private DisplaySimpleChart _instance;
    private String[] colNames = new String[3];
    private static GraphContextMenuListener _menu = GraphContextMenuListener.getInstance();

    public Boolean getBoolean(String string) {
        try {
            String string2 = this.getExtVales().get(string);
            if (string2.equals("true")) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getStyle() {
        String string = null;
        String string2 = this.getExtVales().get("STYLE");
        if (string2 == null) {
            return null;
        }
        String string3 = string2.toUpperCase().replace(" ", "_");
        try {
            string = DisplayConstants.CHART_STYLES.valueOf(string3).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void init() {
        if (this._graph == null) {
            if (this._instance == null) {
                this._instance = this;
            }
            this._graph = new Graph();
            this._graph.addViewMouseListener(new ViewMouseListener(){

                public void mouseClicked(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseEntered(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseExited(ViewMouseEvent viewMouseEvent) {
                }

                public void mousePressed(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseReleased(ViewMouseEvent viewMouseEvent) {
                    ComponentHandle componentHandle = DisplaySimpleChart.this._graph.getSelectedObject();
                    if (componentHandle instanceof DataComponentHandle) {
                        DisplaySimpleChart.this.setDirty(false);
                        DisplaySimpleChart.this.fireSelectionChanged();
                    }
                }
            });
            this._graph.addMouseListener((MouseListener)new MouseAdapter(){
                private Context _context = new Context();

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if (((n & 8) != 0 || (n & 4) != 0) && mouseEvent.getSource() == DisplaySimpleChart.this._graph.getThickPFJ()) {
                        this._context.setEvent((EventObject)mouseEvent);
                        _graphCM.show(this._context);
                    }
                }
            });
            this._graph.setVisible(false);
            try {
                if (this.getStyle() != null) {
                    this._graph.setStylePath(this.getStyle());
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this._graph.getLegendArea().setVisible(this.getBoolean("LEGEND").booleanValue());
            int n = this.getBoolean("GRID") != false ? 0 : 6;
            this._graph.getX1MajorTick().setTickStyle(n);
            this._graph.getY1MajorTick().setTickStyle(n);
            this._graph.getY2MajorTick().setTickStyle(n);
            this._graph.set3DEffect(this.getBoolean("THREED").booleanValue());
            String string = this.getExtVales().get("TYPE");
            if (string.equals("PIE_MULTI")) {
                this._graph.setGraphType(57);
            } else if (string.equals("BAR_HORIZ_CLUST")) {
                this._graph.setGraphType(24);
            } else if (string.equals("BAR_VERT_CLUST")) {
                this._graph.setGraphType(17);
            } else if (string.equals("BAR_VERT_STACK")) {
                this._graph.setGraphType(18);
            } else if (string.equals("BAR_HORIZ_STACK")) {
                this._graph.setGraphType(25);
            }
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            this._graph.setLocale(locale);
            this._graph.setCustomToolTipCallback((CustomToolTipCallback)new MyCustomToolTipCallback());
            this._spSql = new JScrollPane((Component)this._graph, 22, 32);
            this._spSql.setPreferredSize(new Dimension(400, 400));
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    @Override
    public void refresh(boolean bl) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("ResultSetTableModel.8"), true, IRaptorTaskRunMode.MODAL){
            private PreparedStatement pstmt;
            private boolean _cancelled;
            {
                this._cancelled = false;
            }

            public boolean cancel() {
                this._cancelled = true;
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                MarkerText markerText = DisplaySimpleChart.this._graph.getMarkerText();
                markerText.getViewFormat(0).setDecimalDigit(2);
                markerText.getViewFormat(1).setDecimalDigit(2);
                markerText.getViewFormat(2).setDecimalDigit(2);
                markerText.getViewFormat(3).setDecimalDigit(2);
                markerText.getViewFormat(4).setDecimalDigit(2);
                ResultSet resultSet = null;
                DisplaySimpleChart.this._show = false;
                Connection connection = DisplaySimpleChart.this.getConnection();
                if (connection == null) {
                    return null;
                }
                try {
                    if (DisplaySimpleChart.this.getQuery().getSql() == null || DisplaySimpleChart.this.getQuery().getSql().equals("")) {
                        DisplaySimpleChart.this._graph.setVisible(false);
                        Void void_ = null;
                        return void_;
                    }
                    Connections.getInstance().lock(connection);
                    this.pstmt = connection.prepareStatement(DisplaySimpleChart.this.getQuery().getSql());
                    DBUtil.bind((String)DisplaySimpleChart.this.getQuery().getSql(), (PreparedStatement)this.pstmt, DisplaySimpleChart.this.getBindMap());
                    resultSet = this.pstmt.executeQuery();
                    Object[] objectArray = null;
                    final ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    ((DisplaySimpleChart)DisplaySimpleChart.this).colNames[0] = resultSet.getMetaData().getColumnName(1);
                    ((DisplaySimpleChart)DisplaySimpleChart.this).colNames[1] = resultSet.getMetaData().getColumnName(2);
                    ((DisplaySimpleChart)DisplaySimpleChart.this).colNames[2] = resultSet.getMetaData().getColumnName(3);
                    while (!this._cancelled && resultSet.next()) {
                        objectArray = new Object[resultSet.getMetaData().getColumnCount()];
                        for (int i = 1; i < resultSet.getMetaData().getColumnCount() + 1; ++i) {
                            objectArray[i - 1] = i > 2 ? resultSet.getBigDecimal(i) : resultSet.getString(i);
                        }
                        arrayList.add(objectArray);
                    }
                    if (this._cancelled) {
                        arrayList.clear();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DisplaySimpleChart.this._graph.setVisible(false);
                            if (arrayList.size() > 0) {
                                DisplaySimpleChart.this._graph.setDataRowShownAsASeries(true);
                            }
                            DisplaySimpleChart.this._show = DisplaySimpleChart.this._graph.setTabularData((List)arrayList);
                            if (DisplaySimpleChart.this._show.booleanValue()) {
                                DisplaySimpleChart.this._graph.getO1TickLabel().setHorizontalAlignment(0);
                            }
                            DisplaySimpleChart.this._graph.setVisible(true);
                        }
                    });
                }
                catch (Exception exception) {
                    if (!this._cancelled) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                finally {
                    try {
                        if (this.pstmt != null) {
                            this.pstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    Connections.getInstance().unlock(connection);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public Map<String, Object> getBinds(Point point) {
        return this.getBindMap();
    }

    public Map<String, Object> getBinds() {
        return this.getBindMap();
    }

    @Override
    public Map<String, Object> getBindMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        try {
            map = super.getBindMap();
            hashMap.putAll(map);
            if (this._graph.getSelectedObject() != null) {
                int n = ((DataComponentHandle)this._graph.getSelectedObject()).getColumn();
                int n2 = ((DataComponentHandle)this._graph.getSelectedObject()).getRow();
                int n3 = ((DataComponentHandle)this._graph.getSelectedObject()).getSeries();
                int n4 = ((DataComponentHandle)this._graph.getSelectedObject()).getGroup();
                LocalXMLDataSource localXMLDataSource = (LocalXMLDataSource)this._graph.getDataSource();
                Object object = localXMLDataSource.getSliceLabel(0, n4, "label");
                Object object2 = localXMLDataSource.getSliceLabel(1, n3, "label");
                Object object3 = localXMLDataSource.getValue(n2, n, "dataValue");
                hashMap.put(this.colNames[0], object);
                hashMap.put(this.colNames[1], object2);
                hashMap.put(this.colNames[2], object3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    @Override
    public void addActions(List<ObjectAction> list) {
        _menu.setDisplay(this);
        _menu.setActions(list);
        _graphCM.addContextMenuListener((ContextMenuListener)_menu);
    }

    @Override
    public void clear() {
        this._graph.setVisible(false);
    }

    @Override
    public void parentSelectionChanged() {
        this.refresh(true);
    }

    @Override
    public void close() {
        _graphCM.removeContextMenuListener((ContextMenuListener)_menu);
        super.close();
    }

    private class MyCustomToolTipCallback
    implements CustomToolTipCallback {
        private MyCustomToolTipCallback() {
        }

        public String getToolTipText(String string, ComponentHandle componentHandle) {
            String string2 = string;
            if (string2 != null) {
                string2 = string2.replace("Group:", "Group (" + DisplaySimpleChart.this.colNames[0] + "):");
                string2 = string2.replace("Series:", "Series (" + DisplaySimpleChart.this.colNames[1] + "):");
                string2 = string2.replace("Value:", "Value (" + DisplaySimpleChart.this.colNames[2] + "):");
            }
            return string2;
        }
    }
}

