/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.ide.util.ResourceUtils;

public class DisplayChartDetails
extends JPanel
implements IDisplayDetail {
    private JComboBox _type;
    private JComboBox _style;
    private JCheckBox _3d;
    private JCheckBox _gradient;
    private JCheckBox _grid;
    private JCheckBox _legend;

    public DisplayChartDetails() {
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var4_18;
        void var4_17;
        void var4_15;
        void var4_14;
        void var4_12;
        this.setLayout(new GridBagLayout());
        this._3d = new JCheckBox();
        this._gradient = new JCheckBox();
        this._grid = new JCheckBox();
        this._legend = new JCheckBox();
        this._3d.setSelected(true);
        this._gradient.setSelected(true);
        this._grid.setSelected(true);
        this._legend.setSelected(true);
        this._type = new JComboBox();
        for (DisplayConstants.CHART_TYPES cHART_TYPES : DisplayConstants.CHART_TYPES.values()) {
            this._type.addItem(cHART_TYPES.getNLSName());
        }
        this._type.setSelectedIndex(DisplayConstants.CHART_TYPES.BAR_VERT_STACK.ordinal());
        this._style = new JComboBox();
        for (DisplayConstants.CHART_STYLES cHART_STYLES : DisplayConstants.CHART_STYLES.values()) {
            this._style.addItem(cHART_STYLES.getNLSName());
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._type, (String)Messages.getString("DisplayChartDetails.0"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._style, (String)Messages.getString("DisplayChartDetails.12"));
        ResourceUtils.resButton((AbstractButton)this._3d, (String)Messages.getString("DisplayChartDetails.6"));
        ResourceUtils.resButton((AbstractButton)this._gradient, (String)Messages.getString("DisplayChartDetails.9"));
        ResourceUtils.resButton((AbstractButton)this._grid, (String)Messages.getString("DisplayChartDetails.15"));
        ResourceUtils.resButton((AbstractButton)this._legend, (String)Messages.getString("DisplayChartDetails.18"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._type, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, (int)(++var4_12), 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._style, new GridBagConstraints(1, (int)var4_12, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = 0;
        jPanel2.add((Component)this._3d, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this._grid, new GridBagConstraints(0, (int)(++var4_14), 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this._legend, new GridBagConstraints(0, (int)(++var4_15), 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)Messages.getString("DisplayChartDetails.20"));
        int n3 = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, (int)(++var4_17), 1, 1, 0.0, 0.0, 23, 0, new Insets(25, 10, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, (int)(++var4_18), 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this._type.getSelectedIndex();
        DisplayConstants.CHART_TYPES cHART_TYPES = DisplayConstants.CHART_TYPES.values()[n];
        hashMap.put("TYPE", cHART_TYPES.getType());
        hashMap.put("THREED", Boolean.toString(this._3d.isSelected()));
        hashMap.put("GRADIENT", Boolean.toString(this._gradient.isSelected()));
        n = this._style.getSelectedIndex();
        DisplayConstants.CHART_STYLES cHART_STYLES = DisplayConstants.CHART_STYLES.values()[n];
        hashMap.put("STYLE", cHART_STYLES.getType());
        hashMap.put("LEGEND", Boolean.toString(this._legend.isSelected()));
        hashMap.put("GRID", Boolean.toString(this._grid.isSelected()));
        return hashMap;
    }

    @Override
    public void setValues(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        String string = null;
        String string2 = map.get("TYPE");
        if (string2 != null && !string2.isEmpty()) {
            try {
                string = DisplayConstants.CHART_TYPES.valueOf(string2).getNLSName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = DisplayConstants.CHART_TYPES.BAR_VERT_STACK.getNLSName();
        }
        this._type.setSelectedItem(string);
        string = null;
        String string3 = map.get("STYLE");
        if (string3 != null && !string3.isEmpty()) {
            string3 = string3.toUpperCase().replace(" ", "_");
            try {
                string = DisplayConstants.CHART_STYLES.valueOf(string3).getNLSName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = DisplayConstants.CHART_STYLES.DEFAULT.getNLSName();
        }
        this._style.setSelectedItem(string);
        this._3d.setSelected(Boolean.parseBoolean(map.get("THREED")));
        this._gradient.setSelected(Boolean.parseBoolean(map.get("GRADIENT")));
        this._legend.setSelected(Boolean.parseBoolean(map.get("LEGEND")));
        this._grid.setSelected(Boolean.parseBoolean(map.get("GRID")));
    }
}

