/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;
import oracle.sql.Datum;

public abstract class DisplayAdapter
implements IDisplay {
    protected Query _query;
    protected String _connName;
    protected JScrollPane _sp;
    private Map<String, Object> _bindMap;
    protected boolean _dirty = false;
    private Map<String, String> _extVales;
    private ArrayList<ISelectionChangeListener> _listeners = null;
    private String _type;
    private String _id;
    protected IRaptorTaskListener _taskListener;
    private DisplayModel _displayModel;
    private Toolbar _toolbar;
    protected View _view;
    private long lastScrollTimestamp;
    private int scrollPageSz;

    @Override
    public void setId(String string) {
        this._id = string;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addSelectionChangeListener(ISelectionChangeListener iSelectionChangeListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(iSelectionChangeListener);
    }

    public void fireSelectionChanged() {
        if (this._listeners != null) {
            for (ISelectionChangeListener iSelectionChangeListener : this._listeners) {
                iSelectionChangeListener.parentSelectionChanged();
            }
        }
    }

    @Override
    public Map<String, String> getExtVales() {
        return this._extVales;
    }

    @Override
    public void setExtVales(Map<String, String> map) {
        this._extVales = map;
    }

    @Override
    public JComponent getScrollableUI() {
        if (this._sp == null) {
            JComponent jComponent = this.getUI();
            this._sp = new JScrollPane(jComponent);
            this.scrollPageSz = this._sp.getVerticalScrollBar().getBlockIncrement();
            this.addMouseMoveListener(jComponent);
            this.addPageListener(jComponent);
        }
        return this._sp;
    }

    @Override
    public void replaceBindMap(Map<String, Object> map) {
        this._bindMap = map;
        this._dirty = true;
    }

    @Override
    public void appendBindMap(Map<String, Object> map) {
        if (map != null) {
            if (this._bindMap == null) {
                this._bindMap = new HashMap<String, Object>();
            }
            for (String string : map.keySet()) {
                if (this._bindMap != null && ModelUtil.areEqual((Object)this._bindMap.get(string), (Object)map.get(string))) continue;
                this._dirty = true;
                this._bindMap.putAll(map);
            }
        }
    }

    @Override
    public Map<String, Object> getBindMap() {
        HashMap hashMap = this._query.getBindValues();
        if (this._bindMap != null) {
            hashMap.putAll(this._bindMap);
        }
        return hashMap;
    }

    public Map<String, Bind> getFullValueBindMap() {
        Map<String, Object> map = this.getBindMap();
        HashMap<String, Bind> hashMap = new HashMap<String, Bind>();
        Set<String> set = map.keySet();
        for (String string : set) {
            Object object = map.get(string);
            String string2 = null;
            String string3 = null;
            if (object instanceof Datum) {
                string2 = this.getStringFromOracleDatum((Datum)object);
                string3 = this.getTypeFromOracleDatum((Datum)object);
            } else if (object instanceof BigDecimal) {
                string2 = Double.toString(((BigDecimal)object).doubleValue());
                string3 = "CHAR";
            } else {
                if (object != null) {
                    string2 = object.toString();
                }
                string3 = "CHAR";
            }
            Bind bind = new Bind(string, string3, null, string2, null);
            hashMap.put(string, bind);
        }
        return hashMap;
    }

    private String getStringFromOracleDatum(Datum datum) {
        String string = null;
        try {
            string = datum.stringValue();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    private String getTypeFromOracleDatum(Datum datum) {
        String string = null;
        string = datum.getClass().toString();
        string = string.substring(string.lastIndexOf(".") + 1).toUpperCase();
        return string;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    @Override
    public void populateToolBar(Toolbar toolbar) {
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public void setConn(Connection connection) {
        if (!ModelUtil.areEqual((Object)this.getConnection(), (Object)connection)) {
            this._connName = Connections.getInstance().getConnectionName(connection);
            this._dirty = true;
        }
    }

    @Override
    public void setConnName(String string) {
        if (!ModelUtil.areEqual((Object)this._connName, (Object)string)) {
            this._connName = string;
            this._dirty = true;
        }
    }

    public String getConnName() {
        return this._connName;
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            if (this._connName != null) {
                connection = Connections.getInstance().getConnection(this._connName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    @Override
    public Map<String, Object> getBinds(Point point) {
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public void close() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
            this._toolbar.removeAll();
        }
    }

    @Override
    public void setType(String string) {
        this._type = string;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public BasicEditorPane getCodeEditor() {
        return null;
    }

    @Override
    public void addTaskListener(IRaptorTaskListener iRaptorTaskListener) {
        this._taskListener = iRaptorTaskListener;
    }

    @Override
    public void removeTaskListener(IRaptorTaskListener iRaptorTaskListener) {
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public void setDisplayModel(DisplayModel displayModel) {
        this._displayModel = displayModel;
    }

    @Override
    public DisplayModel getDisplayModel() {
        return this._displayModel;
    }

    @Override
    public void setToolbar(Toolbar toolbar) {
        this._toolbar = toolbar;
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public void setView(View view) {
        this._view = view;
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Component getScrollableLeftMargin() {
        return null;
    }

    protected void addMouseMoveListener(Component component) {
        component.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWhen() > DisplayAdapter.this.lastScrollTimestamp) {
                    DisplayAdapter.this.scroll(mouseWheelEvent.getUnitsToScroll());
                    DisplayAdapter.this.lastScrollTimestamp = mouseWheelEvent.getWhen();
                }
            }
        });
    }

    protected void addPageListener(Component component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getWhen() > DisplayAdapter.this.lastScrollTimestamp) {
                    switch (keyEvent.getKeyCode()) {
                        case 33: {
                            DisplayAdapter.this.scroll(-DisplayAdapter.this.scrollPageSz);
                            break;
                        }
                        case 34: {
                            DisplayAdapter.this.scroll(DisplayAdapter.this.scrollPageSz);
                            break;
                        }
                    }
                    DisplayAdapter.this.lastScrollTimestamp = keyEvent.getWhen();
                }
            }
        });
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.addPageListener(container.getComponent(i));
            }
        }
    }

    private void scroll(int n) {
        JScrollBar jScrollBar = this._sp.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() + n);
    }
}

