/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import oracle.dbtools.raptor.controls.celleditor.popups.BFileEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.BLOBEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.NestedTableEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleTimestampEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.XMLTypeEditPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.util.ModelUtil;

public class PopupCellEditorFactory {
    private static int TIMESTAMPTYPE = 123456781;
    private static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    private static HashMap<String, HashMap<Integer, Stack<PopupCellEditor>>> connectionToEditorsMap = new HashMap();

    public static void registerPopupEditor(int n, PopupCellEditor popupCellEditor, String string) {
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, n, popupCellEditor, string);
    }

    public static void registerPopupEditor(String string, int n, PopupCellEditor popupCellEditor, String string2) {
        if (ModelUtil.hasLength((String)string)) {
            Integer n2;
            HashMap<Integer, Stack<PopupCellEditor>> hashMap;
            Stack<PopupCellEditor> stack;
            if (connectionToEditorsMap.get(string) == null) {
                connectionToEditorsMap.put(string, new HashMap());
            }
            if ((stack = (hashMap = connectionToEditorsMap.get(string)).get(n2 = Integer.valueOf(n))) == null) {
                stack = new Stack();
                hashMap.put(n2, stack);
            }
            stack.push(popupCellEditor);
        }
    }

    public static void unRegisterPopupEditor(String string, int n, PopupCellEditor popupCellEditor) {
        HashMap<Integer, Stack<PopupCellEditor>> hashMap;
        Stack<PopupCellEditor> stack;
        if (connectionToEditorsMap.get(string) != null && (stack = (hashMap = connectionToEditorsMap.get(string)).get(n)) != null) {
            stack.remove(popupCellEditor);
        }
    }

    public static PopupCellEditor getPopupCellEditor(String string, int n, String string2) {
        PopupCellEditor popupCellEditor = null;
        String string3 = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            string3 = properties.getProperty("driver");
        }
        if (ModelUtil.hasLength(string3)) {
            popupCellEditor = PopupCellEditorFactory.getPopupCellEditorForDriver(string3, n, string2);
        }
        return popupCellEditor;
    }

    public static PopupCellEditor getPopupCellEditor(String string, int n) {
        PopupCellEditor popupCellEditor = null;
        String string2 = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            string2 = properties.getProperty("driver");
        }
        if (ModelUtil.hasLength(string2)) {
            popupCellEditor = PopupCellEditorFactory.getPopupCellEditorForDriver(string2, n);
        }
        return popupCellEditor;
    }

    private static PopupCellEditor getPopupCellEditorForDriver(String string, int n, String string2) {
        if (string.equals(ORACLE_DRIVER) && string2 != null && string2.equals("TIMESTAMP")) {
            return PopupCellEditorFactory.getPopupCellEditorForDriver(string, TIMESTAMPTYPE);
        }
        return PopupCellEditorFactory.getPopupCellEditorForDriver(string, n);
    }

    private static PopupCellEditor getPopupCellEditorForDriver(String string, int n) {
        Stack<PopupCellEditor> stack;
        PopupCellEditor popupCellEditor = null;
        HashMap<Integer, Stack<PopupCellEditor>> hashMap = connectionToEditorsMap.get(string);
        if (hashMap != null && (stack = hashMap.get(n)) != null) {
            try {
                popupCellEditor = stack.pop();
                if (popupCellEditor != null) {
                    stack.push(popupCellEditor);
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        if (popupCellEditor == null && !string.equals(ORACLE_DRIVER)) {
            return PopupCellEditorFactory.getPopupCellEditorForDriver(ORACLE_DRIVER, n);
        }
        return popupCellEditor;
    }

    public static PopupCellEditor getPopupCellEditor(int n) {
        return PopupCellEditorFactory.getPopupCellEditor(ORACLE_DRIVER, n);
    }

    static {
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 12, new LongCharEditPanel(), "VARCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 1, new LongCharEditPanel(), "CHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -9, new LongCharEditPanel(), "NVARCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -15, new LongCharEditPanel(), "NCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 91, new OracleDateTimeEditPanel(), "DATE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 92, new OracleDateTimeEditPanel(), "TIME");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 93, new OracleDateTimeEditPanel(), "TIMESTAMP");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, TIMESTAMPTYPE, new OracleTimestampEditPanel(), "TIMESTAMP");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -102, new OracleDateTimeEditPanel(), "TIMESTAMPLTZ");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -101, new OracleDateTimeEditPanel(), "TIMESTAMPTZ");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -13, new BFileEditPanel(), "BFILE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2007, new XMLTypeEditPanel(), "OPAQUE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2003, new NestedTableEditPanel(), "ARRAY");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -10, new NestedTableEditPanel(), "CURSOR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2005, new LongCharEditPanel(), "CLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2011, new LongCharEditPanel(), "NCLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -1, new LongCharEditPanel(), "LONG");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2004, new BLOBEditPanel(), "BLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2002, new LongCharEditPanel(), "STRUCT");
    }
}

