/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.extendedtype.BFILEDirectory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;

public class BFileInsertPanel
extends JPanel {
    static final String SELECT_DIR = Messages.getString("BFileInsertPanel.0");
    static final String SELECT_FILE = Messages.getString("BFileInsertPanel.1");
    List<BFILEDirectory> m_dirList = new ArrayList<BFILEDirectory>();
    JLabel dirLabel = new JLabel();
    JComboBox dirCombo = new JComboBox();
    JLabel fileLabel = new JLabel();
    JComboBox fileCombo = new JComboBox();
    JButton dirButton = new JButton();
    BFILEDirectory dir = null;
    String file = null;

    public BFileInsertPanel(List<BFILEDirectory> list, BFILEDirectory bFILEDirectory, String string) {
        this.dir = bFILEDirectory;
        this.file = string;
        this.setLayout(new GridBagLayout());
        this.createGUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_extendeddataedit_html");
        this.addListeners();
        this.fillDirCombo(list);
    }

    public BFileInsertPanel(Connection connection, BFILEDirectory bFILEDirectory, String string) {
        this(BFileInsertPanel.getDirectoryList(connection), bFILEDirectory, string);
    }

    public static List<BFILEDirectory> getDirectoryList(Connection connection) {
        ArrayList<BFILEDirectory> arrayList = new ArrayList<BFILEDirectory>();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select  * from all_directories");
            ResultSet resultSet = preparedStatement.executeQuery("select  * from all_directories");
            if (resultSet != null) {
                while (resultSet.next()) {
                    BFILEDirectory bFILEDirectory = new BFILEDirectory(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                    arrayList.add(bFILEDirectory);
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(BFileInsertPanel.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return arrayList;
    }

    private void fillDirCombo(List<BFILEDirectory> list) {
        this.m_dirList = list;
        this.dirCombo.removeAllItems();
        if (list != null) {
            for (BFILEDirectory bFILEDirectory : list) {
                this.dirCombo.addItem(bFILEDirectory);
            }
        }
        this.dirCombo.addItem(SELECT_DIR);
        this.dirCombo.setSelectedIndex(this.dirCombo.getItemCount() - 1);
        if (this.dir != null) {
            for (BFILEDirectory bFILEDirectory : list) {
                if (!bFILEDirectory.getName().equals(this.dir.getName()) || !bFILEDirectory.getPath().equals(this.dir.getPath())) continue;
                this.dirCombo.setSelectedItem(bFILEDirectory);
            }
        }
    }

    private void fillFileCombo(String[] stringArray) {
        this.fileCombo.removeAllItems();
        if (stringArray != null) {
            for (String string : stringArray) {
                File file = new File(string);
                if (file.isDirectory()) continue;
                this.fileCombo.addItem(file.getName());
            }
        }
        this.fileCombo.addItem(SELECT_FILE);
        this.fileCombo.setSelectedIndex(this.fileCombo.getItemCount() - 1);
        if (this.file != null) {
            this.fileCombo.setSelectedItem(this.file);
        }
    }

    private void addListeners() {
        this.dirCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = itemEvent.getItem();
                if (itemEvent.getStateChange() == 1 && object != null && !object.equals(SELECT_DIR)) {
                    BFILEDirectory bFILEDirectory = (BFILEDirectory)object;
                    File file = null;
                    if (bFILEDirectory.getPath() != null) {
                        file = new File(bFILEDirectory.getPath());
                    }
                    if (file != null && file.exists()) {
                        BFileInsertPanel.this.fillFileCombo(file.list());
                    } else {
                        BFileInsertPanel.this.fillFileCombo(new String[0]);
                    }
                }
            }
        });
        this.fileCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
            }
        });
        this.dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    private void createGUI() {
        this.dirCombo.setRenderer(new MyComboBoxRenderer());
        ResourceUtils.resLabel((JLabel)this.dirLabel, (Component)this.dirCombo, (String)Messages.getString("BFileInsertPanel.2"));
        this.add((Component)this.dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.dirCombo, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.dirButton, (String)Messages.getString("BFileInsertPanel.3"));
        ResourceUtils.resLabel((JLabel)this.fileLabel, (Component)this.fileCombo, (String)Messages.getString("BFileInsertPanel.4"));
        this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.fileCombo.setEditable(true);
        this.add((Component)this.fileCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public static void main(String[] stringArray) {
        List<BFILEDirectory> list = Collections.emptyList();
        BFileInsertPanel bFileInsertPanel = new BFileInsertPanel(list, null, null);
        JFrame jFrame = new JFrame(Messages.getString("BFileInsertPanel.5"));
        jFrame.setLayout(new GridBagLayout());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jFrame.getContentPane().add(bFileInsertPanel);
        jFrame.setSize(bFileInsertPanel.getPreferredSize());
        jFrame.setVisible(true);
    }

    public String getDir() {
        Object object = this.dirCombo.getSelectedItem();
        if (object != null && object instanceof BFILEDirectory) {
            return ((BFILEDirectory)object).getName();
        }
        return null;
    }

    public BFILEDirectory getBFILEDirectory() {
        Object object = this.dirCombo.getSelectedItem();
        if (object != null && object instanceof BFILEDirectory) {
            return (BFILEDirectory)this.dirCombo.getSelectedItem();
        }
        return null;
    }

    public String getFile() {
        Object object = this.fileCombo.getSelectedItem();
        if (object != null && !object.equals(SELECT_FILE)) {
            return object.toString();
        }
        return null;
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (-1 < n) {
                    if (object instanceof BFILEDirectory) {
                        BFILEDirectory bFILEDirectory = (BFILEDirectory)object;
                        jList.setToolTipText(Messages.getString("BFileInsertPanel.6") + bFILEDirectory.getOwner() + Messages.getString("BFileInsertPanel.7") + bFILEDirectory.getPath());
                    } else {
                        jList.setToolTipText(object.toString());
                    }
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }
}

