/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.DnDDropGenerator;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;

public class RaptorDnD
extends DropTargetAdapter {
    private JTextComponent _target;

    public static List<Object> getTransferableNodes(Transferable[] transferableArray) throws UnsupportedFlavorException, IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Transferable transferable : transferableArray) {
            if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                arrayList.addAll((Collection<Object>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
                continue;
            }
            if (!transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) continue;
            arrayList.add(transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
        }
        return arrayList;
    }

    public static List<Object> getTransferableNodes(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return RaptorDnD.getTransferableNodes(new Transferable[]{transferable});
    }

    public RaptorDnD() {
        this(null);
        Logger.getLogger(RaptorDnD.class.getName());
    }

    public RaptorDnD(JTextComponent jTextComponent) {
        Logger.getLogger(RaptorDnD.class.getName());
        this._target = jTextComponent;
        this.init();
    }

    private void init() {
        new DropTarget(this._target, 1, this, true, null);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = this._target.viewToModel(dropTargetDragEvent.getLocation());
        this._target.setCaretPosition(n);
        try {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            List<Object> list = RaptorDnD.getTransferableNodes(new Transferable[]{transferable});
            for (int i = 0; i < list.size(); ++i) {
                Object object = null;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                defaultMutableTreeNode = list.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)list.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)list.get(i);
                object = defaultMutableTreeNode.getUserObject();
                String string = null;
                if (object instanceof DatabaseConnection) {
                    if (!Connections.getInstance().isOracle(((DatabaseConnection)object).getConnectionName())) {
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                    break;
                }
                if (object instanceof ObjectNode) {
                    DBObject dBObject;
                    block13: {
                        ObjectNode objectNode = (ObjectNode)object;
                        dBObject = objectNode.getDBObject();
                        try {
                            if (!Connections.getInstance().isOracle(Connections.getInstance().getConnection(objectNode.getConnectionName()))) {
                                dropTargetDragEvent.rejectDrag();
                            }
                            break block13;
                        }
                        catch (DBException dBException) {
                            dropTargetDragEvent.rejectDrag();
                        }
                        break;
                    }
                    if (dBObject != null) {
                        string = dBObject.getType();
                    }
                }
                if (string != null && (string.equals("TABLE") || string.equals("VIEW"))) continue;
                dropTargetDragEvent.rejectDrag();
                break;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = null;
        try {
            if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)).getUserObject()) instanceof DatabaseConnection) {
                if (Connections.getInstance().isOracle(((DatabaseConnection)object).getConnectionName())) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                }
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            this.drop(dropTargetDropEvent, this._target);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public boolean drop(DropTargetDropEvent dropTargetDropEvent, JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        this._target = jTextComponent;
        int n = jTextComponent.viewToModel(dropTargetDropEvent.getLocation());
        Transferable transferable = dropTargetDropEvent.getTransferable();
        jTextComponent.setAutoscrolls(true);
        boolean bl = false;
        try {
            if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR) || transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                document.insertString(n, this.nodeDrop(transferable, n), null);
                bl = true;
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                document.insertString(n, string, null);
                bl = true;
            }
            jTextComponent.setCaretPosition(n);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nodeDrop(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        String string = null;
        List<Object> list = RaptorDnD.getTransferableNodes(transferable);
        DnDDropGenerator dnDDropGenerator = new DnDDropGenerator();
        StringBuilder stringBuilder = new StringBuilder("");
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = list.get(0) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)list.get(0)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)list.get(0);
        ObjectNode objectNode = null;
        String string2 = null;
        if (defaultMutableTreeNode.getUserObject() instanceof ObjectNode) {
            objectNode = (ObjectNode)defaultMutableTreeNode.getUserObject();
            string2 = objectNode.getConnectionName();
            if (Connections.getInstance().lock(string2)) {
                try {
                    stringBuilder = dnDDropGenerator.generate(list, "VASAN_DUMMY");
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    Connections.getInstance().unlock(string2);
                }
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
                if (stringBuilder.length() > 1) {
                    string = stringBuilder.toString();
                }
            }
        }
        return string;
    }

    private String getFunctionDrop(Function function) {
        StringBuilder stringBuilder = new StringBuilder("ret/*" + function.getReturnType() + "*/ := " + DBUtil.addDoubleQuote((String)function.getSchema().getName()) + "." + DBUtil.addDoubleQuote((String)function.getName()));
        PlSqlParameter[] plSqlParameterArray = function.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.addDoubleQuote((String)plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    public String getProcedureDrop(Procedure procedure) {
        StringBuilder stringBuilder = new StringBuilder(DBUtil.addDoubleQuote((String)procedure.getSchema().getName()) + "." + DBUtil.addDoubleQuote((String)procedure.getName()));
        PlSqlParameter[] plSqlParameterArray = procedure.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.addDoubleQuote((String)plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }
}

