/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Subject;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.datatypes.DataTypeID;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class DnDDropGenerator {
    private static final String DEFAULT_TEMPLATE = "dnd";
    private StringTemplateGroup m_templateGroup;
    private int m_option = 0;
    private WorksheetDndOptionPanel m_panel;
    private String _worksheetConnectionName = null;
    private AliasGenerator m_aliasGen;
    private static final Set<String> CHARACTER_TYPES = new HashSet<String>(Arrays.asList("CHAR", "NCHAR", "VARCHAR2", "NVARCHAR2"));

    void setWorksheetConnection(String string) {
        this._worksheetConnectionName = string;
    }

    private int getOption(List<?> list, String string) {
        if ("FUNCTION".equals(string) || "PROCEDURE".equals(string)) {
            return -911;
        }
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_panel = new WorksheetDndOptionPanel();
        this.m_panel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
        this.m_panel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        if (list != null && list.size() > 1) {
            int n = this.m_panel.getDragType();
            if (n == 2 || n == 1) {
                this.m_panel.enableJoin();
            }
        } else {
            this.m_panel.disableJoin();
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(Messages.getString("DnDDropGenerator.4"))) {
                    DBConfig dBConfig = DBConfig.getInstance();
                    DnDDropGenerator.this.m_panel.setCancel(false);
                    DnDDropGenerator.this.m_option = DnDDropGenerator.this.m_panel.getDragType();
                    int n = DnDDropGenerator.this.m_panel.getPrompt();
                    dBConfig.putInt("DRAG_N_DROP_PROMPT", n);
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        };
        UIUtils.showPanelAsDialog((JPanel)this.m_panel, (String)PreferencesArb.getString("DND_LABEL"), (ActionListener)actionListener, (boolean)true);
        return this.m_panel.isCanceled() ? -911 : this.m_panel.getDragType();
    }

    private boolean objInDragList(String string, List<ObjectNode> list) {
        if (string != null && list != null) {
            for (ObjectNode objectNode : list) {
                if (!objectNode.getObjectName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAlias(String string, String string2, List<RefPair> list, List<RefPair> list2) {
        if (!(list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            return this.getAliasGenerator().getNextAlias();
        }
        String string3 = null;
        ListIterator<RefPair> listIterator = null;
        if (list != null) {
            listIterator = list.listIterator();
        }
        ListIterator<RefPair> listIterator2 = null;
        if (list2 != null) {
            listIterator2 = list2.listIterator();
        }
        RefPair refPair = null;
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        while (string3 == null && listIterator2 != null && listIterator2.hasNext()) {
            refPair = listIterator2.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        if (string3 == null) {
            string3 = this.getAliasGenerator().getNextAlias();
        }
        return string3;
    }

    private AliasGenerator getAliasGenerator() {
        if (this.m_aliasGen == null) {
            this.m_aliasGen = new AliasGenerator();
        }
        return this.m_aliasGen;
    }

    private RefPair getRefPairsFromConsName(String string, String string2, String string3, String string4, String string5, String string6, List<ObjectNode> list, List<RefPair> list2, List<RefPair> list3) throws SQLException {
        String string7 = "select table_name, column_name from all_cons_columns where constraint_name = ? and owner = ?";
        String string8 = "select table_name, column_name from all_cons_columns where constraint_name = ? and owner = ?";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string4);
        arrayList.add(string6);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string5);
        arrayList2.add(string2);
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        ResultSetWrapper resultSetWrapper = dBUtil.executeQuery(string7, arrayList);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string9 = null;
        String string10 = null;
        String string11 = null;
        ResultSet resultSet = resultSetWrapper.getResultSet();
        if (!resultSet.next()) {
            resultSetWrapper.close();
            return null;
        }
        do {
            if (!this.objInDragList(string9 = resultSet.getString(1), list)) {
                resultSetWrapper.close();
                return null;
            }
            string10 = resultSet.getString(2);
            arrayList3.add(string10);
        } while (resultSet.next());
        refPair = new RefPair();
        refPair.setPrimTable(string9);
        refPair.setPrimTableOwner(string6);
        string11 = this.getAlias(string6, string9, list2, list3);
        refPair.setPrimAlias(string11);
        refPair.setPrimConstName(string4);
        refPair.setPrimCols(arrayList3);
        resultSetWrapper.close();
        resultSetWrapper = dBUtil.executeQuery(string8, arrayList2);
        if (resultSetWrapper != null) {
            resultSet = resultSetWrapper.getResultSet();
            while (resultSet.next()) {
                string9 = resultSet.getString(1);
                string10 = resultSet.getString(2);
                arrayList4.add(string10);
            }
            resultSetWrapper.close();
        }
        refPair.setRefTable(string9);
        refPair.setRefTableOwner(string2);
        string11 = refPair.getPrimTableOwner().equals(refPair.getRefTableOwner()) && refPair.getPrimTable().equals(refPair.getRefTable()) ? refPair.getPrimAlias() : this.getAlias(string2, string9, list2, list3);
        refPair.setRefAlias(string11);
        refPair.setRefConstName(string5);
        refPair.setRefCols(arrayList4);
        return refPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RefPair> getRefPairsForObjectName(String string, String string2, String string3, List<ObjectNode> list, List<RefPair> list2) throws SQLException {
        String string4 = "select constraint_name, r_constraint_name, r_owner   from all_constraints c where constraint_type = 'R'  and table_name = ?  and owner = ? and r_constraint_name not in (select constraint_name  from all_constraints where table_name = ?  and   owner = ?)";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<RefPair> arrayList2 = null;
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        ResultSetWrapper resultSetWrapper = dBUtil.executeQuery(string4, arrayList);
        if (resultSetWrapper != null) {
            ResultSet resultSet = resultSetWrapper.getResultSet();
            try {
                while (resultSet.next()) {
                    String string5;
                    String string6 = resultSet.getString(1);
                    String string7 = resultSet.getString(2);
                    refPair = this.getRefPairsFromConsName(string, string2, string3, string7, string6, string5 = resultSet.getString(3), list, list2, arrayList2);
                    if (refPair == null) continue;
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<RefPair>();
                    }
                    arrayList2.add(refPair);
                }
            }
            finally {
                resultSetWrapper.close();
            }
        }
        return arrayList2;
    }

    private boolean isObjectPartOfRefPair(String string, List<RefPair> list) {
        RefPair refPair = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                refPair = list.get(i);
                if (!refPair.getQuotedPrimTable().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getTableColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "select column_name from all_tab_columns where table_name=? AND owner = ?";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        DatabaseMetaData databaseMetaData = null;
        String string5 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            string5 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        String string6 = null;
        string6 = string2 != null && !string2.equals(string5) ? DBUtil.addDoubleQuote((String)string2) + "." + DBUtil.addDoubleQuote((String)string3) + "." : DBUtil.addDoubleQuote((String)string3) + ".";
        ResultSetWrapper resultSetWrapper = dBUtil.executeQuery(string4, arrayList);
        if (resultSetWrapper != null) {
            ResultSet resultSet = resultSetWrapper.getResultSet();
            try {
                while (resultSet.next()) {
                    arrayList2.add(string6 + DBUtil.addDoubleQuote((String)resultSet.getString(1)));
                }
            }
            finally {
                resultSetWrapper.close();
            }
        }
        return arrayList2;
    }

    private boolean isObjUnique(String string, String string2, List<String> list) {
        if (list == null || string2 == null) {
            return false;
        }
        Iterator<String> iterator = list.iterator();
        String string3 = null;
        String string4 = null;
        while (iterator != null && iterator.hasNext()) {
            string4 = iterator.next();
            int n = string4.indexOf(".");
            if (n >= 0) {
                string3 = string4.substring(0, n);
                string4 = string4.substring(string4.indexOf(".") + 1, string4.indexOf(" "));
            } else {
                string3 = null;
                string4 = string4.substring(0, string4.indexOf(" "));
            }
            if (string3 != null && !string3.equals(string) || !string4.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private List<String> getRefTables(List<RefPair> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (RefPair refPair : list) {
            stringBuilder.delete(0, stringBuilder.length());
            if (this.isObjUnique(refPair.getQuotedRefTableOwner(), refPair.getQuotedRefTable(), arrayList)) {
                if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getRefTableOwner())) {
                    stringBuilder.append(refPair.getQuotedRefTableOwner());
                    stringBuilder.append(".");
                }
                stringBuilder.append(refPair.getQuotedRefTable());
                stringBuilder.append(" ");
                stringBuilder.append(refPair.getRefAlias());
                arrayList.add(stringBuilder.toString());
            }
            stringBuilder.delete(0, stringBuilder.length());
            if (!this.isObjUnique(refPair.getQuotedPrimTableOwner(), refPair.getQuotedPrimTable(), arrayList)) continue;
            if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getPrimTableOwner())) {
                stringBuilder.append(refPair.getQuotedPrimTableOwner());
                stringBuilder.append(".");
            }
            stringBuilder.append(refPair.getQuotedPrimTable());
            stringBuilder.append(" ");
            stringBuilder.append(refPair.getPrimAlias());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private List<CondObj> getConditionList(List<RefPair> list) {
        List<String> list2 = null;
        ArrayList<CondObj> arrayList = null;
        CondObj condObj = null;
        for (RefPair refPair : list) {
            List<String> list3 = refPair.getPrimCols();
            list2 = refPair.getRefCols();
            if (list3.size() != list2.size()) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("DnDDropGenerator.19"), list3.size(), list2.size(), refPair.getRefTableOwner() + "." + refPair.getRefTable()));
            }
            Iterator<String> iterator = list3.iterator();
            Iterator<String> iterator2 = list2.iterator();
            while (iterator != null && iterator2 != null && iterator.hasNext() && iterator2.hasNext()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<CondObj>();
                }
                condObj = new CondObj();
                condObj.setCol1(refPair.getPrimAlias() + "." + DBUtil.addDoubleQuote((String)iterator.next()));
                condObj.setCol2(refPair.getRefAlias() + "." + DBUtil.addDoubleQuote((String)iterator2.next()));
                arrayList.add(condObj);
            }
        }
        return arrayList;
    }

    private String constructJoinSQL(List<String> list, List<String> list2, List<CondObj> list3) {
        String string = null;
        StringTemplate stringTemplate = null;
        stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
        stringTemplate.setAttribute("colList", list);
        stringTemplate.setAttribute("objectNames", list2);
        stringTemplate.setAttribute("cond", (Object)(list3 != null && list3.size() > 0 ? 1 : 0));
        stringTemplate.setAttribute("condList", list3);
        string = stringTemplate.toString();
        if (string.endsWith(" AND ;")) {
            string = string.substring(0, string.lastIndexOf(" AND ;")) + ";";
        }
        return string;
    }

    private void ensureAliasPrefixForColumns(List<String> list, List<RefPair> list2) {
        if (list == null || list2 == null) {
            return;
        }
        ListIterator<String> listIterator = list.listIterator();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        block0: while (listIterator != null && listIterator.hasNext()) {
            string3 = listIterator.next();
            n = string3.indexOf(".");
            if (n != (n2 = string3.lastIndexOf("."))) {
                string = string3.substring(0, n);
                string2 = string3.substring(n + 1, n2);
            } else {
                string = null;
                string2 = string3.substring(0, n);
            }
            string3 = string3.substring(n2 + 1);
            for (RefPair refPair : list2) {
                if ((string == null || string.equals(refPair.getQuotedPrimTableOwner())) && string2.equals(refPair.getQuotedPrimTable())) {
                    listIterator.set(refPair.getPrimAlias() + "." + string3);
                    continue block0;
                }
                if (string != null && !string.equals(refPair.getQuotedRefTableOwner()) || !string2.equals(refPair.getQuotedRefTable())) continue;
                listIterator.set(refPair.getRefAlias() + "." + string3);
                continue block0;
            }
        }
    }

    private String getJoinSql(List<ObjectNode> list) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<RefPair> arrayList = new ArrayList<RefPair>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List<CondObj> list2 = null;
        List<RefPair> list3 = null;
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            object3 = list.get(i);
            string = ((ObjectNode)object3).getSchemaName();
            list3 = this.getRefPairsForObjectName(((ObjectNode)object3).getConnectionName(), string, ((ObjectNode)object3).getObjectName(), list, arrayList);
            if (list3 != null) {
                arrayList.addAll(list3);
            } else if (!this.isObjectPartOfRefPair(((ObjectNode)object3).getObjectName(), arrayList)) {
                object2 = null;
                object = null;
                try {
                    object2 = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
                    object = object2.getUserName();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                if (!((String)object).equals(string)) {
                    arrayList2.add(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)((ObjectNode)object3).getObjectName()));
                } else {
                    arrayList2.add(DBUtil.addDoubleQuote((String)((ObjectNode)object3).getObjectName()));
                }
            }
            arrayList4.addAll(this.getTableColumns(((ObjectNode)object3).getConnectionName(), string, ((ObjectNode)object3).getObjectName()));
        }
        DatabaseMetaData databaseMetaData = null;
        object3 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            object3 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        object2 = this.getRefTables(arrayList, (String)object3);
        arrayList3.addAll((Collection<String>)object2);
        object = null;
        object = arrayList2.listIterator();
        while (object != null && object.hasNext()) {
            if (this.isUnique(arrayList, (String)object.next())) continue;
            object.remove();
        }
        arrayList3.addAll(arrayList2);
        this.ensureAliasPrefixForColumns(arrayList4, arrayList);
        list2 = this.getConditionList(arrayList);
        return this.constructJoinSQL(arrayList4, arrayList3, list2);
    }

    private boolean isUnique(List<RefPair> list, String string) {
        RefPair refPair = null;
        String string2 = null;
        String string3 = null;
        if (string == null || list == null) {
            return true;
        }
        int n = 0;
        n = string.indexOf(".");
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        ListIterator<RefPair> listIterator = list.listIterator();
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if ((string2 != null && !string2.equals(refPair.getQuotedPrimTableOwner()) || !string3.equals(refPair.getQuotedPrimTable())) && (string2 != null && !string2.equals(refPair.getQuotedRefTableOwner()) || !string3.equals(refPair.getQuotedRefTable()))) continue;
            return false;
        }
        return true;
    }

    private String getJoinStatement(List<?> list) throws SQLException {
        String string = null;
        ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof ObjectNode)) continue;
            arrayList.add((ObjectNode)obj);
        }
        string = this.getJoinSql(arrayList);
        return string;
    }

    protected StringBuilder generate(List<?> list, String string) throws UnsupportedFlavorException, IOException, SQLException, DBException, AbortException {
        StringBuilder stringBuilder = new StringBuilder();
        Object var4_4 = null;
        String string2 = null;
        this.loadTemplates();
        int n = DBConfig.getInstance().getInt("DRAG_N_DROP_PROMPT");
        this.m_option = n == 0 ? this.getOption(list, string) : DBConfig.getInstance().getInt("DRAG_N_DROP_CHOICES");
        if (this.m_option == 2 && list.size() > 1) {
            stringBuilder.append(this.getJoinStatement(list));
            return stringBuilder;
        }
        for (int i = 0; i < list.size(); ++i) {
            Subject subject;
            Object obj = list.get(i);
            if (this.m_option != 6 && obj instanceof ObjectNode) {
                subject = (ObjectNode)obj;
                stringBuilder.append(this.getDropStatement(subject, null, string, this.m_option));
                continue;
            }
            if (this.m_option != 6 && obj instanceof PlSqlNode) {
                stringBuilder.append(this.buildStatementForPlSqlNode((PlSqlNode)obj));
                continue;
            }
            if (this.m_option != 6 && obj instanceof ChildObjectElement) {
                subject = (ChildObjectElement)((Object)obj);
                String[] stringArray = this.getColNamesFromNodes(list);
                String string3 = (String)subject.getProperty("ConnectionType");
                if (!"Oracle".equals(string3) || !"COLUMN".equals(string) && !"VIEW_COLUMN".equals(string)) continue;
                string2 = (String)subject.getProperty("OBJECT_NAME");
                stringBuilder.append(this.getDropStatement(subject, stringArray, (String)subject.getProperty("PARENT TYPE"), this.m_option));
                break;
            }
            stringBuilder.append(obj.toString() + ",");
        }
        return stringBuilder;
    }

    private String[] getColNamesFromNodes(List<?> list) throws UnsupportedFlavorException, IOException {
        String[] stringArray = null;
        Object object = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = 0;
        if (list == null || list.size() == 0) {
            return stringArray;
        }
        stringArray = new String[list.size()];
        for (Object obj : list) {
            if (obj instanceof MultiTransferable) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)((MultiTransferable)obj).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
            } else if (obj instanceof ChildObjectElement) {
                object = obj;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)obj;
            }
            if (defaultMutableTreeNode != null) {
                object = defaultMutableTreeNode.getUserObject();
            }
            if (object instanceof ChildObjectElement) {
                stringArray[n++] = DBUtil.addDoubleQuote((String)((String)((ChildObjectElement)((Object)object)).getProperty("NAME")));
                continue;
            }
            stringArray[n++] = "UNEXPECTEDTYPE";
        }
        return stringArray;
    }

    private String buildStatementForPlSqlNode(PlSqlNode plSqlNode) {
        StringTemplate stringTemplate = null;
        String string = "";
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string4 = null;
        DBObject dBObject = plSqlNode.getDBObject();
        boolean bl = false;
        String string5 = null;
        DBObject[] dBObjectArray = null;
        String string6 = null;
        int n = 0;
        int n2 = 0;
        if (!(dBObject instanceof Function)) {
            stringTemplate = this.getTemplateGroup().getInstanceOf("ProcedureStatement");
        } else {
            try {
                stringTemplate = this.getTemplateGroup().getInstanceOf("FunctionStatement");
                string4 = ((Function)plSqlNode.getDBObject()).getReturnTypeID().resolveID().getName();
                bl = true;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        dBObjectArray = plSqlNode.getDBObject().getOwnedObjects();
        string2 = plSqlNode.getSchemaName();
        string3 = plSqlNode.getObjectName();
        string6 = DBUtil.addDoubleQuote((String)string2) + "." + DBUtil.addDoubleQuote((String)string3);
        if (dBObjectArray != null && dBObjectArray.length > 0) {
            stringArray = new String[dBObjectArray.length];
            stringArray2 = new String[dBObjectArray.length];
            for (DBObject dBObject2 : dBObjectArray) {
                stringArray[n++] = DBUtil.addDoubleQuote((String)((PlSqlParameter)dBObject2).getName());
                DBObjectID dBObjectID = ((PlSqlParameter)dBObject2).getDataTypeID();
                if (dBObjectID instanceof DataTypeID) {
                    string5 = ((DataTypeID)dBObjectID).getTypeName();
                } else if (dBObjectID instanceof ReferenceID) {
                    string5 = ((ReferenceID)dBObjectID).getName() + "%TYPE";
                }
                if (this.isCharType(string5)) {
                    String string7 = "";
                    string7 = !(plSqlNode.getDBObject() instanceof Function) ? this.getLengthForParam(plSqlNode, ((Procedure)plSqlNode.getDBObject()).getSchema().getName(), ((PlSqlParameter)dBObject2).getName(), ((Procedure)plSqlNode.getDBObject()).getName(), ((Procedure)plSqlNode.getDBObject()).getType()) : this.getLengthForParam(plSqlNode, ((Function)plSqlNode.getDBObject()).getSchema().getName(), ((PlSqlParameter)dBObject2).getName(), ((Function)plSqlNode.getDBObject()).getName(), ((Function)plSqlNode.getDBObject()).getType());
                    string5 = string5 + (string7 == null ? "(200)" : string7);
                }
                stringArray2[n2++] = DBUtil.addDoubleQuote((String)((PlSqlParameter)dBObject2).getName()) + "  " + string5;
            }
        }
        if (!bl) {
            stringTemplate.setAttribute("objectName", (Object)string6);
            stringTemplate.setAttribute("paramList", (Object)stringArray);
            stringTemplate.setAttribute("procArgs", (Object)stringArray2);
        } else {
            stringTemplate.setAttribute("objectName", (Object)string6);
            stringTemplate.setAttribute("paramList", (Object)stringArray);
            stringTemplate.setAttribute("procArgs", (Object)stringArray2);
            stringTemplate.setAttribute("returnType", (Object)string4);
        }
        string = stringTemplate.toString() + "\n";
        return string;
    }

    private String getLengthForParam(PlSqlNode plSqlNode, String string, String string2, String string3, String string4) {
        DBUtil dBUtil = null;
        String string5 = "SELECT DATA_LENGTH FROM SYS.ALL_ARGUMENTS WHERE OWNER = '" + string + "' AND OBJECT_NAME = '" + string3 + "'AND ARGUMENT_NAME = '" + string2 + "'";
        String string6 = null;
        try {
            dBUtil = DBUtil.getInstance((Connection)Connections.getInstance().getConnection(plSqlNode.getConnectionName()));
            string6 = dBUtil.executeReturnOneCol(string5, (List)null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string6;
    }

    /*
     * WARNING - void declaration
     */
    private String getDropStatement(Object object, String[] stringArray, String string, int n) throws SQLException, AbortException, DBException {
        void var14_23;
        String string2 = "";
        boolean bl = false;
        String[] stringArray2 = null;
        List<DBChildInstance> list = null;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (object instanceof ObjectNode) {
            ((ObjectNode)object).ensureOpen();
            string3 = ((ObjectNode)object).getConnectionName();
            string4 = ((ObjectNode)object).getSchemaName();
            string5 = ((ObjectNode)object).getObjectName();
            if (stringArray == null) {
                list = string.equals("VIEW") ? ((ObjectNode)object).getNodeInstance().listChildren("VIEW_COLUMN") : ((ObjectNode)object).getNodeInstance().listChildren("COLUMN");
                stringArray2 = list != null ? new String[list.size()] : new String[]{};
                int n2 = 0;
                if (stringArray2.length > 0) {
                    for (DBChildInstance object22 : list) {
                        stringArray2[n2] = DBUtil.addDoubleQuote((String)((String)object22.getProperty("NAME")));
                        ++n2;
                    }
                }
            } else {
                stringArray2 = stringArray;
            }
        } else if (object instanceof ChildObjectElement) {
            URL uRL = ((ChildObjectElement)((Object)object)).getURL();
            string3 = Connections.getConnName(uRL);
            string4 = (String)((ChildObjectElement)((Object)object)).getProperty("SCHEMA");
            string5 = (String)((ChildObjectElement)((Object)object)).getProperty("OBJECT_NAME");
            stringArray2 = stringArray;
        }
        Connection connection = DBUtil.getConnectionResolver().getConnection(this._worksheetConnectionName);
        String string6 = connection.getMetaData().getUserName();
        if (string6.equals(string4)) {
            bl = true;
        }
        Object var14_17 = null;
        switch (n) {
            case 1: {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
                if (!bl) {
                    stringTemplate.setAttribute("objectNames", (Object)(DBUtil.addDoubleQuote((String)string4) + "." + DBUtil.addDoubleQuote((String)string5)));
                } else {
                    stringTemplate.setAttribute("objectNames", (Object)DBUtil.addDoubleQuote((String)string5));
                }
                stringTemplate.setAttribute("colList", (Object)stringArray2);
                break;
            }
            case 2: {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
                if (!bl) {
                    stringTemplate.setAttribute("objectNames", (Object)(DBUtil.addDoubleQuote((String)string4) + "." + DBUtil.addDoubleQuote((String)string5)));
                } else {
                    stringTemplate.setAttribute("objectNames", (Object)DBUtil.addDoubleQuote((String)string5));
                }
                stringTemplate.setAttribute("colList", (Object)stringArray2);
                break;
            }
            case 3: {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatement");
                if (!bl) {
                    stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string4) + "." + DBUtil.addDoubleQuote((String)string5)));
                } else {
                    stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string5));
                }
                stringTemplate.setAttribute("valList", (Object)new String[stringArray2.length]);
                stringTemplate.setAttribute("colList", (Object)stringArray2);
                break;
            }
            case 5: {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("DeleteStatement");
                if (!bl) {
                    stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string4) + "." + DBUtil.addDoubleQuote((String)string5)));
                    break;
                }
                stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string5));
                break;
            }
            case 4: {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("UpdateStatement");
                if (!bl) {
                    stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string4) + "." + DBUtil.addDoubleQuote((String)string5)));
                    break;
                }
                stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string5));
                break;
            }
        }
        if (var14_23 != null) {
            string2 = var14_23.toString() + "\n";
        }
        return string2;
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/raptor/controls/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        this.setTemplateName(DEFAULT_TEMPLATE);
    }

    public void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    private boolean isCharType(String string) {
        return CHARACTER_TYPES.contains(string);
    }

    private class AliasGenerator {
        private int cloneCount = 0;
        private int pos = 0;
        private String aliasString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private StringBuilder sb = new StringBuilder();

        private AliasGenerator() {
        }

        String getNextAlias() {
            String string = null;
            this.sb.delete(0, this.sb.length());
            if (this.pos < this.aliasString.length() - 1) {
                this.sb.append(this.aliasString.substring(this.pos, this.pos + 1));
            } else {
                this.sb.append(this.aliasString.substring(this.pos));
            }
            ++this.pos;
            string = this.sb.toString();
            for (int i = 0; i < this.cloneCount; ++i) {
                this.sb.append(string);
            }
            if (this.pos > this.aliasString.length() - 1) {
                this.pos %= this.aliasString.length();
                ++this.cloneCount;
            }
            return this.sb.toString();
        }
    }

    private static class CondObj {
        private String col1;
        private String col2;

        private CondObj() {
        }

        public String getCol1() {
            return this.col1;
        }

        public String getCol2() {
            return this.col2;
        }

        void setCol1(String string) {
            this.col1 = string;
        }

        void setCol2(String string) {
            this.col2 = string;
        }
    }

    private static class RefPair {
        private String ref_Tab_Owner;
        private String ref_TableName;
        private String ref_Constraint_Name;
        private List<String> ref_Tab_Col;
        private String ref_Tab_Alias;
        private String prim_Tab_Owner;
        private String prim_TableName;
        private String prim_Constraint_Name;
        private List<String> prim_Tab_Col;
        private String prim_Tab_Alias;

        private RefPair() {
        }

        String getRefTableOwner() {
            return this.ref_Tab_Owner;
        }

        String getQuotedRefTableOwner() {
            return DBUtil.addDoubleQuote((String)this.ref_Tab_Owner);
        }

        String getRefTable() {
            return this.ref_TableName;
        }

        String getQuotedRefTable() {
            return DBUtil.addDoubleQuote((String)this.ref_TableName);
        }

        String getRefConstName() {
            return this.ref_Constraint_Name;
        }

        List<String> getRefCols() {
            return this.ref_Tab_Col;
        }

        String getRefAlias() {
            return this.ref_Tab_Alias;
        }

        String getPrimTableOwner() {
            return this.prim_Tab_Owner;
        }

        String getQuotedPrimTableOwner() {
            return DBUtil.addDoubleQuote((String)this.prim_Tab_Owner);
        }

        String getPrimTable() {
            return this.prim_TableName;
        }

        String getQuotedPrimTable() {
            return DBUtil.addDoubleQuote((String)this.prim_TableName);
        }

        List<String> getPrimCols() {
            return this.prim_Tab_Col;
        }

        String getPrimAlias() {
            return this.prim_Tab_Alias;
        }

        String getPrimConstName() {
            return this.prim_Constraint_Name;
        }

        void setRefTableOwner(String string) {
            this.ref_Tab_Owner = string;
        }

        void setRefTable(String string) {
            this.ref_TableName = string;
        }

        void setRefConstName(String string) {
            this.ref_Constraint_Name = string;
        }

        void setRefCols(List<String> list) {
            this.ref_Tab_Col = list;
        }

        void addRefCol(String string) {
            this.ref_Tab_Col.add(string);
        }

        void setRefAlias(String string) {
            this.ref_Tab_Alias = string;
        }

        void setPrimTableOwner(String string) {
            this.prim_Tab_Owner = string;
        }

        void setPrimTable(String string) {
            this.prim_TableName = string;
        }

        void addPrimCol(String string) {
            this.prim_Tab_Col.add(string);
        }

        void setPrimCols(List<String> list) {
            this.prim_Tab_Col = list;
        }

        void setPrimAlias(String string) {
            this.prim_Tab_Alias = string;
        }

        void setPrimConstName(String string) {
            this.prim_Constraint_Name = string;
        }

        String getQualifiedPrimTableCol(String string) {
            return this.prim_Tab_Alias + "." + this.prim_TableName + "." + string;
        }

        String getQualifiedRefTableCol(String string) {
            return this.ref_Tab_Alias + "." + this.ref_TableName + "." + this.ref_Tab_Col;
        }
    }
}

