/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionKeySelectionManager;
import oracle.dbtools.raptor.controls.DBConnectionNameCellRenderer;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdevimpl.db.DBConnArb;

public class ConnectionPanelUI
extends JPanel
implements ActionListener,
ItemListener,
LayoutControl {
    protected static ConnectionResolver s_conns = DBUtil.getConnectionResolver();
    private static final String LAST_CONNECTION_KEY = "ConnectionPanelUI.LAST_CONNECTION_KEY";
    private String[] m_subTypes;
    private boolean m_showDetails;
    private boolean m_showUnsharedConnections;
    private boolean m_canAddNull;
    private JPanel m_contentPanel;
    private JWrappedLabel m_promptLabel;
    private JPanel m_connectionsPanel;
    private JLabel m_connectionsLabel;
    private DefaultComboBoxModel m_connectionsModel;
    private JComboBox m_connections;
    protected JButton m_btnNew;
    protected JButton m_btnEdit;
    private JPanel m_detailsPanel;
    private JLabel m_usernameLabel;
    private JLabel m_usernameField;
    private JLabel m_driverLabel;
    private JLabel m_driverField;
    private JLabel m_urlLabel;
    private JLabel m_urlField;

    public ConnectionPanelUI(boolean bl) {
        this(false, bl);
    }

    public ConnectionPanelUI(boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, bl2, bl3);
    }

    public ConnectionPanelUI(boolean bl, boolean bl2) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, bl2);
    }

    public ConnectionPanelUI(String[] stringArray, boolean bl) {
        this(stringArray, bl, false);
    }

    protected ConnectionPanelUI(boolean bl, boolean bl2, String[] stringArray) {
        this.m_showDetails = true;
        this.m_showUnsharedConnections = false;
        this.m_connectionsLabel = new JLabel();
        this.m_connectionsModel = new NonNullableComboBoxModel();
        this.m_connections = new JComboBox(this.m_connectionsModel);
        this.m_btnNew = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.m_btnEdit = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_showDetails = bl;
        this.m_showUnsharedConnections = bl2;
        if (stringArray != null) {
            Arrays.sort(stringArray);
        }
        this.m_subTypes = stringArray;
        this.initUI();
        this.m_connections.setRenderer(new DBConnectionNameCellRenderer());
        ((JTextComponent)this.m_connections.getEditor().getEditorComponent()).setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
            }
        });
        this.m_connections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanelUI.this.saveSettings();
            }
        });
    }

    public ConnectionPanelUI(String[] stringArray, boolean bl, boolean bl2) {
        this(bl, bl2, stringArray);
        this.resetConnections();
    }

    private void initUI() {
        this.m_contentPanel = LayoutControl.GBC.createPanel();
        this.m_connectionsPanel = LayoutControl.GBC.createPanel();
        this.setConnectionPrompt(this.getPromptText());
        this.layoutComponents(this.m_connectionsPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_contentPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
    }

    private void layoutComponents(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0);
        this.setConnectionLabel(DBConnArb.getString((int)7));
        jPanel.add((Component)this.m_connectionsLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.m_connections.setRenderer(new DBConnectionNameCellRenderer());
        this.m_connections.setKeySelectionManager(new DBConnectionKeySelectionManager());
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)this.m_connections, gridBagConstraints2);
        ++gridBagConstraints.gridx;
        this.addButtons(jPanel, gridBagConstraints);
        if (this.m_showDetails) {
            this.m_detailsPanel = this.getDetailsPanel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, ++n, gridBagConstraints.gridx - 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 24, 0, 24), 0, 0);
            jPanel.add((Component)this.m_detailsPanel, gridBagConstraints3);
        }
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setConnectionLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_connectionsLabel, (Component)this.m_connections, (String)string);
        this.validate();
    }

    public void setConnectionPrompt(String string) {
        if (ModelUtil.hasLength((String)string)) {
            this.m_promptLabel = new JWrappedLabel(string);
            this.m_contentPanel.removeAll();
            this.m_contentPanel.add((Component)this.m_promptLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
            this.m_contentPanel.add((Component)this.m_connectionsPanel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addSpring(this.m_contentPanel, 2, 1);
        } else if (this.m_promptLabel != null) {
            this.m_contentPanel.removeAll();
            this.m_contentPanel.add((Component)this.m_connectionsPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addSpring(this.m_contentPanel, 1, 1);
            this.m_promptLabel = null;
        }
        this.validate();
    }

    public void setPromptText(String string) {
        this.setConnectionPrompt(string);
    }

    protected String getPromptText() {
        return DBConnArb.getString((int)8);
    }

    protected void addButtons(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets.right = 5;
        this.m_btnNew.addActionListener(this);
        this.m_btnNew.setToolTipText(ControlsArb.getString("NEW_CONN_TOOLTIP"));
        this.m_btnNew.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("NEW_CONN_MNEMONIC")));
        this.addButton(jPanel, this.m_btnNew, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.m_btnEdit.addActionListener(this);
        this.m_btnEdit.setToolTipText(ControlsArb.getString("EDIT_CONN_TOOLTIP"));
        this.m_btnEdit.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("EDIT_CONN_MNEMONIC")));
        this.addButton(jPanel, this.m_btnEdit, gridBagConstraints);
        ++gridBagConstraints.gridx;
    }

    protected void addButton(JPanel jPanel, JButton jButton, GridBagConstraints gridBagConstraints) {
        IconicButtonUI.install((AbstractButton)jButton);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    protected JPanel getDetailsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_usernameLabel = new JLabel();
        this.m_usernameField = new JLabel();
        this.m_usernameLabel.setText(DBConnArb.getString((int)5));
        this.m_usernameLabel.setEnabled(false);
        this.m_driverLabel = new JLabel();
        this.m_driverField = new JLabel();
        this.m_driverLabel.setText(DBConnArb.getString((int)4));
        this.m_driverLabel.setEnabled(false);
        this.m_urlLabel = new JLabel();
        this.m_urlField = new JLabel();
        this.m_urlLabel.setText(DBConnArb.getString((int)6));
        this.m_urlLabel.setEnabled(false);
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.m_usernameLabel, gridBagConstraints);
        jPanel.add((Component)this.m_usernameField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.m_driverLabel, gridBagConstraints);
        jPanel.add((Component)this.m_driverField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.m_urlLabel, gridBagConstraints);
        jPanel.add((Component)this.m_urlField, gridBagConstraints2);
        return jPanel;
    }

    public String getConnectionName() {
        return (String)this.m_connectionsModel.getSelectedItem();
    }

    public boolean setConnectionName(String string) {
        if (this.m_connectionsModel.getIndexOf(string) != -1) {
            this.m_connectionsModel.setSelectedItem(string);
            return true;
        }
        if (!ModelUtil.hasLength((String)string) && this.m_canAddNull) {
            this.m_connections.setSelectedIndex(-1);
            return true;
        }
        return false;
    }

    protected boolean getCanAddNull() {
        return this.m_canAddNull;
    }

    public void setCanAddNull(boolean bl) {
        if (this.m_canAddNull != bl) {
            this.m_connectionsModel = bl ? new DefaultComboBoxModel() : new NonNullableComboBoxModel();
            this.m_connections = new JComboBox(this.m_connectionsModel);
        }
        this.m_canAddNull = bl;
    }

    protected String[] listConnections() {
        return s_conns.getConnNames(this.m_subTypes, this.m_showUnsharedConnections);
    }

    public int resetConnections() {
        this.m_connections.removeItemListener(this);
        String string = (String)this.m_connectionsModel.getSelectedItem();
        this.m_connectionsModel.removeAllElements();
        String[] stringArray = this.listConnections();
        if (stringArray != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (String string2 : stringArray) {
                this.m_connectionsModel.addElement(string2);
            }
        }
        if (ModelUtil.hasLength((String)string) && this.m_connectionsModel.getIndexOf(string) >= 0) {
            this.m_connectionsModel.setSelectedItem(string);
        } else {
            this.loadSettings();
        }
        this.m_connections.addItemListener(this);
        this.checkConnection();
        return this.m_connectionsModel.getSize();
    }

    protected String getSettingsKey() {
        return LAST_CONNECTION_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    public void loadSettings() {
        String string = this.getSettingsKey();
        if (string != null) {
            String string2 = this.getPropertyStorage().getProperties().getString(string);
            this.setConnectionName(string2);
        }
    }

    public void saveSettings() {
        String string;
        String string2 = this.getSettingsKey();
        if (string2 != null && ModelUtil.hasLength((String)(string = this.getConnectionName()))) {
            this.getPropertyStorage().getProperties().putString(string2, string);
        }
    }

    protected String runConnectionDialog(String string) {
        String string2;
        String string3;
        if (string == null) {
            string3 = null;
            string2 = "IdeConnections";
        } else {
            string3 = Connections.getConnectionName(string);
            string2 = Connections.getStoreName(string);
        }
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = DatabaseConnectionEditor.createLauncher();
        ConnectionInfo connectionInfo = databaseConnectionEditorLauncher.launchEditor(DatabaseConnectionStores.getInstance().getStore(string2), string3);
        return connectionInfo != null ? Connections.ConnectionKey.createConnectionKey(connectionInfo.getStoreName(), connectionInfo.getConnectionName()).getQualifiedName() : null;
    }

    protected void disableDetails() {
        if (this.m_showDetails) {
            this.m_usernameLabel.setEnabled(false);
            this.m_usernameField.setText(null);
            this.m_driverLabel.setEnabled(false);
            this.m_driverField.setText(null);
            this.m_urlLabel.setEnabled(false);
            this.m_urlField.setText(null);
            this.m_urlField.setToolTipText(null);
        }
    }

    protected void populateDetails(Properties properties) {
        if (properties == null) {
            this.disableDetails();
        } else {
            this.m_usernameLabel.setEnabled(true);
            this.m_usernameField.setText(properties.getProperty("user"));
            this.m_driverLabel.setEnabled(true);
            this.m_driverField.setText(properties.getProperty("driver"));
            this.m_urlLabel.setEnabled(true);
            String string = properties.getProperty("customUrl");
            this.m_urlField.setText(string);
            this.m_urlField.setToolTipText(string);
        }
    }

    protected void enableButtons(boolean bl) {
        this.m_btnEdit.setEnabled(bl);
    }

    public void enableActiveComponents(boolean bl) {
        this.m_connections.setEnabled(bl);
        this.m_btnNew.setEnabled(bl);
        if (bl) {
            this.checkConnection();
        } else {
            this.m_btnEdit.setEnabled(false);
            this.disableDetails();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_promptLabel != null) {
            this.m_promptLabel.setEnabled(bl);
        }
        this.m_connectionsLabel.setEnabled(bl);
        this.enableActiveComponents(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnNew) {
            String string = this.runConnectionDialog(null);
            if (ModelUtil.hasLength((String)string) && this.resetConnections() > 0) {
                this.setConnectionName(string);
            }
        } else if (object == this.m_btnEdit) {
            String string = this.runConnectionDialog(this.getConnectionName());
            if (!ModelUtil.hasLength((String)string) || this.resetConnections() > 0) {
                // empty if block
            }
            this.setConnectionName(string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkConnection();
    }

    protected void checkConnection() {
        String string = this.getConnectionName();
        Properties properties = null;
        Properties properties2 = properties = string == null ? null : s_conns.getConnectionInfo(string);
        if (properties != null) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        if (this.m_showDetails) {
            this.populateDetails(properties);
        }
    }

    public Component getDefaultFocusComponent() {
        if (this.m_connectionsModel.getSize() < 1) {
            return this.m_btnNew;
        }
        return this.m_connections;
    }

    public JComboBox getConnCombo() {
        return this.m_connections;
    }

    public int getConnectionCount() {
        return this.m_connectionsModel.getSize();
    }

    public void addComboListener(ItemListener itemListener) {
        this.m_connections.addItemListener(itemListener);
    }

    public void removeComboListener(ItemListener itemListener) {
        this.m_connections.removeItemListener(itemListener);
    }

    public static String getConnection(String string, String string2, String string3, boolean bl) {
        ConnectionPanelUI connectionPanelUI = new ConnectionPanelUI(bl, true);
        connectionPanelUI.setConnectionPrompt(string2);
        return ConnectionPanelUI.getConnection(connectionPanelUI, string, string3);
    }

    protected static String getConnection(final ConnectionPanelUI connectionPanelUI, String string, String string2) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionPanelUI, "f1_odbselectconnection_html");
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionPanelUI, (Component)connectionPanelUI.getDefaultFocusComponent(), (String)string);
        connectionPanelUI.addComboListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = connectionPanelUI.getConnectionName() != null;
                jEWTDialog.setOKButtonEnabled(bl);
            }
        });
        if (string2 != null) {
            connectionPanelUI.setConnectionName(string2);
        }
        jEWTDialog.setOKButtonEnabled(connectionPanelUI.getConnectionName() != null);
        Dimension dimension = new Dimension(400, 200);
        jEWTDialog.setMinimumSize(dimension);
        return WizardLauncher.runDialog((JDialog)jEWTDialog) ? connectionPanelUI.getConnectionName() : null;
    }

    public void setSelectedItem(String string) {
        this.m_connectionsModel.setSelectedItem(string);
    }
}

