/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AdvancedPanel;
import oracle.dbtools.raptor.connections.BasicPanel;
import oracle.dbtools.raptor.connections.BequeathConnectionPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.connections.LDAPConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.ProxyConnectionPanel;
import oracle.dbtools.raptor.connections.TNSPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.HyperLinkComponent;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;

public class OracleConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 530419491097270959L;
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    private JPanel _panel;
    private BasicPanel _basicPanel;
    private BequeathConnectionPanel _bequeathPanel;
    private AdvancedPanel _advancedPanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private TNSPanel _tNSPanel;
    private JLabel lblRole = new JLabel();
    private String[] roles = new String[]{Messages.getString("OracleConnectionPanel.2"), "SYSDBA"};
    private JComboBox cbxRole = new JComboBox<String>(this.roles);
    private CardLayout _layout;
    private JCheckBox chkProxy = new JCheckBox();
    private JLabel proxyLabel = new JLabel();
    private Properties proxyProps;
    public static final String HOST = "localhost";
    public static final String PORT = "1521";
    public static final String SID = "xe";
    public static final String ORACLE_CONNECTION_PANEL_TYPE = "OracleConnectionType";
    public static final String THIN_URL = "jdbc:oracle:thin:@";
    private JComboBox cbxAuthType = new JComboBox<OracleConnectionType>(OracleConnectionType.values());
    private JLabel lblAuthType = new JLabel();
    private LDAPConnectionPanel _ldapPanel;
    private JCheckBox chkOSAuth = new JCheckBox();
    private JCheckBox chkKerbAuth = new JCheckBox();
    public static final String OS_AUTHENTICATION = "OS_AUTHENTICATION";
    public static final String KERBEROS_AUTHENTICATION = "KERBEROS_AUTHENTICATION";

    public OracleConnectionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this._basicPanel = new BasicPanel(this);
        this._bequeathPanel = new BequeathConnectionPanel(this);
        this._tNSPanel = new TNSPanel(this);
        this._advancedPanel = new AdvancedPanel(this);
        this._ldapPanel = new LDAPConnectionPanel(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        this.topPanel = new JPanel(new GridBagLayout());
        this.bottomPanel = new JPanel(new GridBagLayout());
        this.topPanel.add((Component)this.lblAuthType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.cbxAuthType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.lblRole, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.cbxRole, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.lblRole, (Component)this.cbxRole, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_ROLE"));
        ResourceUtils.resLabel((JLabel)this.lblAuthType, (Component)this.cbxAuthType, (String)ConnectionDialogArb.getString("CONNECTION_TYPE"));
        this.add(this.topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._basicPanel, OracleConnectionType.BASIC.name());
        this._panel.add((Component)this._bequeathPanel, OracleConnectionType.BEQUEATH.name());
        this._panel.add((Component)this._tNSPanel, OracleConnectionType.TNS.name());
        this._panel.add((Component)this._advancedPanel, OracleConnectionType.ADVANCED.name());
        this._panel.add((Component)this._ldapPanel, OracleConnectionType.LDAP.name());
        this.add(this._panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 15), 0, 0));
        this.bottomPanel.add((Component)this.chkOSAuth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.bottomPanel.add((Component)this.chkKerbAuth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.bottomPanel.add((Component)this.chkProxy, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.bottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.chkKerbAuth, (String)ConnectionDialogArb.getString(KERBEROS_AUTHENTICATION));
        ResourceUtils.resButton((AbstractButton)this.chkProxy, (String)Messages.getString("OracleConnectionPanel.11"));
        ResourceUtils.resButton((AbstractButton)this.chkOSAuth, (String)ConnectionDialogArb.getString(OS_AUTHENTICATION));
        this.cbxAuthType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OracleConnectionPanel.this.togglePanels();
            }
        });
        this.chkKerbAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                if (actionEvent.getSource() instanceof JCheckBox && (bl = ((JCheckBox)actionEvent.getSource()).isSelected())) {
                    OracleConnectionPanel.this.chkOSAuth.setSelected(false);
                    OracleConnectionPanel.this.getDialog().useUserName(true);
                    OracleConnectionPanel.this.getDialog().usePassword(true);
                }
            }
        });
        this.chkOSAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JCheckBox) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    if (bl) {
                        OracleConnectionPanel.this.chkKerbAuth.setSelected(false);
                    }
                    OracleConnectionPanel.this.getDialog().useUserName(!bl);
                    OracleConnectionPanel.this.getDialog().usePassword(!bl);
                }
            }
        });
        this.chkProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JCheckBox) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                        OracleConnectionPanel.this.setProxySelected(true);
                    } else {
                        OracleConnectionPanel.this.setProxySelected(false);
                    }
                }
            }
        });
    }

    private void setProxySelected(boolean bl) {
        block7: {
            if (bl) {
                if (this.proxyProps == null) {
                    this.proxyProps = new Properties();
                }
                try {
                    ProxyConnectionPanel.showProxyPanel(this.proxyProps);
                    HyperLinkComponent.makeLink((JLabel)this.proxyLabel);
                    boolean bl2 = true;
                    for (MouseListener mouseListener : this.proxyLabel.getMouseListeners()) {
                        if (!(mouseListener instanceof LabelMouseListener)) continue;
                        bl2 = false;
                    }
                    if (bl2) {
                        this.proxyLabel.addMouseListener(new LabelMouseListener());
                    }
                    break block7;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().equals("Proxy Cancelled")) {
                        this.chkProxy.setSelected(false);
                    }
                    break block7;
                }
            }
            HyperLinkComponent.removeLink((JLabel)this.proxyLabel);
            this.proxyProps.remove("IS_PROXY");
        }
    }

    private void updateProxySelected() {
        try {
            ProxyConnectionPanel.showProxyPanel(this.proxyProps);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void togglePanels() {
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.BASIC)) {
            this._layout.show(this._panel, OracleConnectionType.BASIC.name());
        } else if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.TNS)) {
            this._layout.show(this._panel, OracleConnectionType.TNS.name());
        } else if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.BEQUEATH)) {
            this._layout.show(this._panel, OracleConnectionType.BEQUEATH.name());
        } else if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.ADVANCED)) {
            this._layout.show(this._panel, OracleConnectionType.ADVANCED.name());
        } else if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.LDAP)) {
            this._layout.show(this._panel, OracleConnectionType.LDAP.name());
        }
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", DRIVER_CLASS_NAME);
        properties.setProperty("oraDriverType", "thin");
        properties.setProperty("RaptorConnectionType", "Oracle");
        String string = (String)this.cbxRole.getSelectedItem();
        properties.setProperty("role", string.equals(this.roles[0]) ? "" : string);
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(properties);
        properties.setProperty(OS_AUTHENTICATION, Boolean.toString(this.chkOSAuth.isSelected()));
        if (this.chkOSAuth.isSelected() || this.chkKerbAuth.isSelected()) {
            properties.setProperty("NoPasswordConnection", "FALSE");
        } else {
            properties.setProperty("NoPasswordConnection", "TRUE");
        }
        properties.setProperty(KERBEROS_AUTHENTICATION, Boolean.toString(this.chkKerbAuth.isSelected()));
        this.getProxyInputs(properties);
        return properties;
    }

    private void getProxyInputs(Properties properties) {
        if (this.proxyProps != null) {
            properties.putAll((Map<?, ?>)this.proxyProps);
        }
    }

    private CDComponentView getPanel() {
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.BASIC)) {
            return this._basicPanel;
        }
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.BEQUEATH)) {
            return this._bequeathPanel;
        }
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.TNS)) {
            return this._tNSPanel;
        }
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.ADVANCED)) {
            return this._advancedPanel;
        }
        if (this.cbxAuthType.getSelectedItem().equals((Object)OracleConnectionType.LDAP)) {
            return this._ldapPanel;
        }
        return null;
    }

    @Override
    protected void testConnection(Properties properties) throws ConnectionException {
        String string = properties.getProperty("customUrl");
        super.testConnection(properties);
        this.getDialog().setPassword(properties.getProperty("password"));
    }

    @Override
    public void clear() {
        this._basicPanel.clear();
        this._tNSPanel.clear();
        this._advancedPanel.clear();
        this._ldapPanel.clear();
    }

    private OracleConnectionType getOracleType(Properties properties) {
        String string = properties.getProperty(ORACLE_CONNECTION_PANEL_TYPE);
        if (string != null) {
            try {
                return OracleConnectionType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String string2 = properties.getProperty("hostname");
        String string3 = properties.getProperty("sid");
        String string4 = properties.getProperty("serviceName");
        if (ModelUtil.hasLength((String)string2) && (ModelUtil.hasLength((String)string3) || ModelUtil.hasLength((String)string4))) {
            return OracleConnectionType.BASIC;
        }
        String string5 = properties.getProperty("customUrl");
        if (string5 != null && !string5.startsWith("jdbc:")) {
            return OracleConnectionType.TNS;
        }
        return OracleConnectionType.ADVANCED;
    }

    @Override
    public void updatePrompts(Properties properties) {
        MouseListener[] mouseListenerArray;
        String string;
        String string2 = properties.getProperty("hostname");
        String string3 = properties.getProperty("role");
        OracleConnectionType oracleConnectionType = this.getOracleType(properties);
        if (string3 != null && string3.equals("SYSDBA")) {
            this.cbxRole.setSelectedIndex(1);
        } else {
            this.cbxRole.setSelectedIndex(0);
        }
        if (oracleConnectionType == OracleConnectionType.BASIC) {
            this.cbxAuthType.setSelectedItem((Object)OracleConnectionType.BASIC);
            this._basicPanel.tfdHost.setText(string2);
            string = properties.getProperty("port");
            this._basicPanel.tfdPort.setText(string != null ? string : PORT);
            mouseListenerArray = properties.getProperty("sid");
            this._basicPanel.tfdSid.setText((String)mouseListenerArray);
            String string4 = properties.getProperty("serviceName");
            this._basicPanel.tfdService.setText(string4);
            if (ModelUtil.hasLength((String)mouseListenerArray)) {
                this._basicPanel.btnSid.setSelected(true);
                this._basicPanel.btnService.setSelected(false);
            } else {
                this._basicPanel.btnService.setSelected(true);
                this._basicPanel.btnSid.setSelected(false);
            }
        } else if (oracleConnectionType == OracleConnectionType.TNS) {
            this.cbxAuthType.setSelectedItem((Object)OracleConnectionType.TNS);
            string = properties.getProperty("customUrl");
            mouseListenerArray = string.substring(string.lastIndexOf(64) + 1);
            this._tNSPanel.cbxTnsName.setSelectedItem(mouseListenerArray);
            if (this._tNSPanel.cbxTnsName.getSelectedItem() != null && this._tNSPanel.cbxTnsName.getSelectedItem().equals(mouseListenerArray)) {
                this._tNSPanel.btnTns.setSelected(true);
            } else {
                this._tNSPanel.tfdSqlNetName.setText((String)mouseListenerArray);
                this._tNSPanel.btnSqlNet.setSelected(true);
            }
        } else if (oracleConnectionType == OracleConnectionType.LDAP) {
            this.cbxAuthType.setSelectedItem((Object)OracleConnectionType.LDAP);
            this._ldapPanel.updatePrompts(properties);
        } else if (oracleConnectionType == OracleConnectionType.BEQUEATH) {
            this.cbxAuthType.setSelectedItem((Object)OracleConnectionType.BEQUEATH);
            this._bequeathPanel.populateComponent(properties);
        } else {
            this.cbxAuthType.setSelectedItem((Object)OracleConnectionType.ADVANCED);
            string = properties.getProperty("customUrl");
            this._advancedPanel.tfdUrl.setText(string);
        }
        properties.put("ConnName", this.getConnectionName());
        if (properties.get("IS_PROXY") != null && Boolean.parseBoolean(properties.getProperty("IS_PROXY"))) {
            HyperLinkComponent.makeLink((JLabel)this.proxyLabel);
            boolean bl = true;
            for (MouseListener mouseListener : this.proxyLabel.getMouseListeners()) {
                if (!(mouseListener instanceof LabelMouseListener)) continue;
                bl = false;
            }
            if (bl) {
                this.proxyLabel.addMouseListener(new LabelMouseListener());
            }
            this.chkProxy.setSelected(true);
            this.proxyProps = new Properties();
            this.proxyProps.setProperty("IS_PROXY", properties.getProperty("IS_PROXY"));
            this.proxyProps.setProperty("PROXY_TYPE", properties.getProperty("PROXY_TYPE"));
            this.proxyProps.setProperty("PROXY_USER_NAME", properties.getProperty("PROXY_USER_NAME"));
            if (properties.getProperty("PROXY_USER_PASSWORD") != null) {
                this.proxyProps.setProperty("PROXY_USER_PASSWORD", properties.getProperty("PROXY_USER_PASSWORD"));
            }
            if (properties.getProperty("PROXY_DISTINGUISHED_NAME") != null) {
                this.proxyProps.setProperty("PROXY_DISTINGUISHED_NAME", properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            }
        } else {
            this.chkProxy.setSelected(false);
            this.proxyProps = new Properties();
        }
        boolean bl = Boolean.parseBoolean(properties.getProperty(OS_AUTHENTICATION));
        this.chkOSAuth.setSelected(bl);
        this.getDialog().useUserName(!bl);
        this.getDialog().usePassword(!bl);
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(KERBEROS_AUTHENTICATION));
        this.chkKerbAuth.setSelected(bl2);
    }

    @Override
    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    @Override
    public String getDriver() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public void setDialog(ConnectionDialog connectionDialog) {
        super.setDialog(connectionDialog);
        this.getDialog().attachEnterKey(this._basicPanel);
        this.getDialog().attachEnterKey(this._bequeathPanel);
        this.getDialog().attachEnterKey(this._advancedPanel);
        this.getDialog().attachEnterKey(this._tNSPanel);
    }

    @Override
    public void setDefaultPrompts() {
        this._basicPanel.setDefaultPrompts();
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    @Override
    public String getConnectionType() {
        return "Oracle";
    }

    private final class LabelMouseListener
    extends MouseAdapter {
        private LabelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            OracleConnectionPanel.this.updateProxySelected();
        }
    }
}

