/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportModesPreferences
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -2739487292165944123L;
    private JComboBox _newImportMode;
    private JComboBox _existingImportMode;
    private int _newImportModeOption;
    private int _existingImportModeOption;
    protected ImportDataFormat _dataFormat;

    public ImportModesPreferences() {
        this.setHelpID("f1_dbworksheetImportparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 1;
        String[] stringArray = ImportDataFormat.NEW_METHODS;
        this._newImportMode = new JComboBox<String>(stringArray);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("NEW_IMPORT_MODE")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("NEW_IMPORT_MODE")));
        jLabel.setLabelFor(this._newImportMode);
        String[] stringArray2 = ImportDataFormat.EXISTING_METHODS;
        this._existingImportMode = new JComboBox<String>(stringArray2);
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("EXISTING_IMPORT_MODE")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("EXISTING_IMPORT_MODE")));
        jLabel2.setLabelFor(this._existingImportMode);
        this.add(jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 0, 0, 8), 0, 0));
        this.add(this._existingImportMode, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 0, 0, 8), 0, 0));
        this.add(this._newImportMode, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this._newImportModeOption = dBConfig.getInt("IMPORT_NEW_MODE");
        this._existingImportModeOption = dBConfig.getInt("IMPORT_EXISTING_MODE");
        this._newImportMode.setSelectedItem(ImportDataFormat.getLoadMethodName(this._newImportModeOption));
        this._existingImportMode.setSelectedItem(ImportDataFormat.getLoadMethodName(this._existingImportModeOption));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("IMPORT_NEW_MODE", ImportDataFormat.getLoadMethodType((String)this._newImportMode.getSelectedItem()));
        dBConfig.putInt("IMPORT_EXISTING_MODE", ImportDataFormat.getLoadMethodType((String)this._existingImportMode.getSelectedItem()));
    }
}

