/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public final class CodeCompletionOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ActionListener {
    private JCheckBox checkbox_WScompletionEnablePopup = new JCheckBox();
    private JSlider slider_WScompletionPopupDelay = new JSlider(1, 30, 10);
    private JLabel label_WScompletionSliderMax = new JLabel(Messages.getString("label_PLScompletionSliderMax"));
    private JLabel label_WScompletionSliderMin = new JLabel(Messages.getString("label_PLScompletionSliderMin"));
    private JLabel label_WScompletionPopupDelayText = new JLabel();
    private JCheckBox checkbox_PLScompletionEnablePopup = new JCheckBox();
    private JSlider slider_PLScompletionPopupDelay = new JSlider(1, 30, 10);
    private JLabel label_PLScompletionSliderMax = new JLabel(Messages.getString("label_PLScompletionSliderMax"));
    private JLabel label_PLScompletionSliderMin = new JLabel(Messages.getString("label_PLScompletionSliderMin"));
    private JLabel label_PLScompletionPopupDelayText = new JLabel();
    private JCheckBox checkbox_autoGenerateAliases = new JCheckBox();
    private JCheckBox checkbox_autoGenerateGroupBy = new JCheckBox();
    private JCheckBox checkbox_autoGenerateGroupByIncrementally = new JCheckBox();
    private JCheckBox checkbox_autoFormat = new JCheckBox();
    private JComboBox combo_formats = new JComboBox();
    private NumberFormat numberFormatter;

    public CodeCompletionOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.setLayout(new GridBagLayout());
        this.jbInit();
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        Boolean bl = dBConfig.getBoolean("ENABLECOMPLETIONWORKSHEET");
        this.checkbox_WScompletionEnablePopup.setSelected(bl);
        bl = dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR");
        this.checkbox_PLScompletionEnablePopup.setSelected(bl);
        int n = dBConfig.getInt("DELAYCOMPLETIONWORKSHEET");
        this.slider_WScompletionPopupDelay.setValue(n / 100);
        n = dBConfig.getInt("DELAYCOMPLETIONPLSQLEDITOR");
        this.slider_PLScompletionPopupDelay.setValue(n / 100);
        bl = dBConfig.getBoolean("AUTOGENERATEALIASES");
        this.checkbox_autoGenerateAliases.setSelected(bl);
        bl = dBConfig.getBoolean("AUTOGENERATEGROUPBY");
        this.checkbox_autoGenerateGroupBy.setSelected(bl);
        this.checkbox_autoGenerateGroupByIncrementally.setEnabled(bl);
        bl = dBConfig.getBoolean("AUTOGENERATEGROUPBYINCREMENTALLY");
        this.checkbox_autoGenerateGroupByIncrementally.setSelected(bl);
        bl = dBConfig.getBoolean("AUTOFORMAT");
        this.checkbox_autoFormat.setSelected(bl);
        this.combo_formats.setModel(new DefaultComboBoxModel<CaseConverter.CASE>(CaseConverter.CASE.values()));
        this.combo_formats.setSelectedItem((Object)CaseConverter.getState());
        this.combo_formats.setEnabled(bl);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("ENABLECOMPLETIONWORKSHEET", this.checkbox_WScompletionEnablePopup.isSelected());
        dBConfig.putBoolean("ENABLECOMPLETIONPLSQLEDITOR", this.checkbox_PLScompletionEnablePopup.isSelected());
        dBConfig.putInt("DELAYCOMPLETIONWORKSHEET", this.slider_WScompletionPopupDelay.getValue() * 100);
        dBConfig.putInt("DELAYCOMPLETIONPLSQLEDITOR", this.slider_PLScompletionPopupDelay.getValue() * 100);
        dBConfig.putBoolean("AUTOGENERATEALIASES", this.checkbox_autoGenerateAliases.isSelected());
        dBConfig.putBoolean("AUTOGENERATEGROUPBY", this.checkbox_autoGenerateGroupBy.isSelected());
        dBConfig.putBoolean("AUTOGENERATEGROUPBYINCREMENTALLY", this.checkbox_autoGenerateGroupByIncrementally.isSelected());
        dBConfig.putBoolean("AUTOFORMAT", this.checkbox_autoFormat.isSelected());
        Object object = this.combo_formats.getSelectedItem();
        NonUserConfigOptions.put("CaseConverter.state", object.toString());
    }

    private void jbInit() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        ResourceUtils.resButton((AbstractButton)this.checkbox_WScompletionEnablePopup, (String)Messages.getString("CodeCompletionOptionsPanel.1"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_PLScompletionEnablePopup, (String)Messages.getString("CodeCompletionOptionsPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenerateAliases, (String)Messages.getString("CodeCompletionOptionsPanel.3"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenerateGroupBy, (String)Messages.getString("Autogenerate_GROUP_BY_clause"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenerateGroupByIncrementally, (String)Messages.getString("Incrementally"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoFormat, (String)Messages.getString("AutoFormat"));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.slider_WScompletionPopupDelay, (String)Messages.getString("CodeCompletionOptionsPanel.4"));
        this.slider_WScompletionPopupDelay.setPaintLabels(false);
        this.slider_WScompletionPopupDelay.setPaintTicks(true);
        this.slider_WScompletionPopupDelay.setMajorTickSpacing(10);
        this.slider_WScompletionPopupDelay.setMinorTickSpacing(1);
        this.slider_WScompletionPopupDelay.setSnapToTicks(true);
        this.slider_WScompletionPopupDelay.addChangeListener(this);
        Component[] componentArray = new Component[]{this.slider_WScompletionPopupDelay, jLabel, this.label_WScompletionPopupDelayText, this.label_WScompletionSliderMin, this.label_WScompletionSliderMax};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_WScompletionEnablePopup, componentArray);
        this.checkbox_WScompletionEnablePopup.addItemListener((ItemListener)itemSelectableTracker);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.slider_PLScompletionPopupDelay, (String)Messages.getString("CodeCompletionOptionsPanel.5"));
        this.slider_PLScompletionPopupDelay.setPaintLabels(false);
        this.slider_PLScompletionPopupDelay.setPaintTicks(true);
        this.slider_PLScompletionPopupDelay.setMajorTickSpacing(10);
        this.slider_PLScompletionPopupDelay.setMinorTickSpacing(1);
        this.slider_PLScompletionPopupDelay.setSnapToTicks(true);
        this.slider_PLScompletionPopupDelay.addChangeListener(this);
        componentArray = new Component[]{this.slider_PLScompletionPopupDelay, jLabel2, this.label_PLScompletionPopupDelayText, this.label_PLScompletionSliderMin, this.label_PLScompletionSliderMax};
        itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_PLScompletionEnablePopup, componentArray);
        this.checkbox_PLScompletionEnablePopup.addItemListener((ItemListener)itemSelectableTracker);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 5, 5);
        Insets insets3 = new Insets(0, 18, 5, 0);
        Insets insets4 = new Insets(0, 18, 7, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.checkbox_WScompletionEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, insets3, 0, 0);
        jPanel.add((Component)this.label_WScompletionSliderMin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.slider_WScompletionPopupDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0);
        jPanel.add((Component)this.label_WScompletionSliderMax, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        jPanel.add((Component)this.label_WScompletionPopupDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        gridBagConstraints = new GridBagConstraints(0, n, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_PLScompletionEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_PLScompletionSliderMin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.slider_PLScompletionPopupDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 18, 0, insets2, 0, 0);
        jPanel2.add((Component)this.label_PLScompletionSliderMax, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        jPanel2.add((Component)this.label_PLScompletionPopupDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.2, 17, 0, insets, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_autoGenerateAliases, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_autoFormat, gridBagConstraints);
        this.checkbox_autoFormat.addActionListener(this);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        this.add(this.combo_formats, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_autoGenerateGroupBy, gridBagConstraints);
        this.checkbox_autoGenerateGroupBy.addActionListener(this);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        this.add(this.checkbox_autoGenerateGroupByIncrementally, gridBagConstraints);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JLabel jLabel;
        JSlider jSlider;
        Object object = changeEvent.getSource();
        if (object == this.slider_WScompletionPopupDelay) {
            jSlider = this.slider_WScompletionPopupDelay;
            jLabel = this.label_WScompletionPopupDelayText;
        } else if (object == this.slider_PLScompletionPopupDelay) {
            jSlider = this.slider_PLScompletionPopupDelay;
            jLabel = this.label_PLScompletionPopupDelayText;
        } else {
            throw new IllegalStateException(Messages.getString("CodeCompletionOptionsPanel.10"));
        }
        float f = (float)jSlider.getValue() / 10.0f;
        String string = OptionsArb.format((int)142, (Object)this.numberFormatter.format(f));
        jLabel.setText(string);
        jSlider.setToolTipText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.combo_formats.setEnabled(this.checkbox_autoFormat.isSelected());
        this.checkbox_autoGenerateGroupByIncrementally.setEnabled(this.checkbox_autoGenerateGroupBy.isSelected());
    }
}

