/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.TnsnamesDirChooser;
import oracle.dbtools.raptor.controls.PositiveNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class AdvancedInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JTextField m_arraySize = new PositiveNumberField(){

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() > 0 && number.intValue() <= 500;
        }
    };
    private JTextField m_nullDisplay = new JTextField();
    private JTextField m_kerberosConfig = new JTextField();
    private JTextField m_kerberosCache = new JTextField();
    private TnsnamesDirChooser m_tnsnamesFile = new TnsnamesDirChooser();
    private JCheckBox m_chkAutocommit = new JCheckBox();
    private JComboBox m_nullColor = new JComboBox();
    private static String[] _colors = new String[]{"NONE", "BLUE", "GRAY", "LIGHT_GRAY", "BLACK", "RED", "PINK", "ORANGE", "YELLOW", "GREEN"};
    private JCheckBox m_chkDriverPref = new JCheckBox();
    private JCheckBox m_displayStructValueInGrid = new JCheckBox();

    public AdvancedInfo() {
        this.setHelpID("f1_cdbdprefadvanced_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_chkAutocommit.setSelected(dBConfig.getBoolean("AUTOCOMMIT"));
        this.m_arraySize.setText(dBConfig.getString("ARRAYFETCHSIZE"));
        this.m_nullDisplay.setText(dBConfig.getString("NULLDISPLAY"));
        this.m_nullColor.setModel(new DefaultComboBoxModel<String>(_colors));
        this.m_nullColor.setSelectedItem(dBConfig.getString("NULLCOLOR"));
        this.m_displayStructValueInGrid.setSelected(dBConfig.getBoolean("DISPLAY_STRUCT_VALUE_IN_GRID"));
        this.m_chkDriverPref.setSelected(dBConfig.getBoolean("USE_THICK_DRIVER"));
        this.m_kerberosConfig.setText(dBConfig.getString("KERBEROS_CONFIG"));
        this.m_kerberosCache.setText(dBConfig.getString("KERBEROS_CACHE"));
        this.m_tnsnamesFile.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("ARRAYFETCHSIZE", this.m_arraySize.getText());
        dBConfig.putString("NULLDISPLAY", this.m_nullDisplay.getText());
        dBConfig.putString("NULLCOLOR", (String)this.m_nullColor.getSelectedItem());
        dBConfig.putBoolean("DISPLAY_STRUCT_VALUE_IN_GRID", this.m_displayStructValueInGrid.isSelected());
        dBConfig.putBoolean("USE_THICK_DRIVER", this.m_chkDriverPref.isSelected());
        dBConfig.putBoolean("AUTOCOMMIT", this.m_chkAutocommit.isSelected());
        dBConfig.putString("KERBEROS_CONFIG", this.m_kerberosConfig.getText());
        dBConfig.putString("KERBEROS_CACHE", this.m_kerberosCache.getText());
        this.m_tnsnamesFile.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("ARRAYFETCHSIZE")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("ARRAYFETCHSIZE")));
        jLabel.setLabelFor(this.m_arraySize);
        this.add(jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.m_arraySize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("NULLDISPLAY")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("NULLDISPLAY")));
        jLabel2.setLabelFor(this.m_nullDisplay);
        this.add(jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.m_nullDisplay, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("NULLCOLOR")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("NULLCOLOR")));
        jLabel3.setLabelFor(this.m_nullColor);
        this.add(jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.m_nullColor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        jLabel4.setLabelFor(this.m_displayStructValueInGrid);
        this.add(jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        this.add(this.m_displayStructValueInGrid, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel5 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("USE_THICK_DRIVER")));
        jLabel5.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("USE_THICK_DRIVER")));
        this.m_chkDriverPref.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("USE_THICK_DRIVER")));
        this.add(jLabel5, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        this.add(this.m_chkDriverPref, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel6 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("AUTOCOMMIT")));
        jLabel6.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("AUTOCOMMIT")));
        this.m_chkAutocommit.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("AUTOCOMMIT")));
        this.add(jLabel6, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        this.add(this.m_chkAutocommit, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, PreferencesArb.getString("KERBEROS_THIN_CONFIG"), 0, 0, null, null));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(10, 5, 0, 0);
        JLabel jLabel7 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("KERBEROS_CONFIG")));
        jLabel7.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("KERBEROS_CONFIG")));
        jLabel7.setLabelFor(this.m_kerberosConfig);
        jPanel.add((Component)jLabel7, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)this.m_kerberosConfig, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.fill = 0;
        JLabel jLabel8 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("KERBEROS_CACHE")));
        jLabel8.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("KERBEROS_CACHE")));
        jLabel8.setLabelFor(this.m_kerberosCache);
        jPanel.add((Component)jLabel8, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)this.m_kerberosCache, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)((Object)this.m_tnsnamesFile), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

