/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class AbstractCloudFilter<V extends Subject>
extends BaseRaptorFilter {
    private List<Element> m_children;

    protected static boolean isCancel(Throwable throwable) {
        if (throwable instanceof AuthenticationFailedException) {
            return ((AuthenticationFailedException)((Object)throwable)).isCanceled();
        }
        return false;
    }

    protected final V getOwningElement() {
        return (V)((Subject)this.getOwner().getData());
    }

    public final Iterator<Element> getChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            V v = this.getOwningElement();
            CloudTask<List<Element>> cloudTask = this.getTask();
            cloudTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((Subject)v, cloudTask){
                final /* synthetic */ Subject val$elem;
                final /* synthetic */ RaptorTask val$task;
                {
                    this.val$elem = subject;
                    this.val$task = raptorTask;
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Throwable throwable = raptorTaskEvent.getThrowable();
                    if (!AbstractCloudFilter.isCancel(throwable)) {
                        ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                        if (SwingUtilities.isEventDispatchThread()) {
                            exceptionDialogRunnable.run();
                        } else {
                            try {
                                SwingUtilities.invokeLater(exceptionDialogRunnable);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    AbstractCloudFilter.this.cleanupOnError(this.val$elem);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    UpdateMessage.fireChildRemoved((Subject)this.val$elem, (Element)DummyElement.INSTANCE);
                    try {
                        List list = (List)this.val$task.getResult();
                        UpdateMessage.fireChildrenAdded((Subject)this.val$elem, (Collection)list);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask(cloudTask);
            this.m_children.add(DummyElement.INSTANCE);
        }
        return this.m_children.iterator();
    }

    protected void cleanupOnError(V v) {
        SwingUtilities.invokeLater(new Runnable((Subject)v){
            final /* synthetic */ Subject val$elem;
            {
                this.val$elem = subject;
            }

            @Override
            public void run() {
                if (this.val$elem instanceof Node) {
                    Node node = (Node)this.val$elem;
                    try {
                        node.close();
                    }
                    catch (Exception exception) {}
                } else if (this.val$elem instanceof Subject) {
                    UpdateMessage.fireObjectClosed((Subject)this.val$elem);
                }
            }
        });
    }

    protected abstract CloudTask<List<Element>> getTask();

    protected final void addChild(Element element) {
        this.m_children.add(element);
    }

    protected final void removeChild(Element element) {
        this.m_children.remove(element);
    }

    public final void closeChildren() {
        if (this.m_children != null) {
            this.m_children.clear();
            this.m_children = null;
        }
        this.clearCache();
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
            this.addChild(element);
            tNode2.getChildFilter();
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 != null) {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                this.uncache(tNode2);
            }
            this.removeChild(element);
        }
        return tNode;
    }
}

