/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.net.URI;
import javax.ide.net.URIFactory;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class PrivateHostPanel
implements Traversable {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private JRadioButton m_btnHttp = new JRadioButton();
    private JRadioButton m_btnHttps = new JRadioButton();
    private ButtonGroup m_grp = new ButtonGroup();
    private JTextField m_fldHost = new JTextField();
    private WholeNumberField m_port = new WholeNumberField(5);
    private JTextField m_fldServerPath = new JTextField();
    private JLabel m_lblServicePath = new JLabel();
    private JTextField m_fldServicePath = new JTextField();

    public PrivateHostPanel() {
        this.m_grp.add(this.m_btnHttp);
        this.m_grp.add(this.m_btnHttps);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_grp.clearSelection();
        URI uRI = (URI)traversableContext.get("Cloud.Root");
        if (uRI != null) {
            String string;
            String string2 = uRI.getScheme();
            if (HTTPS_PROTOCOL.equals(string2)) {
                this.m_btnHttps.setSelected(true);
            } else {
                this.m_btnHttp.setSelected(true);
            }
            this.m_fldHost.setText(uRI.getHost());
            int n = uRI.getPort();
            if (n == -1) {
                this.m_port.setText("");
            } else {
                this.m_port.setNumber((Number)n);
            }
            String string3 = uRI.getPath();
            this.m_fldServerPath.setText(string3);
            URI uRI2 = (URI)traversableContext.get("Cloud.ServiceURI");
            if (uRI2 != null && (string = uRI2.getPath()).startsWith(string3)) {
                String string4 = string.substring(string3.length());
                this.m_fldServicePath.setText(string4);
            }
        } else {
            this.m_btnHttp.setSelected(true);
            this.m_port.setNumber((Number)80);
            this.m_fldServerPath.setText("/apex");
        }
        this.enableServiceName(!Boolean.TRUE.equals(traversableContext.get("Cloud.HideServiceName")));
    }

    private void enableServiceName(boolean bl) {
        this.m_fldServicePath.setVisible(bl);
        this.m_lblServicePath.setVisible(bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_btnHttps.isSelected() ? HTTPS_PROTOCOL : HTTP_PROTOCOL;
        String string2 = this.m_fldHost.getText().trim();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_HOST"));
        }
        Number number = this.m_port.getNumber();
        int n = number != null ? number.intValue() : -1;
        String string3 = this.m_fldServerPath.getText();
        if (ModelUtil.hasLength((String)string3) && !string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        URI uRI = URIFactory.newURI((String)string, null, (String)string2, (int)n, (String)string3, null, null);
        traversableContext.put("Cloud.Root", (Object)uRI);
        if (this.m_fldServicePath.isVisible()) {
            URI uRI2 = URIFactory.newDirURI((URI)uRI, (String)this.m_fldServicePath.getText());
            traversableContext.put("Cloud.ServiceURI", (Object)uRI2);
        }
    }

    public void createComponent(JPanel jPanel, int n) {
        int n2 = n;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        ResourceUtils.resButton((AbstractButton)this.m_btnHttp, (String)HTTP_PROTOCOL);
        ResourceUtils.resButton((AbstractButton)this.m_btnHttps, (String)HTTPS_PROTOCOL);
        jPanel2.add((Component)this.m_btnHttp, LayoutControl.GBC.gbc(0, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_btnHttps, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring(jPanel2, 2);
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc(0, n2, 4, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldHost, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_HOSTNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_fldHost, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_port, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_PORT"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_port, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldServerPath, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_PATH"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_fldServerPath, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resLabel((JLabel)this.m_lblServicePath, (Component)this.m_fldServicePath, (String)"Service Name");
        jPanel.add((Component)this.m_lblServicePath, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y));
        jPanel.add((Component)this.m_fldServicePath, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.XY));
        LayoutControl.GBC.addVSpring(jPanel, 3);
    }

    public Component getComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.createComponent(jPanel, 0);
        return jPanel;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_advcloudconnection_html";
    }

    public Component getInitialFocusComponent() {
        return this.m_fldHost;
    }
}

