/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.listener;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.cloud.connection.ui.PrivateHostPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class ListenerConnectionPanel
extends BaseConnectionPanel {
    private static final String BASE_DEFAULT_NAME = "Connection";
    private final PrivateHostPanel m_host = new PrivateHostPanel();
    protected JTextField m_user = new JTextField();

    @Override
    public String getCreateTitle() {
        return CloudBrowserResources.getString("NEW_LISTENER_TITLE");
    }

    @Override
    public String getEditTitle() {
        return CloudBrowserResources.getString("EDIT_LISTENER_TITLE");
    }

    @Override
    protected String getBaseDefaultName() {
        return BASE_DEFAULT_NAME;
    }

    public String getHelpID() {
        return null;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_user.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_USERNAME"));
        }
        traversableContext.put("Cloud.Username", (Object)string);
        this.m_host.onExit(traversableContext);
        URI uRI = (URI)traversableContext.get("Cloud.Root");
        traversableContext.put("Cloud.ServiceURI", (Object)uRI);
        super.onExit(traversableContext);
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        traversableContext.put("Cloud.HideServiceName", (Object)Boolean.TRUE);
        super.onEntry(traversableContext);
        String string = (String)traversableContext.get("Cloud.Username");
        if (string != null) {
            this.m_user.setText(string);
        }
        this.m_host.onEntry(traversableContext);
    }

    @Override
    protected final Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(Math.max(dimension.width, 300), dimension.height);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            }
        };
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_name, (String)CloudBrowserResources.getString("NEW_CONN_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_name, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_user, (String)CloudBrowserResources.getString("NEW_CONN_USERNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_user, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.m_host.createComponent(jPanel, 2);
        return jPanel;
    }
}

