/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.Client;

class ConnectionCreator {
    private CConnectionType m_type;

    ConnectionCreator(CConnectionType cConnectionType) {
        this.m_type = cConnectionType;
    }

    CConnection createConnection(CConnectionInfo cConnectionInfo) throws CConnectionException {
        Authentication authentication;
        String string = cConnectionInfo.getName();
        Client client = Client.getClient(this.m_type, cConnectionInfo);
        try {
            authentication = client.getAuthenticationEngine().authenticate(cConnectionInfo);
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            throw new CConnectionException((Throwable)((Object)authenticationFailedException));
        }
        CConnection cConnection = new CConnection(cConnectionInfo, client, authentication);
        cConnection.open();
        return cConnection;
    }
}

