/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.io.IOException;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.raptor.utils.StreamCopy;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public abstract class CloudHander<T>
implements ResponseHandler<T> {
    public final T handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        T t = null;
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        switch (n) {
            case 200: {
                t = this.handleSuccess(httpResponse);
                break;
            }
            case 500: {
                this.report500Error(httpResponse);
            }
            default: {
                t = this.handleError(httpResponse);
            }
        }
        return t;
    }

    protected final void report500Error(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        Header header = httpResponse.getEntity().getContentType();
        throw this.createInternalServerError(statusLine.toString(), StreamCopy.string(Client.createReader(httpResponse)), header.getValue());
    }

    protected abstract T handleSuccess(HttpResponse var1) throws ClientProtocolException, IOException;

    protected abstract IOException createInternalServerError(String var1, String var2, String var3);

    protected abstract T handleError(HttpResponse var1) throws ClientProtocolException, IOException;
}

